/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.nullness.quals.Covariant;
import checkers.nullness.quals.KeyFor;
import checkers.nullness.quals.KeyForBottom;
import checkers.quals.DefaultLocation;
import checkers.quals.TypeQualifiers;
import checkers.quals.Unqualified;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeHierarchy;
import checkers.util.AnnotationBuilder;
import checkers.util.GraphQualifierHierarchy;
import checkers.util.MultiGraphQualifierHierarchy;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javacutils.AnnotationUtils;
import javacutils.ErrorReporter;
import javacutils.Pair;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;

@TypeQualifiers(value={KeyFor.class, Unqualified.class, KeyForBottom.class})
public class KeyForAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror UNQUALIFIED;
    protected final AnnotationMirror KEYFOR;
    private static final Pattern parameterPtn = Pattern.compile("#(\\d+)");

    public KeyForAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker, false);
        this.KEYFOR = AnnotationUtils.fromClass(this.elements, KeyFor.class);
        this.UNQUALIFIED = AnnotationUtils.fromClass(this.elements, Unqualified.class);
        this.postInit();
        this.defaults.addAbsoluteDefault(this.UNQUALIFIED, DefaultLocation.ALL);
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree call) {
        assert (call != null);
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(call);
        AnnotatedTypeMirror method = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> mappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>();
        List<AnnotatedTypeMirror> params = method.getParameterTypes();
        for (AnnotatedTypeMirror param : params) {
            AnnotatedTypeMirror subst = this.substituteCall(call, param);
            mappings.put(param, subst);
        }
        AnnotatedTypeMirror returnType = method.getReturnType();
        if (returnType.getKind() != TypeKind.VOID) {
            AnnotatedTypeMirror subst = this.substituteCall(call, returnType);
            mappings.put(returnType, subst);
        }
        method = method.substitute(mappings);
        return Pair.of(method, mfuPair.second);
    }

    private String receiver(MethodInvocationTree node) {
        ExpressionTree sel = node.getMethodSelect();
        if (sel.getKind() == Tree.Kind.IDENTIFIER) {
            return "";
        }
        if (sel.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)sel).getExpression().toString();
        }
        ErrorReporter.errorAbort("KeyForAnnotatedTypeFactory.receiver: cannot be here");
        return null;
    }

    private AnnotatedTypeMirror substituteCall(MethodInvocationTree call, AnnotatedTypeMirror inType) {
        AnnotatedTypeMirror outType = inType.getCopy(true);
        AnnotationMirror anno = inType.getAnnotation(KeyFor.class);
        if (anno != null) {
            List<String> inMaps = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
            ArrayList<Object> outMaps = new ArrayList<Object>();
            String receiver = this.receiver(call);
            for (String inMapName : inMaps) {
                if (parameterPtn.matcher(inMapName).matches()) {
                    int param = Integer.valueOf(inMapName.substring(1));
                    if (param <= 0 || param > call.getArguments().size()) continue;
                    String res = call.getArguments().get(param - 1).toString();
                    outMaps.add(res);
                    continue;
                }
                if (inMapName.equals("this")) {
                    outMaps.add(receiver);
                    continue;
                }
                outMaps.add(inMapName);
            }
            AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, KeyFor.class);
            builder.setValue((CharSequence)"value", outMaps);
            AnnotationMirror newAnno = builder.build();
            outType.removeAnnotation(KeyFor.class);
            outType.addAnnotation(newAnno);
        }
        if (outType.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)outType;
            HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> mapping = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror typeArgument : declaredType.getTypeArguments()) {
                AnnotatedTypeMirror substTypeArgument = this.substituteCall(call, typeArgument);
                mapping.put(typeArgument, substTypeArgument);
            }
            outType = declaredType.substitute(mapping);
        } else if (outType.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)outType;
            AnnotatedTypeMirror elemType = arrayType.getComponentType();
            AnnotatedTypeMirror substElemType = this.substituteCall(call, elemType);
            arrayType.setComponentType(substElemType);
        } else if (outType.getKind().isPrimitive() || outType.getKind() == TypeKind.WILDCARD || outType.getKind() == TypeKind.TYPEVAR) {
            // empty if block
        }
        return outType;
    }

    @Override
    protected TypeHierarchy createTypeHierarchy() {
        return new KeyForTypeHierarchy(this.checker, this.getQualifierHierarchy());
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new KeyForQualifierHierarchy(factory);
    }

    private final class KeyForQualifierHierarchy
    extends GraphQualifierHierarchy {
        public KeyForQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory, null);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(lhs, KeyForAnnotatedTypeFactory.this.KEYFOR) && AnnotationUtils.areSameIgnoringValues(rhs, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                return AnnotationUtils.areSame(lhs, rhs);
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                lhs = KeyForAnnotatedTypeFactory.this.KEYFOR;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                rhs = KeyForAnnotatedTypeFactory.this.KEYFOR;
            }
            return super.isSubtype(rhs, lhs);
        }
    }

    private class KeyForTypeHierarchy
    extends TypeHierarchy {
        public KeyForTypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy) {
            super(checker, qualifierHierarchy);
        }

        @Override
        public final boolean isSubtype(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
            if (lhs.getKind() == TypeKind.TYPEVAR && rhs.getKind() == TypeKind.TYPEVAR && lhs.getAnnotations().isEmpty()) {
                return true;
            }
            if (rhs.hasAnnotation(KeyForBottom.class)) {
                return true;
            }
            return super.isSubtype(rhs, lhs);
        }

        @Override
        protected boolean isSubtypeTypeArguments(AnnotatedTypeMirror.AnnotatedDeclaredType rhs, AnnotatedTypeMirror.AnnotatedDeclaredType lhs) {
            if (this.ignoreRawTypeArguments(rhs, lhs)) {
                return true;
            }
            List<AnnotatedTypeMirror> rhsTypeArgs = rhs.getTypeArguments();
            List<AnnotatedTypeMirror> lhsTypeArgs = lhs.getTypeArguments();
            if (rhsTypeArgs.isEmpty() || lhsTypeArgs.isEmpty()) {
                return true;
            }
            TypeElement lhsElem = (TypeElement)lhs.getUnderlyingType().asElement();
            int[] covarVals = null;
            if (lhsElem.getAnnotation(Covariant.class) != null) {
                covarVals = lhsElem.getAnnotation(Covariant.class).value();
            }
            if (lhsTypeArgs.size() != rhsTypeArgs.size()) {
                return true;
            }
            for (int i = 0; i < lhsTypeArgs.size(); ++i) {
                boolean covar = false;
                if (covarVals != null) {
                    for (int cvv = 0; cvv < covarVals.length; ++cvv) {
                        if (covarVals[cvv] != i) continue;
                        covar = true;
                    }
                }
                if (covar) {
                    if (this.isSubtype(rhsTypeArgs.get(i), lhsTypeArgs.get(i))) continue;
                    return this.isSubtypeAsTypeArgument(rhsTypeArgs.get(i), lhsTypeArgs.get(i));
                }
                if (this.isSubtypeAsTypeArgument(rhsTypeArgs.get(i), lhsTypeArgs.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

