/*
 * Decompiled with CFR 0.152.
 */
package checkers.javari;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.javari.quals.Assignable;
import checkers.javari.quals.Mutable;
import checkers.javari.quals.PolyRead;
import checkers.javari.quals.QReadOnly;
import checkers.javari.quals.ReadOnly;
import checkers.javari.quals.ThisMutable;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeHierarchy;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.types.visitors.SimpleAnnotatedTypeScanner;
import checkers.util.AnnotatedTypes;
import checkers.util.GraphQualifierHierarchy;
import checkers.util.MultiGraphQualifierHierarchy;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.InternalUtils;
import javacutils.Pair;
import javacutils.TreeUtils;
import javacutils.TypesUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;

public class JavariAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final JavariTreePreAnnotator treePre;
    private final JavariTypePostAnnotator typePost;
    protected final AnnotationMirror READONLY;
    protected final AnnotationMirror THISMUTABLE;
    protected final AnnotationMirror MUTABLE;
    protected final AnnotationMirror POLYREAD;
    protected final AnnotationMirror QREADONLY;
    protected final AnnotationMirror ASSIGNABLE;

    public JavariAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.READONLY = AnnotationUtils.fromClass(this.elements, ReadOnly.class);
        this.THISMUTABLE = AnnotationUtils.fromClass(this.elements, ThisMutable.class);
        this.MUTABLE = AnnotationUtils.fromClass(this.elements, Mutable.class);
        this.POLYREAD = AnnotationUtils.fromClass(this.elements, PolyRead.class);
        this.QREADONLY = AnnotationUtils.fromClass(this.elements, QReadOnly.class);
        this.ASSIGNABLE = AnnotationUtils.fromClass(this.elements, Assignable.class);
        this.treePre = new JavariTreePreAnnotator();
        this.typePost = new JavariTypePostAnnotator();
        this.postInit();
    }

    private AnnotationMirror getImmutabilityAnnotation(AnnotatedTypeMirror type) {
        return type.getAnnotationInHierarchy(this.READONLY);
    }

    public boolean hasImmutabilityAnnotation(AnnotatedTypeMirror type) {
        return type != null && this.getImmutabilityAnnotation(type) != null;
    }

    @Override
    public void annotateImplicit(Tree tree, AnnotatedTypeMirror type, boolean useFlow) {
        AnnotatedTypeMirror.AnnotatedDeclaredType selfType;
        if (type.getKind().isPrimitive() && !this.hasImmutabilityAnnotation(type)) {
            type.addAnnotation(this.MUTABLE);
            return;
        }
        this.treePre.visit(tree, type);
        Element elt = InternalUtils.symbol(tree);
        this.typePost.visit(type, elt);
        if (elt != null && elt.getKind() == ElementKind.FIELD && type.hasEffectiveAnnotation(this.THISMUTABLE) && (selfType = this.getSelfType(tree)) != null) {
            if (selfType.hasEffectiveAnnotation(this.POLYREAD)) {
                new AnnotatedTypeReplacer(this.THISMUTABLE, this.POLYREAD).visit(type);
            } else if (selfType.hasEffectiveAnnotation(this.MUTABLE)) {
                new AnnotatedTypeReplacer(this.THISMUTABLE, this.MUTABLE).visit(type);
            } else if (selfType.hasEffectiveAnnotation(this.READONLY)) {
                new AnnotatedTypeReplacer(this.THISMUTABLE, this.READONLY).visit(type);
            }
        }
    }

    protected void annotateImplicit(Iterable<? extends Tree> trees, Iterable<? extends AnnotatedTypeMirror> types) {
        Iterator<? extends Tree> iTree = trees.iterator();
        Iterator<? extends AnnotatedTypeMirror> iType = types.iterator();
        while (iTree.hasNext()) {
            assert (iType.hasNext());
            this.annotateImplicit(iTree.next(), iType.next());
        }
        assert (!iType.hasNext());
    }

    @Override
    public void annotateImplicit(Element element, AnnotatedTypeMirror type) {
        if ((element.getKind().isClass() || element.getKind().isInterface()) && !this.hasImmutabilityAnnotation(type)) {
            type.addAnnotation(this.MUTABLE);
        }
        this.typePost.visit(type, element);
    }

    @Override
    protected void postDirectSuperTypes(AnnotatedTypeMirror type, List<? extends AnnotatedTypeMirror> supertypes) {
        super.postDirectSuperTypes(type, supertypes);
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
            this.typePost.visit(annotatedTypeMirror, null);
        }
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> constructorFromUse(NewClassTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> fromUse = super.constructorFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType exType = (AnnotatedTypeMirror.AnnotatedExecutableType)fromUse.first;
        List typeargs = (List)fromUse.second;
        List<AnnotatedTypeMirror> parameterTypes = AnnotatedTypes.expandVarArgs(this, exType, tree.getArguments());
        List<AnnotatedTypeMirror> argumentTypes = AnnotatedTypes.getAnnotatedTypes(this, parameterTypes, tree.getArguments());
        boolean allMutable = true;
        boolean allPolyRead = true;
        boolean allThisMutable = true;
        for (int i = 0; i < parameterTypes.size(); ++i) {
            AnnotatedTypeMirror pType = parameterTypes.get(i);
            if (!pType.hasEffectiveAnnotation(this.POLYREAD)) continue;
            AnnotatedTypeMirror aType = argumentTypes.get(i);
            if (aType.hasEffectiveAnnotation(this.THISMUTABLE) || aType.hasEffectiveAnnotation(this.POLYREAD)) {
                allMutable = false;
            }
            if (aType.hasEffectiveAnnotation(this.READONLY) || aType.hasEffectiveAnnotation(this.QREADONLY)) {
                allMutable = false;
                allThisMutable = false;
            }
            if (aType.hasEffectiveAnnotation(this.POLYREAD) && !aType.hasEffectiveAnnotation(this.READONLY) && !aType.hasEffectiveAnnotation(this.THISMUTABLE) && !aType.hasEffectiveAnnotation(this.QREADONLY)) continue;
            allPolyRead = false;
        }
        AnnotationMirror replacement = allMutable ? this.MUTABLE : (allThisMutable ? this.THISMUTABLE : (allPolyRead ? this.POLYREAD : this.READONLY));
        if (replacement != this.POLYREAD) {
            new AnnotatedTypeReplacer(this.POLYREAD, replacement).visit(exType);
        }
        return Pair.of(exType, typeargs);
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree tree) {
        AnnotationMirror replacement;
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType type = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        AnnotatedTypeMirror returnType = type.getReturnType();
        List<AnnotatedTypeMirror> parameterTypes = AnnotatedTypes.expandVarArgs(this, type, tree.getArguments());
        List<AnnotatedTypeMirror> argumentTypes = AnnotatedTypes.getAnnotatedTypes(this, parameterTypes, tree.getArguments());
        AnnotatedTypeMirror.AnnotatedDeclaredType receiverType = type.getReceiverType();
        boolean allMutable = true;
        boolean allPolyRead = true;
        boolean allThisMutable = true;
        for (int i = 0; i < parameterTypes.size(); ++i) {
            AnnotatedTypeMirror pType = parameterTypes.get(i);
            if (!pType.hasEffectiveAnnotation(this.POLYREAD)) continue;
            AnnotatedTypeMirror aType = argumentTypes.get(i);
            if (aType.hasEffectiveAnnotation(this.THISMUTABLE) || aType.hasEffectiveAnnotation(this.POLYREAD)) {
                allMutable = false;
            }
            if (aType.hasEffectiveAnnotation(this.READONLY) || aType.hasEffectiveAnnotation(this.QREADONLY)) {
                allMutable = false;
                allThisMutable = false;
            }
            if (aType.hasEffectiveAnnotation(this.POLYREAD) && !aType.hasEffectiveAnnotation(this.READONLY) && !aType.hasEffectiveAnnotation(this.THISMUTABLE) && !aType.hasEffectiveAnnotation(this.QREADONLY)) continue;
            allPolyRead = false;
        }
        if (receiverType.hasEffectiveAnnotation(this.POLYREAD)) {
            ExpressionTree exprTree = tree.getMethodSelect();
            AnnotatedTypeMirror exprReceiver = this.getReceiverType(exprTree);
            if (exprReceiver.hasEffectiveAnnotation(this.READONLY)) {
                allMutable = false;
                allThisMutable = false;
                allPolyRead = false;
            } else if (exprReceiver.hasEffectiveAnnotation(this.POLYREAD)) {
                allMutable = false;
            }
        }
        if ((replacement = allMutable ? this.MUTABLE : (allThisMutable ? this.THISMUTABLE : (allPolyRead ? this.POLYREAD : this.READONLY))) != this.POLYREAD && returnType.hasEffectiveAnnotation(this.POLYREAD)) {
            new AnnotatedTypeReplacer(this.POLYREAD, replacement).visit(type);
        }
        return mfuPair;
    }

    @Override
    public void postAsMemberOf(AnnotatedTypeMirror type, AnnotatedTypeMirror owner, Element element) {
        AnnotationMirror ownerAnno;
        if (!owner.hasEffectiveAnnotation(this.READONLY) && (ownerAnno = this.getImmutabilityAnnotation(owner)) != this.THISMUTABLE) {
            new AnnotatedTypeReplacer(this.THISMUTABLE, ownerAnno).visit(type);
        }
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new JavariQualifierHierarchy(factory);
    }

    @Override
    protected TypeHierarchy createTypeHierarchy() {
        return new TypeHierarchy(this.checker, this.getQualifierHierarchy()){

            @Override
            public boolean isSubtype(AnnotatedTypeMirror sub, AnnotatedTypeMirror sup) {
                return sub.getKind().isPrimitive() || sup.getKind().isPrimitive() || super.isSubtype(sub, sup);
            }

            @Override
            protected boolean isSubtypeAsTypeArgument(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
                return lhs.hasEffectiveAnnotation(JavariAnnotatedTypeFactory.this.QREADONLY) || super.isSubtypeAsTypeArgument(rhs, lhs);
            }
        };
    }

    private final class JavariQualifierHierarchy
    extends GraphQualifierHierarchy {
        public JavariQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory, JavariAnnotatedTypeFactory.this.MUTABLE);
        }

        public Set<AnnotationMirror> leastUpperBounds(Collection<? extends AnnotationMirror> c1, Collection<? extends AnnotationMirror> c2) {
            HashMap<String, AnnotationMirror> ann = new HashMap<String, AnnotationMirror>();
            for (AnnotationMirror annotationMirror : c1) {
                ann.put(AnnotationUtils.annotationName(annotationMirror).toString(), annotationMirror);
            }
            for (AnnotationMirror annotationMirror : c2) {
                ann.put(AnnotationUtils.annotationName(annotationMirror).toString(), annotationMirror);
            }
            if (ann.containsKey(QReadOnly.class.getCanonicalName())) {
                return Collections.singleton(JavariAnnotatedTypeFactory.this.QREADONLY);
            }
            if (ann.containsKey(ReadOnly.class.getCanonicalName())) {
                return Collections.singleton(JavariAnnotatedTypeFactory.this.READONLY);
            }
            if (ann.containsKey(PolyRead.class.getCanonicalName())) {
                return Collections.singleton(JavariAnnotatedTypeFactory.this.POLYREAD);
            }
            return Collections.singleton(JavariAnnotatedTypeFactory.this.MUTABLE);
        }
    }

    private class AnnotatedTypeReplacer
    extends SimpleAnnotatedTypeScanner<Void, Void> {
        private final AnnotationMirror oldAnnotation;
        private final AnnotationMirror newAnnotation;

        AnnotatedTypeReplacer(AnnotationMirror oldAnnotation, AnnotationMirror newAnnotation) {
            this.oldAnnotation = oldAnnotation;
            this.newAnnotation = newAnnotation;
        }

        @Override
        protected Void defaultAction(AnnotatedTypeMirror type, Void p) {
            if (type.hasEffectiveAnnotation(this.oldAnnotation)) {
                type.removeAnnotation(this.oldAnnotation);
                type.addAnnotation(this.newAnnotation);
            }
            return (Void)super.defaultAction(type, p);
        }
    }

    private class JavariTypePostAnnotator
    extends AnnotatedTypeScanner<Void, Element> {
        private JavariTypePostAnnotator() {
        }

        @Override
        public Void scan(AnnotatedTypeMirror type, Element elem) {
            if (type != null && !JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type) && elem != null && elem.getKind().isField()) {
                type.addAnnotation(JavariAnnotatedTypeFactory.this.THISMUTABLE);
            }
            return (Void)super.scan(type, elem);
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, Element elem) {
            AnnotatedTypeMirror returnType;
            AnnotatedTypeMirror.AnnotatedDeclaredType receiver = type.getReceiverType();
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(receiver)) {
                AnnotatedTypeMirror.AnnotatedDeclaredType owner = (AnnotatedTypeMirror.AnnotatedDeclaredType)JavariAnnotatedTypeFactory.this.getAnnotatedType(type.getElement().getEnclosingElement());
                assert (JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(owner));
                receiver.addAnnotation(JavariAnnotatedTypeFactory.this.getImmutabilityAnnotation(owner));
            }
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(returnType = type.getReturnType()) && !returnType.getKind().isPrimitive() && returnType.getKind() != TypeKind.VOID && returnType.getKind() != TypeKind.TYPEVAR) {
                returnType.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitExecutable(type, elem);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Element elem) {
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type)) {
                TypeElement tElt = (TypeElement)type.getUnderlyingType().asElement();
                AnnotatedTypeMirror.AnnotatedDeclaredType tType = JavariAnnotatedTypeFactory.this.fromElement(tElt);
                if (JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(tType)) {
                    type.addAnnotation(JavariAnnotatedTypeFactory.this.getImmutabilityAnnotation(tType));
                } else {
                    type.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            if (elem != null && elem.getKind().isField()) {
                if (this.visitedNodes.containsKey(type)) {
                    return (Void)this.visitedNodes.get(type);
                }
                this.visitedNodes.put(type, null);
                Void r = (Void)this.scan(type.getTypeArguments(), null);
                return r;
            }
            return (Void)super.visitDeclared(type, elem);
        }

        @Override
        public Void visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Element elem) {
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type)) {
                type.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitPrimitive(type, elem);
        }

        @Override
        public Void visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, Element elem) {
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type)) {
                type.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitArray(type, elem);
        }

        @Override
        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, Element elem) {
            if (type.getUpperBoundField() != null && !JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type.getUpperBound())) {
                ElementKind elemKind;
                ElementKind elementKind = elemKind = elem != null ? elem.getKind() : ElementKind.OTHER;
                if (elemKind.isClass() || elemKind.isInterface() || elemKind == ElementKind.CONSTRUCTOR || elemKind == ElementKind.METHOD || elemKind == ElementKind.PARAMETER) {
                    type.getUpperBound().addAnnotation(JavariAnnotatedTypeFactory.this.READONLY);
                } else if (TypesUtils.isObject(type.getUnderlyingType())) {
                    type.getUpperBound().addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            return (Void)super.visitTypeVariable(type, elem);
        }

        @Override
        public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, Element elem) {
            if (type.getExtendsBound() != null && !JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type.getExtendsBound())) {
                ElementKind elemKind;
                ElementKind elementKind = elemKind = elem != null ? elem.getKind() : ElementKind.OTHER;
                if (elemKind.isClass() || elemKind.isInterface() || elemKind == ElementKind.CONSTRUCTOR || elemKind == ElementKind.METHOD) {
                    type.getExtendsBound().addAnnotation(JavariAnnotatedTypeFactory.this.READONLY);
                } else if (TypesUtils.isObject(type.getUnderlyingType())) {
                    type.getExtendsBound().addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            return (Void)super.visitWildcard(type, elem);
        }
    }

    private class JavariTreePreAnnotator
    extends SimpleTreeVisitor<Void, AnnotatedTypeMirror> {
        private JavariTreePreAnnotator() {
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, AnnotatedTypeMirror p) {
            AnnotatedTypeMirror exType = JavariAnnotatedTypeFactory.this.getAnnotatedType(node.getExpression());
            AnnotatedTypeMirror idType = JavariAnnotatedTypeFactory.this.fromElement(TreeUtils.elementFromUse(node));
            if (idType.hasEffectiveAnnotation(JavariAnnotatedTypeFactory.this.READONLY)) {
                p.replaceAnnotation(JavariAnnotatedTypeFactory.this.READONLY);
            } else if (idType.hasEffectiveAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE)) {
                p.replaceAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            } else if (JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(exType)) {
                p.replaceAnnotation(JavariAnnotatedTypeFactory.this.getImmutabilityAnnotation(exType));
            } else {
                p.replaceAnnotation(JavariAnnotatedTypeFactory.this.THISMUTABLE);
            }
            return (Void)super.visitMemberSelect(node, p);
        }

        @Override
        public Void visitLiteral(LiteralTree node, AnnotatedTypeMirror p) {
            if (node.getKind() == Tree.Kind.NULL_LITERAL) {
                p.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitLiteral(node, p);
        }

        @Override
        public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror p) {
            assert (p.getKind() == TypeKind.DECLARED);
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(p)) {
                p.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitNewClass(node, p);
        }

        @Override
        public Void visitClass(ClassTree node, AnnotatedTypeMirror p) {
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(p)) {
                p.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitClass(node, p);
        }
    }
}

