/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BluetoothBytesParser {
    private int offset = 0;
    private byte[] mValue;
    private final ByteOrder byteOrder;
    public static final int FORMAT_UINT8 = 17;
    public static final int FORMAT_UINT16 = 18;
    public static final int FORMAT_UINT32 = 20;
    public static final int FORMAT_SINT8 = 33;
    public static final int FORMAT_SINT16 = 34;
    public static final int FORMAT_SINT32 = 36;
    public static final int FORMAT_SFLOAT = 50;
    public static final int FORMAT_FLOAT = 52;

    public BluetoothBytesParser() {
        this(null, ByteOrder.LITTLE_ENDIAN);
    }

    public BluetoothBytesParser(ByteOrder byteOrder) {
        this(null, byteOrder);
    }

    public BluetoothBytesParser(byte[] value) {
        this(value, 0, ByteOrder.LITTLE_ENDIAN);
    }

    public BluetoothBytesParser(byte[] value, ByteOrder byteOrder) {
        this(value, 0, byteOrder);
    }

    public BluetoothBytesParser(byte[] value, int offset) {
        this(value, offset, ByteOrder.LITTLE_ENDIAN);
    }

    public BluetoothBytesParser(byte[] value, int offset, ByteOrder byteOrder) {
        this.mValue = value;
        this.offset = offset;
        this.byteOrder = byteOrder;
    }

    public Integer getIntValue(int formatType) {
        Integer result = this.getIntValue(formatType, this.offset, this.byteOrder);
        this.offset += this.getTypeLen(formatType);
        return result;
    }

    public Integer getIntValue(int formatType, ByteOrder byteOrder) {
        Integer result = this.getIntValue(formatType, this.offset, byteOrder);
        this.offset += this.getTypeLen(formatType);
        return result;
    }

    public long getLongValue() {
        return this.getLongValue(this.byteOrder);
    }

    public long getLongValue(ByteOrder byteOrder) {
        long result = this.getLongValue(this.offset, byteOrder);
        this.offset += 8;
        return result;
    }

    public long getLongValue(int offset, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            long value = 0xFF & this.mValue[offset + 7];
            for (int i = 6; i >= 0; --i) {
                value <<= 8;
                value += (long)(0xFF & this.mValue[i + offset]);
            }
            return value;
        }
        long value = 0xFF & this.mValue[offset];
        for (int i = 1; i < 8; ++i) {
            value <<= 8;
            value += (long)(0xFF & this.mValue[i + offset]);
        }
        return value;
    }

    public Integer getIntValue(int formatType, int offset, ByteOrder byteOrder) {
        if (offset + this.getTypeLen(formatType) > this.mValue.length) {
            return null;
        }
        switch (formatType) {
            case 17: {
                return this.unsignedByteToInt(this.mValue[offset]);
            }
            case 18: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1]);
                }
                return this.unsignedBytesToInt(this.mValue[offset + 1], this.mValue[offset]);
            }
            case 20: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]);
                }
                return this.unsignedBytesToInt(this.mValue[offset + 3], this.mValue[offset + 2], this.mValue[offset + 1], this.mValue[offset]);
            }
            case 33: {
                return this.unsignedToSigned(this.unsignedByteToInt(this.mValue[offset]), 8);
            }
            case 34: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1]), 16);
                }
                return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset + 1], this.mValue[offset]), 16);
            }
            case 36: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]), 32);
                }
                return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset + 3], this.mValue[offset + 2], this.mValue[offset + 1], this.mValue[offset]), 32);
            }
        }
        return null;
    }

    public Float getFloatValue(int formatType) {
        Float result = this.getFloatValue(formatType, this.offset, this.byteOrder);
        this.offset += this.getTypeLen(formatType);
        return result;
    }

    public Float getFloatValue(int formatType, ByteOrder byteOrder) {
        Float result = this.getFloatValue(formatType, this.offset, byteOrder);
        this.offset += this.getTypeLen(formatType);
        return result;
    }

    public Float getFloatValue(int formatType, int offset, ByteOrder byteOrder) {
        if (offset + this.getTypeLen(formatType) > this.mValue.length) {
            return null;
        }
        switch (formatType) {
            case 50: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return Float.valueOf(this.bytesToFloat(this.mValue[offset], this.mValue[offset + 1]));
                }
                return Float.valueOf(this.bytesToFloat(this.mValue[offset + 1], this.mValue[offset]));
            }
            case 52: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return Float.valueOf(this.bytesToFloat(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]));
                }
                return Float.valueOf(this.bytesToFloat(this.mValue[offset + 3], this.mValue[offset + 2], this.mValue[offset + 1], this.mValue[offset]));
            }
        }
        return null;
    }

    public String getStringValue() {
        return this.getStringValue(this.offset);
    }

    public String getStringValue(int offset) {
        int j;
        if (this.mValue == null || offset > this.mValue.length) {
            return null;
        }
        byte[] strBytes = new byte[this.mValue.length - offset];
        for (int i = 0; i != this.mValue.length - offset; ++i) {
            strBytes[i] = this.mValue[offset + i];
        }
        for (j = strBytes.length; j > 0 && (strBytes[j - 1] == 0 || strBytes[j - 1] == 32); --j) {
        }
        return new String(strBytes, 0, j, StandardCharsets.ISO_8859_1);
    }

    public Date getDateTime() {
        Date result = this.getDateTime(this.offset);
        this.offset += 7;
        return result;
    }

    public Date getDateTime(int offset) {
        int year = this.getIntValue(18, offset, ByteOrder.LITTLE_ENDIAN);
        int month = this.getIntValue(17, offset += this.getTypeLen(18), ByteOrder.LITTLE_ENDIAN);
        int day = this.getIntValue(17, offset += this.getTypeLen(17), ByteOrder.LITTLE_ENDIAN);
        int hour = this.getIntValue(17, offset += this.getTypeLen(17), ByteOrder.LITTLE_ENDIAN);
        int min = this.getIntValue(17, offset += this.getTypeLen(17), ByteOrder.LITTLE_ENDIAN);
        int sec = this.getIntValue(17, offset += this.getTypeLen(17), ByteOrder.LITTLE_ENDIAN);
        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, min, sec);
        return calendar.getTime();
    }

    public byte[] getValue() {
        return this.mValue;
    }

    public boolean setIntValue(int value, int formatType, int offset) {
        this.prepareArray(offset + this.getTypeLen(formatType));
        switch (formatType) {
            case 33: {
                value = this.intToSignedBits(value, 8);
            }
            case 17: {
                this.mValue[offset] = (byte)(value & 0xFF);
                break;
            }
            case 34: {
                value = this.intToSignedBits(value, 16);
            }
            case 18: {
                if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    this.mValue[offset++] = (byte)(value & 0xFF);
                    this.mValue[offset] = (byte)(value >> 8 & 0xFF);
                    break;
                }
                this.mValue[offset++] = (byte)(value >> 8 & 0xFF);
                this.mValue[offset] = (byte)(value & 0xFF);
                break;
            }
            case 36: {
                value = this.intToSignedBits(value, 32);
            }
            case 20: {
                if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    this.mValue[offset++] = (byte)(value & 0xFF);
                    this.mValue[offset++] = (byte)(value >> 8 & 0xFF);
                    this.mValue[offset++] = (byte)(value >> 16 & 0xFF);
                    this.mValue[offset] = (byte)(value >> 24 & 0xFF);
                    break;
                }
                this.mValue[offset++] = (byte)(value >> 24 & 0xFF);
                this.mValue[offset++] = (byte)(value >> 16 & 0xFF);
                this.mValue[offset++] = (byte)(value >> 8 & 0xFF);
                this.mValue[offset] = (byte)(value & 0xFF);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setIntValue(int value, int formatType) {
        boolean result = this.setIntValue(value, formatType, this.offset);
        if (result) {
            this.offset += this.getTypeLen(formatType);
        }
        return result;
    }

    public boolean setLong(long value) {
        return this.setLong(value, this.offset);
    }

    public boolean setLong(long value, int offset) {
        this.prepareArray(offset + 8);
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 7; i >= 0; --i) {
                this.mValue[i + offset] = (byte)(value & 0xFFL);
                value >>= 8;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                this.mValue[i + offset] = (byte)(value & 0xFFL);
                value >>= 8;
            }
        }
        return true;
    }

    public boolean setFloatValue(int mantissa, int exponent, int formatType, int offset) {
        this.prepareArray(offset + this.getTypeLen(formatType));
        switch (formatType) {
            case 50: {
                mantissa = this.intToSignedBits(mantissa, 12);
                exponent = this.intToSignedBits(exponent, 4);
                if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    this.mValue[offset++] = (byte)(mantissa & 0xFF);
                    this.mValue[offset] = (byte)(mantissa >> 8 & 0xF);
                    int n = offset;
                    this.mValue[n] = (byte)(this.mValue[n] + (byte)((exponent & 0xF) << 4));
                    break;
                }
                this.mValue[offset] = (byte)(mantissa >> 8 & 0xF);
                int n = offset++;
                this.mValue[n] = (byte)(this.mValue[n] + (byte)((exponent & 0xF) << 4));
                this.mValue[offset] = (byte)(mantissa & 0xFF);
                break;
            }
            case 52: {
                mantissa = this.intToSignedBits(mantissa, 24);
                exponent = this.intToSignedBits(exponent, 8);
                if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    this.mValue[offset++] = (byte)(mantissa & 0xFF);
                    this.mValue[offset++] = (byte)(mantissa >> 8 & 0xFF);
                    this.mValue[offset++] = (byte)(mantissa >> 16 & 0xFF);
                    int n = offset;
                    this.mValue[n] = (byte)(this.mValue[n] + (byte)(exponent & 0xFF));
                    break;
                }
                int n = offset++;
                this.mValue[n] = (byte)(this.mValue[n] + (byte)(exponent & 0xFF));
                this.mValue[offset++] = (byte)(mantissa >> 16 & 0xFF);
                this.mValue[offset++] = (byte)(mantissa >> 8 & 0xFF);
                this.mValue[offset] = (byte)(mantissa & 0xFF);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setFloatValue(float value, int precision) {
        float mantissa = (float)((double)value * Math.pow(10.0, precision));
        return this.setFloatValue((int)mantissa, -precision, 52, 0);
    }

    public boolean setString(String value) {
        if (value != null) {
            this.setString(value, this.offset);
            this.offset += value.getBytes().length;
            return true;
        }
        return false;
    }

    public boolean setString(String value, int offset) {
        if (value != null) {
            this.prepareArray(offset + value.length());
            byte[] valueBytes = value.getBytes();
            System.arraycopy(valueBytes, 0, this.mValue, offset, valueBytes.length);
            return true;
        }
        return false;
    }

    public void setValue(byte[] value) {
        this.mValue = value;
    }

    public boolean setCurrentTime(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        this.mValue = new byte[10];
        this.mValue[0] = (byte)calendar.get(1);
        this.mValue[1] = (byte)(calendar.get(1) >> 8);
        this.mValue[2] = (byte)(calendar.get(2) + 1);
        this.mValue[3] = (byte)calendar.get(5);
        this.mValue[4] = (byte)calendar.get(11);
        this.mValue[5] = (byte)calendar.get(12);
        this.mValue[6] = (byte)calendar.get(13);
        this.mValue[7] = (byte)((calendar.get(7) + 5) % 7 + 1);
        this.mValue[8] = (byte)(calendar.get(14) * 256 / 1000);
        this.mValue[9] = 1;
        return true;
    }

    public boolean setDateTime(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        this.mValue = new byte[7];
        this.mValue[0] = (byte)calendar.get(1);
        this.mValue[1] = (byte)(calendar.get(1) >> 8);
        this.mValue[2] = (byte)(calendar.get(2) + 1);
        this.mValue[3] = (byte)calendar.get(5);
        this.mValue[4] = (byte)calendar.get(11);
        this.mValue[5] = (byte)calendar.get(12);
        this.mValue[6] = (byte)calendar.get(13);
        return true;
    }

    private int getTypeLen(int formatType) {
        return formatType & 0xF;
    }

    private int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private int unsignedBytesToInt(byte b0, byte b1) {
        return this.unsignedByteToInt(b0) + (this.unsignedByteToInt(b1) << 8);
    }

    private int unsignedBytesToInt(byte b0, byte b1, byte b2, byte b3) {
        return this.unsignedByteToInt(b0) + (this.unsignedByteToInt(b1) << 8) + (this.unsignedByteToInt(b2) << 16) + (this.unsignedByteToInt(b3) << 24);
    }

    private float bytesToFloat(byte b0, byte b1) {
        int mantissa = this.unsignedToSigned(this.unsignedByteToInt(b0) + ((this.unsignedByteToInt(b1) & 0xF) << 8), 12);
        int exponent = this.unsignedToSigned(this.unsignedByteToInt(b1) >> 4, 4);
        return (float)((double)mantissa * Math.pow(10.0, exponent));
    }

    private float bytesToFloat(byte b0, byte b1, byte b2, byte b3) {
        int mantissa = this.unsignedToSigned(this.unsignedByteToInt(b0) + (this.unsignedByteToInt(b1) << 8) + (this.unsignedByteToInt(b2) << 16), 24);
        return (float)((double)mantissa * Math.pow(10.0, b3));
    }

    private int unsignedToSigned(int unsigned, int size) {
        if ((unsigned & 1 << size - 1) != 0) {
            unsigned = -1 * ((1 << size - 1) - (unsigned & (1 << size - 1) - 1));
        }
        return unsigned;
    }

    private int intToSignedBits(int i, int size) {
        if (i < 0) {
            i = (1 << size - 1) + (i & (1 << size - 1) - 1);
        }
        return i;
    }

    public static String bytes2String(byte[] bytes) {
        if (bytes == null) {
            return "-";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public static byte[] mergeArrays(byte[] ... arrays) {
        int size = 0;
        for (byte[] array : arrays) {
            size += array.length;
        }
        byte[] merged = new byte[size];
        int index = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, merged, index, array.length);
            index += array.length;
        }
        return merged;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    private void prepareArray(int neededLength) {
        if (this.mValue == null) {
            this.mValue = new byte[neededLength];
        }
        if (neededLength > this.mValue.length) {
            byte[] largerByteArray = new byte[neededLength];
            System.arraycopy(this.mValue, 0, largerByteArray, 0, this.mValue.length);
            this.mValue = largerByteArray;
        }
    }

    public String toString() {
        return BluetoothBytesParser.bytes2String(this.mValue);
    }
}

