/*
 * Decompiled with CFR 0.152.
 */
package com.zhuang.data.base;

import com.zhuang.data.DbAccessor;
import com.zhuang.data.base.BaseMapper;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseService<Entity, Key, Mapper extends BaseMapper<Entity, Key>> {
    @Autowired
    protected DbAccessor dbAccessor;
    @Autowired
    protected Mapper mapper;

    public Entity get(Key id) {
        return (Entity)this.dbAccessor.select(id, this.getEntityClass());
    }

    public Entity getOne(Object objParams) {
        return (Entity)this.dbAccessor.selectOne(objParams, this.getEntityClass());
    }

    public List<Entity> getList(Object objParams) {
        return this.dbAccessor.selectList(objParams, this.getEntityClass());
    }

    public int getCount(Object objParams) {
        return this.dbAccessor.selectCount(objParams, this.getEntityClass());
    }

    public void add(Entity entity) {
        this.dbAccessor.insert(entity);
    }

    public void update(Entity entity) {
        this.dbAccessor.update(entity);
    }

    public void updateExcludeNullFields(Entity entity) {
        this.dbAccessor.update(entity, true);
    }

    public void delete(Key id) {
        this.dbAccessor.delete(id, this.getEntityClass());
    }

    public void save(Entity entity) {
        this.dbAccessor.insertOrUpdate(entity);
    }

    public Class<Entity> getEntityClass() {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return entityClass;
    }
}

