/*
 * Decompiled with CFR 0.152.
 */
package com.zhuang.data.autoconfigure;

import com.zhuang.data.DbAccessor;
import com.zhuang.data.autoconfigure.MyDataProperties;
import com.zhuang.data.handler.DbExecuteHandlerFactory;
import com.zhuang.data.handler.DbExecutionHandler;
import com.zhuang.data.mybatis.MyBatisDbAccessor;
import com.zhuang.data.mybatis.interceptor.DbExecutionInterceptor;
import com.zhuang.data.mybatis.interceptor.PaginationInterceptor;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={SqlSessionFactory.class})
@EnableConfigurationProperties(value={MyDataProperties.class})
@AutoConfigureAfter(value={MybatisAutoConfiguration.class})
public class MyDataAutoConfiguration {
    @Autowired
    private MyDataProperties myDataProperties;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;
    @Autowired
    private List<DbExecutionHandler> dbExecutionHandlerList;

    @Bean
    public DbAccessor dbAccessor() {
        Properties properties = com.zhuang.data.config.MyDataProperties.getInstance().getProperties();
        if (this.myDataProperties.getUnderscoreNaming() != null) {
            properties.setProperty("my.data.underscore-naming", this.myDataProperties.getUnderscoreNaming().toString());
        }
        if (this.myDataProperties.getDbExecutionHandlers() != null && this.myDataProperties.getDbExecutionHandlers().size() > 0) {
            String dbExecutionHandlers = String.join((CharSequence)",", this.myDataProperties.getDbExecutionHandlers());
            properties.setProperty("my.data.db-execution-handlers", dbExecutionHandlers);
        }
        if (this.dbExecutionHandlerList.size() > 0) {
            this.dbExecutionHandlerList.forEach(c -> DbExecuteHandlerFactory.addDbExecutionHandler((DbExecutionHandler)c));
        }
        MyBatisDbAccessor dbAccessor = new MyBatisDbAccessor(this.sqlSessionFactory, true);
        return dbAccessor;
    }

    @Bean
    public Interceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }

    @Bean
    public Interceptor dbExecutionInterceptor() {
        return new DbExecutionInterceptor();
    }
}

