/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient;

import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayUploadHttpPost;
import java.io.IOException;
import java.util.Arrays;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureExec
implements ClientExecChain {
    private static final String WECHAT_PAY_HOST_NAME_SUFFIX = ".mch.weixin.qq.com";
    private static final Logger log = LoggerFactory.getLogger(SignatureExec.class);
    private final ClientExecChain mainExec;
    private final Credentials credentials;
    private final Validator validator;

    protected SignatureExec(Credentials credentials, Validator validator, ClientExecChain mainExec) {
        this.credentials = credentials;
        this.validator = validator;
        this.mainExec = mainExec;
    }

    protected void convertToRepeatableResponseEntity(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            response.setEntity((HttpEntity)new BufferedHttpEntity(entity));
        }
    }

    protected void convertToRepeatableRequestEntity(HttpRequestWrapper request) throws IOException {
        HttpEntity entity;
        if (this.isEntityEnclosing(request) && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new BufferedHttpEntity(entity));
        }
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        if (request.getTarget().getHostName().endsWith(WECHAT_PAY_HOST_NAME_SUFFIX)) {
            return this.executeWithSignature(route, request, context, execAware);
        }
        return this.mainExec.execute(route, request, context, execAware);
    }

    private boolean isEntityEnclosing(HttpRequestWrapper request) {
        return request instanceof HttpEntityEnclosingRequest;
    }

    private boolean isUploadHttpPost(HttpRequestWrapper request) {
        return request.getOriginal() instanceof WechatPayUploadHttpPost;
    }

    private CloseableHttpResponse executeWithSignature(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        if (!this.isUploadHttpPost(request)) {
            this.convertToRepeatableRequestEntity(request);
        }
        request.addHeader("Authorization", this.credentials.getSchema() + " " + this.credentials.getToken(request));
        CloseableHttpResponse response = this.mainExec.execute(route, request, context, execAware);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300) {
            this.convertToRepeatableResponseEntity(response);
            if (!this.validator.validate(response)) {
                throw new HttpException("\u5e94\u7b54\u7684\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
        } else {
            log.error("\u5e94\u7b54\u7684\u72b6\u6001\u7801\u4e0d\u4e3a200-299\u3002status code[{}]\trequest headers[{}]", (Object)statusLine.getStatusCode(), (Object)Arrays.toString(request.getAllHeaders()));
            if (this.isEntityEnclosing(request) && !this.isUploadHttpPost(request)) {
                HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
                String body = EntityUtils.toString((HttpEntity)entity);
                log.error("\u5e94\u7b54\u7684\u72b6\u6001\u7801\u4e0d\u4e3a200-299\u3002request body[{}]", (Object)body);
            }
        }
        return response;
    }
}

