/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient;

import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class WechatPayUploadHttpPost
extends HttpPost {
    private final String meta;

    private WechatPayUploadHttpPost(URI uri, String meta) {
        super(uri);
        this.meta = meta;
    }

    public String getMeta() {
        return this.meta;
    }

    public static class Builder {
        private final URI uri;
        private String fileName;
        private InputStream fileInputStream;
        private ContentType fileContentType;
        private String meta;

        public Builder(URI uri) {
            if (uri == null) {
                throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u4ef6\u63a5\u53e3URL\u4e3a\u7a7a");
            }
            this.uri = uri;
        }

        public Builder withImage(String fileName, String fileSha256, InputStream inputStream) {
            if (fileSha256 == null || fileSha256.isEmpty()) {
                throw new IllegalArgumentException("\u6587\u4ef6\u6458\u8981\u4e3a\u7a7a");
            }
            this.meta = String.format("{\"filename\":\"%s\",\"sha256\":\"%s\"}", fileName, fileSha256);
            return this.withFile(fileName, this.meta, inputStream);
        }

        public Builder withFile(String fileName, String meta, InputStream inputStream) {
            this.fileName = fileName;
            this.fileInputStream = inputStream;
            String mimeType = URLConnection.guessContentTypeFromName(fileName);
            this.fileContentType = mimeType == null ? ContentType.APPLICATION_OCTET_STREAM : ContentType.create((String)mimeType);
            this.meta = meta;
            return this;
        }

        public WechatPayUploadHttpPost build() {
            if (this.fileName == null || this.fileName.isEmpty()) {
                throw new IllegalArgumentException("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a");
            }
            if (this.fileInputStream == null) {
                throw new IllegalArgumentException("\u6587\u4ef6\u4e3a\u7a7a");
            }
            if (this.fileContentType == null) {
                throw new IllegalArgumentException("\u6587\u4ef6\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (this.meta == null || this.meta.isEmpty()) {
                throw new IllegalArgumentException("\u5a92\u4f53\u6587\u4ef6\u5143\u4fe1\u606f\u4e3a\u7a7a");
            }
            WechatPayUploadHttpPost request = new WechatPayUploadHttpPost(this.uri, this.meta);
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.setMode(HttpMultipartMode.RFC6532).addBinaryBody("file", this.fileInputStream, this.fileContentType, this.fileName).addTextBody("meta", this.meta, ContentType.APPLICATION_JSON);
            request.setEntity(entityBuilder.build());
            request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            return request;
        }
    }
}

