/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.utils;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;

public class NetUtils {
    public static int NET_CNNT_BAIDU_OK = 1;
    public static int NET_CNNT_BAIDU_TIMEOUT = 2;
    public static int NET_NOT_PREPARE = 3;
    public static int NET_ERROR = 4;
    private static int TIMEOUT = 3000;

    private NetUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static boolean isConnected(Context context) {
        NetworkInfo info;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        return null != connectivity && null != (info = connectivity.getActiveNetworkInfo()) && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (null == manager) {
            return false;
        }
        NetworkInfo info = manager.getActiveNetworkInfo();
        return null != info && info.isAvailable();
    }

    public static String getLocalIpAddress() {
        String ret = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    ret = inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static int getNetState(Context context) {
        try {
            NetworkInfo networkinfo;
            ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivity != null && (networkinfo = connectivity.getActiveNetworkInfo()) != null) {
                if (networkinfo.isAvailable() && networkinfo.isConnected()) {
                    if (!NetUtils.connectionNetwork()) {
                        return NET_CNNT_BAIDU_TIMEOUT;
                    }
                    return NET_CNNT_BAIDU_OK;
                }
                return NET_NOT_PREPARE;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return NET_ERROR;
    }

    private static boolean connectionNetwork() {
        final boolean[] result = new boolean[]{false};
        new Thread(){

            @Override
            public void run() {
                HttpURLConnection httpUrl = null;
                try {
                    httpUrl = (HttpURLConnection)new URL("http://www.baidu.com").openConnection();
                    httpUrl.setConnectTimeout(TIMEOUT);
                    httpUrl.connect();
                    result[0] = true;
                }
                catch (IOException iOException) {
                }
                finally {
                    if (null != httpUrl) {
                        httpUrl.disconnect();
                    }
                    httpUrl = null;
                }
            }
        }.start();
        return result[0];
    }

    public static boolean is3G(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 0;
    }

    public static boolean isWifi(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }

    public static boolean is2G(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && (activeNetInfo.getSubtype() == 2 || activeNetInfo.getSubtype() == 1 || activeNetInfo.getSubtype() == 4);
    }

    public static boolean isWifiEnabled(Context context) {
        ConnectivityManager mgrConn = (ConnectivityManager)context.getSystemService("connectivity");
        TelephonyManager mgrTel = (TelephonyManager)context.getSystemService("phone");
        return mgrConn.getActiveNetworkInfo() != null && mgrConn.getActiveNetworkInfo().getState() == NetworkInfo.State.CONNECTED || mgrTel.getNetworkType() == 3;
    }

    public static void openSetting(Activity activity) {
        Intent intent;
        if (Build.VERSION.SDK_INT > 10) {
            intent = new Intent("android.settings.SETTINGS");
        } else {
            intent = new Intent();
            ComponentName component = new ComponentName("com.android.settings", "com.android.settings");
            intent.setComponent(component);
            intent.setAction("android.intent.action.VIEW");
        }
        activity.startActivity(intent);
    }
}

