/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import cn.mrlong.basicframework.utils.SDCardUtils;
import cn.mrlong.basicframework.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static final int SIZETYPE_B = 1;
    public static final int SIZETYPE_KB = 2;
    public static final int SIZETYPE_MB = 3;
    public static final int SIZETYPE_GB = 4;

    public static List<String> getFilePathList(String imagePath) {
        ArrayList<String> filesPath = new ArrayList<String>();
        File mfile = new File(imagePath);
        File[] files = mfile.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File file;
                if (!files[i].isDirectory()) {
                    file = files[i];
                    String s = FileUtils.getSuffixName(file.getName());
                    boolean b = FileUtils.checkIsImageFile(file.getPath());
                    if (!b || !StringUtils.isEquals(s, "mp4")) continue;
                    filesPath.add(file.getPath());
                    continue;
                }
                file = files[i];
                FileUtils.getFilePathList(imagePath + File.separator + file.getName());
            }
        }
        return filesPath;
    }

    public static String getFileNameWithoutSuffix(String fileName) {
        String fileN = fileName.substring(0, fileName.lastIndexOf("."));
        fileN = fileN.replaceAll("_", "");
        return fileN;
    }

    private static boolean checkIsImageFile(String fName) {
        boolean isImageFile = false;
        String FileEnd = fName.substring(fName.lastIndexOf(".") + 1, fName.length()).toLowerCase();
        isImageFile = FileEnd.equals("jpg") || FileEnd.equals("gif") || FileEnd.equals("png") || FileEnd.equals("jpeg") || FileEnd.equals("bmp") || FileEnd.equals("mp4");
        return isImageFile;
    }

    public static String getRealFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }

    public static void deleteFolderFile(String filePath, boolean deleteThisPath) {
        if (!StringUtils.isBlank(filePath)) {
            try {
                File file = new File(filePath);
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        FileUtils.deleteFolderFile(files[i].getAbsolutePath(), true);
                    }
                }
                if (deleteThisPath) {
                    if (!file.isDirectory()) {
                        file.delete();
                    } else if (file.listFiles().length == 0) {
                        file.delete();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean deleteFilesByDirectory(File directory) {
        boolean clean = false;
        try {
            block6: {
                if (directory == null) break block6;
                if (!directory.exists()) break;
                if (!directory.isDirectory()) break;
                for (File item : directory.listFiles()) {
                    boolean b = item.delete();
                    clean = b;
                }
                break;
            }
        }
        catch (Exception e) {
            clean = false;
            return clean;
        }
        finally {
            return clean;
        }
    }

    public static File getDiskFileDir(Context context, String uniqueName) {
        String filePath;
        if ("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) {
            filePath = Environment.getExternalStorageDirectory().getPath();
            FileUtils.makeRootDirectory(filePath);
        } else {
            filePath = context.getFilesDir().getPath();
            FileUtils.makeRootDirectory(filePath);
        }
        File file = null;
        try {
            file = new File(filePath + File.separator + uniqueName);
            if (!file.exists()) {
                file.mkdir();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public static void makeRootDirectory(String filePath) {
        File file = null;
        try {
            file = new File(filePath);
            if (!file.exists()) {
                file.mkdir();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveFile(String str) {
        String filePath = SDCardUtils.getExtSDCardPathList().get(1) + "/DVRMEDIA/CarRecorder/PHOTO/ODB.txt";
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                File dir = new File(file.getParent());
                dir.mkdirs();
                file.createNewFile();
            }
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(str.getBytes());
            outStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getSuffixName(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static double getFileOrFilesSize(String filePath, int sizeType) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileUtils.getFileSizes(file) : FileUtils.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileUtils.FormetFileSize(blockSize, sizeType);
    }

    public static double getAutoFileOrFilesSize(String filePath, int sizeType) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileUtils.getFileSizes(file) : FileUtils.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileUtils.FormetFileSize(blockSize, sizeType);
    }

    public static long getFileSize(File file) throws Exception {
        long size = 0L;
        if (file.exists()) {
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            size = fis.available();
        } else {
            file.createNewFile();
        }
        return size;
    }

    public static long getFileSizes(File f) throws Exception {
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += FileUtils.getFileSizes(flist[i]);
                continue;
            }
            size += FileUtils.getFileSize(flist[i]);
        }
        return size;
    }

    public static String FormetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        String wrongSize = "0B";
        if (fileS == 0L) {
            return wrongSize;
        }
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "KB" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "MB" : df.format((double)fileS / 1.073741824E9) + "GB"));
        return fileSizeString;
    }

    public static double FormetFileSize(long fileS, int sizeType) {
        DecimalFormat df = new DecimalFormat("#.00");
        double fileSizeLong = 0.0;
        switch (sizeType) {
            case 1: {
                fileSizeLong = Double.valueOf(df.format((double)fileS));
                break;
            }
            case 2: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1024.0));
                break;
            }
            case 3: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1048576.0));
                break;
            }
            case 4: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1.073741824E9));
                break;
            }
        }
        return fileSizeLong;
    }
}

