/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.utils;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.math.BigDecimal;

public class DataCleanManager {
    public static long getTotalCacheSize(Context context) throws Exception {
        long cacheSize = 0L;
        cacheSize = DataCleanManager.getFolderSize(context.getCacheDir());
        if (Environment.getExternalStorageState().equals("mounted") && "".equals(Environment.getExternalStorageState()) && context.getExternalCacheDir().exists()) {
            cacheSize += DataCleanManager.getFolderSize(context.getExternalCacheDir());
        }
        return cacheSize;
    }

    public static void clearAllCache(Context context) throws Exception {
        DataCleanManager.deleteDir(context.getCacheDir());
        if (Environment.getExternalStorageState().equals("mounted")) {
            DataCleanManager.deleteDir(context.getExternalCacheDir());
        }
    }

    private static boolean deleteDir(File dir) throws Exception {
        if (dir != null && dir.isDirectory()) {
            String[] children = dir.list();
            if (children.length != 0) {
                for (int i = 0; i < children.length; ++i) {
                    boolean success = DataCleanManager.deleteDir(new File(dir, children[i]));
                    if (success) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return dir.delete();
    }

    public static long getFolderSize(File file) throws Exception {
        long size = 0L;
        try {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    size += DataCleanManager.getFolderSize(fileList[i]);
                    continue;
                }
                size += fileList[i].length();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static String getFormatSize(double size) {
        double kiloByte = size / 1024.0;
        if (kiloByte < 1.0) {
            return size + "Byte";
        }
        double megaByte = kiloByte / 1024.0;
        if (megaByte < 1.0) {
            BigDecimal result1 = new BigDecimal(Double.toString(kiloByte));
            return result1.setScale(2, 4).toPlainString() + "KB";
        }
        double gigaByte = megaByte / 1024.0;
        if (gigaByte < 1.0) {
            BigDecimal result2 = new BigDecimal(Double.toString(megaByte));
            return result2.setScale(2, 4).toPlainString() + "MB";
        }
        double teraBytes = gigaByte / 1024.0;
        if (teraBytes < 1.0) {
            BigDecimal result3 = new BigDecimal(Double.toString(gigaByte));
            return result3.setScale(2, 4).toPlainString() + "GB";
        }
        BigDecimal result4 = new BigDecimal(teraBytes);
        return result4.setScale(2, 4).toPlainString() + "TB";
    }
}

