/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.base;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class CustomPXSetting {
    private int baseW;
    private int baseH;
    private String dirStr = "app/src/main/res";
    private static final String WTemplate = "<dimen name=\"x{0}\">{1}px</dimen>\n";
    private static final String HTemplate = "<dimen name=\"y{0}\">{1}px</dimen>\n";
    private static final String VALUE_TEMPLATE = "values-{0}x{1}";
    private static final String SUPPORT_DIMESION = "320,480;480,800;480,854;540,960;600,1024;720,1184;720,1196;720,1280;768,1024;800,1280;1080,1812;1080,1920;1440,2560;";
    private String supportStr = "320,480;480,800;480,854;540,960;600,1024;720,1184;720,1196;720,1280;768,1024;800,1280;1080,1812;1080,1920;1440,2560;";

    public CustomPXSetting(int baseX, int baseY, String supportStr) {
        this.baseW = baseX;
        this.baseH = baseY;
        if (!this.supportStr.contains(baseX + "," + baseY)) {
            this.supportStr = this.supportStr + baseX + "," + baseY + ";";
        }
        this.supportStr = this.supportStr + this.validateInput(supportStr);
        System.out.println(supportStr);
        File dir = new File(this.dirStr);
        if (!dir.exists()) {
            dir.mkdir();
        }
        System.out.println(dir.getAbsoluteFile());
    }

    private String validateInput(String supportStr) {
        StringBuffer sb = new StringBuffer();
        String[] vals = supportStr.split("_");
        int w = -1;
        int h = -1;
        for (String val : vals) {
            try {
                if (val == null || val.trim().length() == 0) continue;
                String[] wh = val.split(",");
                w = Integer.parseInt(wh[0]);
                h = Integer.parseInt(wh[1]);
            }
            catch (Exception e) {
                System.out.println("skip invalidate params : w,h = " + val);
                continue;
            }
            sb.append(w + "," + h + ";");
        }
        return sb.toString();
    }

    public void generate() {
        String[] vals;
        for (String val : vals = this.supportStr.split(";")) {
            String[] wh = val.split(",");
            this.generateXmlFile(Integer.parseInt(wh[0]), Integer.parseInt(wh[1]));
        }
    }

    private void generateXmlFile(int w, int h) {
        StringBuffer sbForWidth = new StringBuffer();
        sbForWidth.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sbForWidth.append("<resources>");
        float cellw = (float)w * 1.0f / (float)this.baseW;
        System.out.println("width : " + w + "," + this.baseW + "," + cellw);
        for (int i = 1; i < this.baseW; ++i) {
            sbForWidth.append(WTemplate.replace("{0}", i + "").replace("{1}", CustomPXSetting.change(cellw * (float)i) + ""));
        }
        sbForWidth.append(WTemplate.replace("{0}", this.baseW + "").replace("{1}", w + ""));
        sbForWidth.append("</resources>");
        StringBuffer sbForHeight = new StringBuffer();
        sbForHeight.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sbForHeight.append("<resources>");
        float cellh = (float)h * 1.0f / (float)this.baseH;
        System.out.println("height : " + h + "," + this.baseH + "," + cellh);
        for (int i = 1; i < this.baseH; ++i) {
            sbForHeight.append(HTemplate.replace("{0}", i + "").replace("{1}", CustomPXSetting.change(cellh * (float)i) + ""));
        }
        sbForHeight.append(HTemplate.replace("{0}", this.baseH + "").replace("{1}", h + ""));
        sbForHeight.append("</resources>");
        File fileDir = new File(this.dirStr + File.separator + VALUE_TEMPLATE.replace("{0}", h + "").replace("{1}", w + ""));
        fileDir.mkdir();
        File layxFile = new File(fileDir.getAbsolutePath(), "lay_x.xml");
        File layyFile = new File(fileDir.getAbsolutePath(), "lay_y.xml");
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(layxFile));
            pw.print(sbForWidth.toString());
            pw.close();
            pw = new PrintWriter(new FileOutputStream(layyFile));
            pw.print(sbForHeight.toString());
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static float change(float a) {
        int temp = (int)(a * 100.0f);
        return (float)temp / 100.0f;
    }

    public static void main(String[] args) {
        int baseW = 480;
        int baseH = 1088;
        String addition = "";
        try {
            if (args.length >= 3) {
                baseW = Integer.parseInt(args[0]);
                baseH = Integer.parseInt(args[1]);
                addition = args[2];
            } else if (args.length >= 2) {
                baseW = Integer.parseInt(args[0]);
                baseH = Integer.parseInt(args[1]);
            } else if (args.length >= 1) {
                addition = args[0];
            }
        }
        catch (NumberFormatException e) {
            System.err.println("right input params : java -jar xxx.jar width height w,h_w,h_..._w,h;");
            e.printStackTrace();
            System.exit(-1);
        }
        new CustomPXSetting(baseW, baseH, addition).generate();
    }
}

