/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.warkiz.widget.ArrowView;
import com.warkiz.widget.BuilderParams;
import com.warkiz.widget.CircleBubbleView;
import com.warkiz.widget.IndicatorSeekBar;
import com.warkiz.widget.IndicatorUtils;
import com.warkiz.widget.R;

public class Indicator {
    private final Context mContext;
    private final IndicatorSeekBar mSeekBar;
    private final int mWindowWidth;
    private int[] mLocation = new int[2];
    private ArrowView mIndicatorArrow;
    private TextView mIndicatorText;
    private PopupWindow mIndicator;
    private View mIndicatorView;
    private LinearLayout mTopContentView;
    private int mGap;
    private BuilderParams p;

    public Indicator(Context context, IndicatorSeekBar seekBar, BuilderParams p) {
        this.mContext = context;
        this.mSeekBar = seekBar;
        this.p = p;
        this.initIndicator();
        this.mWindowWidth = this.getWindowWidth();
        this.mGap = IndicatorUtils.dp2px(this.mContext, 2.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void initIndicator() {
        if (this.p.mIndicatorType == 3) {
            if (this.p.mIndicatorCustomView != null) {
                View view;
                this.mIndicatorView = this.p.mIndicatorCustomView;
                int progressTextViewId = this.mContext.getResources().getIdentifier("isb_progress", "id", this.mContext.getApplicationContext().getPackageName());
                if (progressTextViewId > 0 && (view = this.mIndicatorView.findViewById(progressTextViewId)) != null) {
                    if (!(view instanceof TextView)) throw new ClassCastException("the view identified by isb_progress in indicator custom layout can not be cast to TextView");
                    this.mIndicatorText = (TextView)view;
                    this.mIndicatorText.setText((CharSequence)String.valueOf(this.mSeekBar.getProgress()));
                    this.mIndicatorText.setTextSize((float)IndicatorUtils.px2sp(this.mContext, this.p.mIndicatorTextSize));
                    this.mIndicatorText.setTextColor(this.p.mIndicatorTextColor);
                }
            }
        } else if (2 == this.p.mIndicatorType) {
            this.mIndicatorView = new CircleBubbleView(this.p, this.checkHolderText());
            ((CircleBubbleView)this.mIndicatorView).setProgress(String.valueOf(this.mSeekBar.getProgress()));
        } else {
            this.mIndicatorView = View.inflate((Context)this.mContext, (int)R.layout.isb_indicator, null);
            this.mTopContentView = (LinearLayout)this.mIndicatorView.findViewById(R.id.indicator_container);
            this.mIndicatorArrow = (ArrowView)this.mIndicatorView.findViewById(R.id.indicator_arrow);
            this.mIndicatorArrow.setColor(this.p.mIndicatorColor);
            this.mIndicatorText = (TextView)this.mIndicatorView.findViewById(R.id.isb_progress);
            this.mIndicatorText.setText((CharSequence)String.valueOf(this.mSeekBar.getProgress()));
            this.mIndicatorText.setTextSize((float)IndicatorUtils.px2sp(this.mContext, this.p.mIndicatorTextSize));
            this.mIndicatorText.setTextColor(this.p.mIndicatorTextColor);
            if (Build.VERSION.SDK_INT >= 16) {
                this.mTopContentView.setBackground((Drawable)this.getGradientDrawable());
            } else {
                this.mTopContentView.setBackgroundDrawable((Drawable)this.getGradientDrawable());
            }
            if (this.p.mIndicatorCustomTopContentView != null) {
                int progressTextViewId = this.mContext.getResources().getIdentifier("isb_progress", "id", this.mContext.getApplicationContext().getPackageName());
                View topContentView = this.p.mIndicatorCustomTopContentView;
                if (progressTextViewId > 0) {
                    View tv = topContentView.findViewById(progressTextViewId);
                    if (tv != null) {
                        this.setIndicatorTopContentView(topContentView, progressTextViewId);
                    } else {
                        this.setIndicatorTopContentView(topContentView);
                    }
                } else {
                    this.setIndicatorTopContentView(topContentView);
                }
            }
        }
        if (this.mIndicatorView == null) return;
        this.mIndicatorView.measure(0, 0);
        this.mIndicator = new PopupWindow(this.mIndicatorView, -2, -2, false);
    }

    String checkHolderText() {
        if (this.p.mSeekBarType == 0 || this.p.mSeekBarType == 1) {
            String maxString = String.valueOf(this.p.mMax);
            String minString = String.valueOf(this.p.mMin);
            return maxString.getBytes().length > minString.getBytes().length ? maxString : minString;
        }
        if (this.p.mTextArray != null) {
            String maxLengthText = "j";
            for (CharSequence c : this.p.mTextArray) {
                if (c.length() <= maxLengthText.length()) continue;
                maxLengthText = c + "";
            }
            return maxLengthText;
        }
        return "100";
    }

    @NonNull
    private GradientDrawable getGradientDrawable() {
        GradientDrawable tvDrawable = this.p.mIndicatorType == 1 ? (GradientDrawable)this.mContext.getResources().getDrawable(R.drawable.isb_indicator_square_corners) : (GradientDrawable)this.mContext.getResources().getDrawable(R.drawable.isb_indicator_rounded_corners);
        tvDrawable.setColor(this.p.mIndicatorColor);
        return tvDrawable;
    }

    private int getWindowWidth() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        if (wm != null) {
            return wm.getDefaultDisplay().getWidth();
        }
        return 0;
    }

    private int getIndicatorScreenX() {
        this.mSeekBar.getLocationOnScreen(this.mLocation);
        return this.mLocation[0];
    }

    private void adjustArrow(float touchX) {
        if (this.p.mIndicatorType == 3 || this.p.mIndicatorType == 2) {
            return;
        }
        int indicatorScreenX = this.getIndicatorScreenX();
        if ((float)indicatorScreenX + touchX < (float)(this.mIndicator.getContentView().getMeasuredWidth() / 2)) {
            this.setMargin(-((int)((float)(this.mIndicator.getContentView().getMeasuredWidth() / 2 - indicatorScreenX) - touchX)), -1, -1, -1);
        } else if ((float)(this.mWindowWidth - indicatorScreenX) - touchX < (float)(this.mIndicator.getContentView().getMeasuredWidth() / 2)) {
            this.setMargin((int)((float)(this.mIndicator.getContentView().getMeasuredWidth() / 2) - ((float)(this.mWindowWidth - indicatorScreenX) - touchX)), -1, -1, -1);
        } else {
            this.setMargin(0, 0, 0, 0);
        }
    }

    private void setMargin(int left, int top, int right, int bottom) {
        if (this.mIndicatorArrow == null) {
            return;
        }
        if (this.mIndicatorArrow.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mIndicatorArrow.getLayoutParams();
            layoutParams.setMargins(left == -1 ? layoutParams.leftMargin : left, top == -1 ? layoutParams.topMargin : top, right == -1 ? layoutParams.rightMargin : right, bottom == -1 ? layoutParams.bottomMargin : bottom);
            this.mIndicatorArrow.requestLayout();
        }
    }

    public void update() {
        if (this.mSeekBar.isCover()) {
            this.forceHide();
        } else if (this.mSeekBar.getVisibility() == 0) {
            if (this.isShowing()) {
                this.update(this.mSeekBar.getTouchX());
            } else {
                this.show(this.mSeekBar.getTouchX());
            }
        }
    }

    void update(float touchX) {
        if (this.mIndicatorView instanceof CircleBubbleView) {
            ((CircleBubbleView)this.mIndicatorView).setProgress(this.mSeekBar.getProgressString());
        } else if (this.mIndicatorText != null) {
            this.mIndicatorText.setText((CharSequence)this.mSeekBar.getProgressString());
            this.mIndicator.getContentView().measure(0, 0);
        }
        this.mIndicator.update((View)this.mSeekBar, (int)(touchX - (float)(this.mIndicator.getContentView().getMeasuredWidth() / 2)), -(this.mSeekBar.getMeasuredHeight() + this.mIndicator.getContentView().getMeasuredHeight() - this.mSeekBar.getPaddingTop() + this.mGap), -1, -1);
        this.adjustArrow(touchX);
    }

    public void show() {
        if (!this.isShowing() && !this.mSeekBar.isCover()) {
            this.show(this.mSeekBar.getTouchX());
        }
    }

    void show(float touchX) {
        if (this.mIndicator.isShowing()) {
            return;
        }
        if (this.mIndicatorView instanceof CircleBubbleView) {
            ((CircleBubbleView)this.mIndicatorView).setProgress(this.mSeekBar.getProgressString());
        } else if (this.mIndicatorText != null) {
            this.mIndicatorText.setText((CharSequence)this.mSeekBar.getProgressString());
            this.mIndicator.getContentView().measure(0, 0);
        }
        this.mIndicator.showAsDropDown((View)this.mSeekBar, (int)(touchX - (float)this.mIndicator.getContentView().getMeasuredWidth() / 2.0f), -(this.mSeekBar.getMeasuredHeight() + this.mIndicator.getContentView().getMeasuredHeight() - this.mSeekBar.getPaddingTop() + this.mGap));
        this.adjustArrow(touchX);
    }

    public void hide() {
        if (this.mIndicator.isShowing() && !this.p.mIndicatorStay) {
            this.mIndicator.dismiss();
        }
    }

    public void forceHide() {
        if (this.mIndicator.isShowing()) {
            this.mIndicator.dismiss();
        }
    }

    public void setIndicatorTopContentView(@NonNull View topContentView) {
        this.mTopContentView.removeAllViews();
        if (Build.VERSION.SDK_INT >= 16) {
            topContentView.setBackground((Drawable)this.getGradientDrawable());
        } else {
            topContentView.setBackgroundDrawable((Drawable)this.getGradientDrawable());
        }
        this.mTopContentView.addView(topContentView);
    }

    public void setIndicatorTopContentLayout(@LayoutRes int topContentLayoutId) {
        this.mTopContentView.removeAllViews();
        View topContentView = View.inflate((Context)this.mContext, (int)topContentLayoutId, null);
        if (Build.VERSION.SDK_INT >= 16) {
            topContentView.setBackground((Drawable)this.getGradientDrawable());
        } else {
            topContentView.setBackgroundDrawable((Drawable)this.getGradientDrawable());
        }
        this.mTopContentView.addView(topContentView);
    }

    public View getmContentView() {
        return this.mIndicator.getContentView();
    }

    public void setIndicatorTopContentView(@NonNull View topContentView, @IdRes int progressTextViewId) {
        View tv = topContentView.findViewById(progressTextViewId);
        if (tv == null) {
            throw new IllegalArgumentException(" can not find the TextView in indicator topContentView by id: " + progressTextViewId);
        }
        if (!(tv instanceof TextView)) {
            throw new ClassCastException(" the view identified by progressTextViewId can not be cast to TextView. ");
        }
        this.mIndicatorText = (TextView)tv;
        this.mTopContentView.removeAllViews();
        if (Build.VERSION.SDK_INT >= 16) {
            topContentView.setBackground((Drawable)this.getGradientDrawable());
        } else {
            topContentView.setBackgroundDrawable((Drawable)this.getGradientDrawable());
        }
        this.mTopContentView.addView(topContentView);
    }

    public boolean isShowing() {
        return this.mIndicator.isShowing();
    }

    public void setCustomIndicator(@NonNull View customIndicatorView) {
        this.mIndicator.setContentView(customIndicatorView);
    }

    public void setProgressTextView(@NonNull TextView view) {
        this.mIndicatorText = view;
    }
}

