/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import com.warkiz.widget.IndicatorUtils;

public class ArrowView
extends View {
    private final int mWidth;
    private final int mHeight;
    private final Path mPath;
    private final Paint mPaint;

    public ArrowView(Context context) {
        this(context, null);
    }

    public ArrowView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ArrowView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mWidth = IndicatorUtils.dp2px(context, 12.0f);
        this.mHeight = IndicatorUtils.dp2px(context, 7.0f);
        this.mPath = new Path();
        this.mPath.moveTo(0.0f, 0.0f);
        this.mPath.lineTo((float)this.mWidth, 0.0f);
        this.mPath.lineTo((float)this.mWidth / 2.0f, (float)this.mHeight);
        this.mPath.close();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(1.0f);
    }

    void setColor(int color) {
        this.mPaint.setColor(color);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawPath(this.mPath, this.mPaint);
    }
}

