package com.warkiz.widget;

import android.content.Context;
import android.util.TypedValue;

/**
 * created by ZhuangGuangquan on  2017/9/9
 */

class IndicatorUtils
{
    static int dp2px(Context context, float dpValue)
    {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dpValue, context.getResources().getDisplayMetrics());
    }

    static int sp2px(Context context, float spValue)
    {
        return (int) (spValue * context.getResources().getDisplayMetrics().scaledDensity + 0.5f);
    }

    static int px2sp(Context context, float pxValue)
    {
        return (int) (pxValue / context.getResources().getDisplayMetrics().scaledDensity + 0.5f);
    }

}
