/*
 * Decompiled with CFR 0.152.
 */
package me.wcy.htmltext;

import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import android.text.style.URLSpan;
import android.widget.TextView;
import java.util.ArrayList;
import me.wcy.htmltext.HtmlImageGetter;
import me.wcy.htmltext.HtmlImageLoader;
import me.wcy.htmltext.HtmlTagHandler;
import me.wcy.htmltext.OnTagClickListener;
import me.wcy.htmltext.span.ImageClickSpan;
import me.wcy.htmltext.span.LinkClickSpan;

public class HtmlText {
    private HtmlImageLoader imageLoader;
    private OnTagClickListener onTagClickListener;
    private After after;
    private String source;

    private HtmlText(String source) {
        this.source = source;
    }

    public static HtmlText from(String source) {
        return new HtmlText(source);
    }

    public HtmlText setImageLoader(HtmlImageLoader imageLoader) {
        this.imageLoader = imageLoader;
        return this;
    }

    public HtmlText setOnTagClickListener(OnTagClickListener onTagClickListener) {
        this.onTagClickListener = onTagClickListener;
        return this;
    }

    public HtmlText after(After after) {
        this.after = after;
        return this;
    }

    public void into(TextView textView) {
        if (TextUtils.isEmpty((CharSequence)this.source)) {
            textView.setText((CharSequence)"");
            return;
        }
        HtmlImageGetter imageGetter = new HtmlImageGetter();
        HtmlTagHandler tagHandler = new HtmlTagHandler();
        ArrayList<String> imageUrls = new ArrayList<String>();
        imageGetter.setTextView(textView);
        imageGetter.setImageLoader(this.imageLoader);
        imageGetter.getImageSize(this.source);
        tagHandler.setTextView(textView);
        this.source = tagHandler.overrideTags(this.source);
        Spanned spanned = Html.fromHtml((String)this.source, (Html.ImageGetter)imageGetter, (Html.TagHandler)tagHandler);
        SpannableStringBuilder ssb = spanned instanceof SpannableStringBuilder ? (SpannableStringBuilder)spanned : new SpannableStringBuilder((CharSequence)spanned);
        imageUrls.clear();
        ImageSpan[] imageSpans = (ImageSpan[])ssb.getSpans(0, ssb.length(), ImageSpan.class);
        for (int i = 0; i < imageSpans.length; ++i) {
            URLSpan[] imageSpan = imageSpans[i];
            String imageUrl = imageSpan.getSource();
            int start = ssb.getSpanStart((Object)imageSpan);
            int end = ssb.getSpanEnd((Object)imageSpan);
            imageUrls.add(imageUrl);
            ImageClickSpan imageClickSpan = new ImageClickSpan(textView.getContext(), imageUrls, i);
            imageClickSpan.setListener(this.onTagClickListener);
            ClickableSpan[] clickableSpans = (ClickableSpan[])ssb.getSpans(start, end, ClickableSpan.class);
            if (clickableSpans != null) {
                for (ClickableSpan cs : clickableSpans) {
                    ssb.removeSpan((Object)cs);
                }
            }
            ssb.setSpan((Object)imageClickSpan, start, end, 33);
        }
        URLSpan[] urlSpans = (URLSpan[])ssb.getSpans(0, ssb.length(), URLSpan.class);
        if (urlSpans != null) {
            for (URLSpan urlSpan : urlSpans) {
                int start = ssb.getSpanStart((Object)urlSpan);
                int end = ssb.getSpanEnd((Object)urlSpan);
                ssb.removeSpan((Object)urlSpan);
                LinkClickSpan linkClickSpan = new LinkClickSpan(textView.getContext(), urlSpan.getURL());
                linkClickSpan.setListener(this.onTagClickListener);
                ssb.setSpan((Object)linkClickSpan, start, end, 34);
            }
        }
        Object charSequence = ssb;
        if (this.after != null) {
            charSequence = this.after.after(ssb);
        }
        textView.setText((CharSequence)charSequence);
    }

    public static interface After {
        public CharSequence after(SpannableStringBuilder var1);
    }
}

