/*
 * Decompiled with CFR 0.152.
 */
package me.wcy.htmltext;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.text.Html;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.wcy.htmltext.HtmlImageLoader;

class HtmlImageGetter
implements Html.ImageGetter {
    private static final String IMAGE_TAG_REGULAR = "<(img|IMG)\\s+([^>]*)>";
    private static final Pattern IMAGE_TAG_PATTERN = Pattern.compile("<(img|IMG)\\s+([^>]*)>");
    private static final Pattern IMAGE_WIDTH_PATTERN = Pattern.compile("(width|WIDTH)\\s*=\\s*\"?(\\w+)\"?");
    private static final Pattern IMAGE_HEIGHT_PATTERN = Pattern.compile("(height|HEIGHT)\\s*=\\s*\"?(\\w+)\"?");
    private TextView textView;
    private HtmlImageLoader imageLoader;
    private List<ImageSize> imageSizeList = new ArrayList<ImageSize>();
    private int index;

    public void setTextView(TextView textView) {
        this.textView = textView;
    }

    public void setImageLoader(HtmlImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public void getImageSize(String source) {
        Matcher imageMatcher = IMAGE_TAG_PATTERN.matcher(source);
        while (imageMatcher.find()) {
            Matcher heightMatcher;
            String attrs = imageMatcher.group(2).trim();
            int width = -1;
            int height = -1;
            Matcher widthMatcher = IMAGE_WIDTH_PATTERN.matcher(attrs);
            if (widthMatcher.find()) {
                width = HtmlImageGetter.parseSize(widthMatcher.group(2).trim());
            }
            if ((heightMatcher = IMAGE_HEIGHT_PATTERN.matcher(attrs)).find()) {
                height = HtmlImageGetter.parseSize(heightMatcher.group(2).trim());
            }
            ImageSize imageSize = new ImageSize(width, height);
            this.imageSizeList.add(imageSize);
        }
    }

    public Drawable getDrawable(String source) {
        final ImageDrawable imageDrawable = new ImageDrawable(this.index++);
        if (this.imageLoader != null) {
            imageDrawable.setDrawable(this.imageLoader.getDefaultDrawable(), false);
            this.imageLoader.loadImage(source, new HtmlImageLoader.Callback(){

                @Override
                public void onLoadComplete(final Bitmap bitmap) {
                    HtmlImageGetter.this.runOnUi(new Runnable(){

                        @Override
                        public void run() {
                            BitmapDrawable drawable = new BitmapDrawable(HtmlImageGetter.this.textView.getResources(), bitmap);
                            imageDrawable.setDrawable((Drawable)drawable, true);
                            HtmlImageGetter.this.textView.setText(HtmlImageGetter.this.textView.getText());
                        }
                    });
                }

                @Override
                public void onLoadFailed() {
                    HtmlImageGetter.this.runOnUi(new Runnable(){

                        @Override
                        public void run() {
                            imageDrawable.setDrawable(HtmlImageGetter.this.imageLoader.getErrorDrawable(), false);
                            HtmlImageGetter.this.textView.setText(HtmlImageGetter.this.textView.getText());
                        }
                    });
                }
            });
        }
        return imageDrawable;
    }

    private void runOnUi(Runnable r) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            r.run();
        } else {
            this.textView.post(r);
        }
    }

    private static int parseSize(String size) {
        try {
            return Integer.valueOf(size);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private class ImageDrawable
    extends BitmapDrawable {
        private final int position;
        private Drawable mDrawable;

        public ImageDrawable(int position) {
            this.position = position;
        }

        public void setDrawable(Drawable drawable, boolean fitSize) {
            int height;
            int width;
            boolean fitWidth;
            this.mDrawable = drawable;
            if (this.mDrawable == null) {
                this.setBounds(0, 0, 0, 0);
                return;
            }
            int maxWidth = HtmlImageGetter.this.imageLoader == null ? 0 : HtmlImageGetter.this.imageLoader.getMaxWidth();
            boolean bl = fitWidth = HtmlImageGetter.this.imageLoader != null && HtmlImageGetter.this.imageLoader.fitWidth();
            if (fitSize) {
                ImageSize imageSize;
                ImageSize imageSize2 = imageSize = HtmlImageGetter.this.imageSizeList.size() > this.position ? (ImageSize)HtmlImageGetter.this.imageSizeList.get(this.position) : null;
                if (imageSize != null && imageSize.valid()) {
                    width = this.dp2px(imageSize.width);
                    height = this.dp2px(imageSize.height);
                } else {
                    width = this.mDrawable.getIntrinsicWidth();
                    height = this.mDrawable.getIntrinsicHeight();
                }
            } else {
                width = this.mDrawable.getIntrinsicWidth();
                height = this.mDrawable.getIntrinsicHeight();
            }
            if (width > 0 && height > 0 && maxWidth > 0 && (width > maxWidth || fitWidth)) {
                height = (int)((float)height / (float)width * (float)maxWidth);
                width = maxWidth;
            }
            this.mDrawable.setBounds(0, 0, width, height);
            this.setBounds(0, 0, width, height);
        }

        public void draw(Canvas canvas) {
            if (this.mDrawable != null) {
                BitmapDrawable bitmapDrawable;
                Bitmap bitmap;
                if (this.mDrawable instanceof BitmapDrawable && ((bitmap = (bitmapDrawable = (BitmapDrawable)this.mDrawable).getBitmap()) == null || bitmap.isRecycled())) {
                    return;
                }
                this.mDrawable.draw(canvas);
            }
        }

        private int dp2px(float dpValue) {
            float scale = ((HtmlImageGetter)HtmlImageGetter.this).textView.getResources().getDisplayMetrics().density;
            return (int)(dpValue * scale + 0.5f);
        }
    }

    private static class ImageSize {
        private final int width;
        private final int height;

        public ImageSize(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public boolean valid() {
            return this.width >= 0 && this.height >= 0;
        }
    }
}

