/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.bip32.model;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kethereum.bip32.model.ConstantsKt;
import org.kethereum.crypto.KeysKt;
import org.kethereum.extensions.BigIntegerKt;
import org.kethereum.model.ECKeyPair;
import org.komputing.kbase58.Base58Kt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0015\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\u0007H\u00c0\u0003\u00a2\u0006\u0002\b\u0018J\t\u0010\u0019\u001a\u00020\tH\u00c2\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c2\u0003J\u000e\u0010\u001b\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001cJE\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\tH\u0016J\u0010\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u001fJ\t\u0010%\u001a\u00020#H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006&"}, d2={"Lorg/kethereum/bip32/model/ExtendedKey;", "", "keyPair", "Lorg/kethereum/model/ECKeyPair;", "chainCode", "", "depth", "", "parentFingerprint", "", "sequence", "versionBytes", "(Lorg/kethereum/model/ECKeyPair;[BBII[B)V", "getChainCode$bip32", "()[B", "getDepth$bip32", "()B", "getKeyPair", "()Lorg/kethereum/model/ECKeyPair;", "getVersionBytes$bip32", "component1", "component2", "component2$bip32", "component3", "component3$bip32", "component4", "component5", "component6", "component6$bip32", "copy", "equals", "", "other", "hashCode", "serialize", "", "publicKeyOnly", "toString", "bip32"})
public final class ExtendedKey {
    @NotNull
    private final ECKeyPair keyPair;
    @NotNull
    private final byte[] chainCode;
    private final byte depth;
    private final int parentFingerprint;
    private final int sequence;
    @NotNull
    private final byte[] versionBytes;

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kethereum.bip32.model.ExtendedKey");
        }
        ExtendedKey cfr_ignored_0 = (ExtendedKey)object2;
        if (Intrinsics.areEqual((Object)this.keyPair, (Object)((ExtendedKey)other).keyPair) ^ true) {
            return false;
        }
        byte[] byArray = this.versionBytes;
        byte[] byArray2 = ((ExtendedKey)other).versionBytes;
        boolean bl = false;
        if (!Arrays.equals(byArray, byArray2)) {
            return false;
        }
        byArray = this.chainCode;
        byArray2 = ((ExtendedKey)other).chainCode;
        bl = false;
        if (!Arrays.equals(byArray, byArray2)) {
            return false;
        }
        if (this.depth != ((ExtendedKey)other).depth) {
            return false;
        }
        if (this.parentFingerprint != ((ExtendedKey)other).parentFingerprint) {
            return false;
        }
        return this.sequence == ((ExtendedKey)other).sequence;
    }

    public int hashCode() {
        int result = this.keyPair.hashCode();
        byte[] byArray = this.versionBytes;
        boolean bl = false;
        result = 31 * result + Arrays.hashCode(byArray);
        byArray = this.chainCode;
        bl = false;
        result = 31 * result + Arrays.hashCode(byArray);
        result = 31 * result + this.depth;
        result = 31 * result + this.parentFingerprint;
        result = 31 * result + this.sequence;
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String serialize(boolean publicKeyOnly) {
        out = ByteBuffer.allocate(78);
        try {
            block11: {
                block10: {
                    if (!publicKeyOnly) {
                        var3_3 = this.versionBytes;
                        var4_5 = ConstantsKt.getXprv();
                        var5_6 = false;
                        if (!Arrays.equals(var3_3, var4_5)) {
                            var3_3 = this.versionBytes;
                            var4_5 = ConstantsKt.getTprv();
                            var5_6 = false;
                            if (!Arrays.equals(var3_3, var4_5)) {
                                throw (Throwable)new KeyException("The extended version bytes dedicated to public keys. Suggest using publicKeyOnly mode");
                            }
                        }
                    }
                    if (!publicKeyOnly && Intrinsics.areEqual((Object)this.keyPair.getPrivateKey-V6oYYD4(), (Object)BigInteger.ZERO)) {
                        throw (Throwable)new KeyException("The extended key doesn't provide any private key. Suggest using publicKeyOnly mode");
                    }
                    if (!publicKeyOnly) break block10;
                    var3_3 = this.versionBytes;
                    var4_5 = ConstantsKt.getXprv();
                    var5_6 = false;
                    if (!Arrays.equals(var3_3, var4_5)) break block10;
                    v0 = ConstantsKt.getXpub();
                    break block11;
                }
                if (!publicKeyOnly) ** GOTO lbl-1000
                var3_3 = this.versionBytes;
                var4_5 = ConstantsKt.getTprv();
                var5_6 = false;
                if (Arrays.equals(var3_3, var4_5)) {
                    v0 = ConstantsKt.getTpub();
                } else lbl-1000:
                // 2 sources

                {
                    v0 = this.versionBytes;
                }
            }
            out.put(v0);
            out.put(this.depth);
            out.putInt(this.parentFingerprint);
            out.putInt(this.sequence);
            out.put(this.chainCode);
            if (publicKeyOnly) {
                out.put(KeysKt.getCompressedPublicKey((ECKeyPair)this.keyPair));
            } else {
                out.put((byte)0);
                out.put(BigIntegerKt.toBytesPadded((BigInteger)this.keyPair.getPrivateKey-V6oYYD4(), (int)32));
            }
        }
        catch (IOException var3_4) {
            // empty catch block
        }
        v1 = out.array();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"out.array()");
        return Base58Kt.encodeToBase58WithChecksum((byte[])v1);
    }

    public static /* synthetic */ String serialize$default(ExtendedKey extendedKey, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return extendedKey.serialize(bl);
    }

    @NotNull
    public final ECKeyPair getKeyPair() {
        return this.keyPair;
    }

    @NotNull
    public final byte[] getChainCode$bip32() {
        return this.chainCode;
    }

    public final byte getDepth$bip32() {
        return this.depth;
    }

    @NotNull
    public final byte[] getVersionBytes$bip32() {
        return this.versionBytes;
    }

    public ExtendedKey(@NotNull ECKeyPair keyPair, @NotNull byte[] chainCode, byte depth, int parentFingerprint, int sequence, @NotNull byte[] versionBytes) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)chainCode, (String)"chainCode");
        Intrinsics.checkNotNullParameter((Object)versionBytes, (String)"versionBytes");
        this.keyPair = keyPair;
        this.chainCode = chainCode;
        this.depth = depth;
        this.parentFingerprint = parentFingerprint;
        this.sequence = sequence;
        this.versionBytes = versionBytes;
    }

    @NotNull
    public final ECKeyPair component1() {
        return this.keyPair;
    }

    @NotNull
    public final byte[] component2$bip32() {
        return this.chainCode;
    }

    public final byte component3$bip32() {
        return this.depth;
    }

    private final int component4() {
        return this.parentFingerprint;
    }

    private final int component5() {
        return this.sequence;
    }

    @NotNull
    public final byte[] component6$bip32() {
        return this.versionBytes;
    }

    @NotNull
    public final ExtendedKey copy(@NotNull ECKeyPair keyPair, @NotNull byte[] chainCode, byte depth, int parentFingerprint, int sequence, @NotNull byte[] versionBytes) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)chainCode, (String)"chainCode");
        Intrinsics.checkNotNullParameter((Object)versionBytes, (String)"versionBytes");
        return new ExtendedKey(keyPair, chainCode, depth, parentFingerprint, sequence, versionBytes);
    }

    public static /* synthetic */ ExtendedKey copy$default(ExtendedKey extendedKey, ECKeyPair eCKeyPair, byte[] byArray, byte by, int n, int n2, byte[] byArray2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            eCKeyPair = extendedKey.keyPair;
        }
        if ((n3 & 2) != 0) {
            byArray = extendedKey.chainCode;
        }
        if ((n3 & 4) != 0) {
            by = extendedKey.depth;
        }
        if ((n3 & 8) != 0) {
            n = extendedKey.parentFingerprint;
        }
        if ((n3 & 0x10) != 0) {
            n2 = extendedKey.sequence;
        }
        if ((n3 & 0x20) != 0) {
            byArray2 = extendedKey.versionBytes;
        }
        return extendedKey.copy(eCKeyPair, byArray, by, n, n2, byArray2);
    }

    @NotNull
    public String toString() {
        return "ExtendedKey(keyPair=" + this.keyPair + ", chainCode=" + Arrays.toString(this.chainCode) + ", depth=" + this.depth + ", parentFingerprint=" + this.parentFingerprint + ", sequence=" + this.sequence + ", versionBytes=" + Arrays.toString(this.versionBytes) + ")";
    }
}

