/*
 * Decompiled with CFR 0.152.
 */
package org.walletconnect.impls;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.walletconnect.Session;
import org.walletconnect.UtilsKt;
import org.walletconnect.impls.WCSession;
import org.walletconnect.impls.WCSessionStore;
import org.walletconnect.types.TypeMapConversionKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\rH\u0002J\u0010\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020(H\u0016J\u001e\u00101\u001a\u00020%2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u00103\u001a\u00020%2\u0006\u0010-\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u001eH\u0016J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0010H\u0016J\b\u00105\u001a\u00020%H\u0016J\b\u00106\u001a\u00020\u0012H\u0002J\b\u00107\u001a\u00020%H\u0002J\u0010\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020:H\u0002J\u0014\u0010;\u001a\u00020%2\n\u0010<\u001a\u00060=j\u0002`>H\u0002J\u0010\u0010?\u001a\u00020%2\u0006\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u00020%H\u0016J\b\u0010C\u001a\u00020%H\u0002J\b\u0010D\u001a\u00020%H\u0016J\b\u0010E\u001a\u00020%H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u000bH\u0016J&\u0010F\u001a\u00020%2\u0006\u0010G\u001a\u00020H2\u0014\u0010I\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0018\u00010#H\u0016J!\u0010J\u001a\u00020%2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020%0#\u00a2\u0006\u0002\bLH\u0002J\b\u0010M\u001a\u00020%H\u0016J \u0010N\u001a\u00020%2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010O\u001a\u00020\u00122\u0006\u0010P\u001a\u00020\rH\u0016J\u0010\u0010Q\u001a\u00020%2\u0006\u00100\u001a\u00020(H\u0016J4\u0010R\u001a\u00020,2\u0006\u0010S\u001a\u00020H2\n\b\u0002\u0010T\u001a\u0004\u0018\u00010\r2\u0016\b\u0002\u0010I\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0018\u00010#H\u0002J\b\u0010U\u001a\u00020%H\u0002J\u001e\u0010V\u001a\u00020%2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010!\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lorg/walletconnect/impls/WCSession;", "Lorg/walletconnect/Session;", "config", "Lorg/walletconnect/Session$FullyQualifiedConfig;", "payloadAdapter", "Lorg/walletconnect/Session$PayloadAdapter;", "sessionStore", "Lorg/walletconnect/impls/WCSessionStore;", "transportBuilder", "Lorg/walletconnect/Session$Transport$Builder;", "clientMeta", "Lorg/walletconnect/Session$PeerMeta;", "clientId", "", "(Lorg/walletconnect/Session$FullyQualifiedConfig;Lorg/walletconnect/Session$PayloadAdapter;Lorg/walletconnect/impls/WCSessionStore;Lorg/walletconnect/Session$Transport$Builder;Lorg/walletconnect/Session$PeerMeta;Ljava/lang/String;)V", "approvedAccounts", "", "chainId", "", "Ljava/lang/Long;", "clientData", "Lorg/walletconnect/Session$PeerData;", "currentKey", "decryptionKey", "getDecryptionKey", "()Ljava/lang/String;", "encryptionKey", "getEncryptionKey", "handshakeId", "keyLock", "", "peerId", "peerMeta", "requests", "", "Lkotlin/Function1;", "Lorg/walletconnect/Session$MethodCall$Response;", "", "sessionCallbacks", "", "Lorg/walletconnect/Session$Callback;", "transport", "Lorg/walletconnect/Session$Transport;", "accountCheck", "", "id", "address", "addCallback", "cb", "approve", "accounts", "approveRequest", "response", "clearCallbacks", "createCallId", "endSession", "handleMessage", "message", "Lorg/walletconnect/Session$Transport$Message;", "handlePayloadError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleStatus", "status", "Lorg/walletconnect/Session$Transport$Status;", "init", "internalClose", "kill", "offer", "performMethodCall", "call", "Lorg/walletconnect/Session$MethodCall;", "callback", "propagateToCallbacks", "action", "Lkotlin/ExtensionFunctionType;", "reject", "rejectRequest", "errorCode", "errorMsg", "removeCallback", "send", "msg", "topic", "storeSession", "update", "lib"})
public final class WCSession
implements Session {
    private final Object keyLock;
    private String currentKey;
    private List<String> approvedAccounts;
    private Long chainId;
    private Long handshakeId;
    private String peerId;
    private Session.PeerMeta peerMeta;
    private final Session.PeerData clientData;
    private final Session.Transport transport;
    private final Map<Long, Function1<Session.MethodCall.Response, Unit>> requests;
    private final Set<Session.Callback> sessionCallbacks;
    private final Session.FullyQualifiedConfig config;
    private final Session.PayloadAdapter payloadAdapter;
    private final WCSessionStore sessionStore;

    private final String getEncryptionKey() {
        return this.currentKey;
    }

    private final String getDecryptionKey() {
        return this.currentKey;
    }

    @Override
    public void addCallback(@NotNull Session.Callback cb) {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        this.sessionCallbacks.add(cb);
    }

    @Override
    public void removeCallback(@NotNull Session.Callback cb) {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        this.sessionCallbacks.remove(cb);
    }

    @Override
    public void clearCallbacks() {
        this.sessionCallbacks.clear();
    }

    private final void propagateToCallbacks(Function1<? super Session.Callback, Unit> action) {
        Iterable $this$forEach$iv = this.sessionCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Session.Callback it = (Session.Callback)element$iv;
            boolean bl = false;
            try {
                action.invoke((Object)it);
            }
            catch (Throwable t) {
                UtilsKt.nullOnThrow((Function0)new Function0<Unit>(it, t){
                    final /* synthetic */ Session.Callback $it;
                    final /* synthetic */ Throwable $t;

                    public final void invoke() {
                        this.$it.onStatus(new Session.Status.Error(this.$t));
                    }
                    {
                        this.$it = callback;
                        this.$t = throwable;
                        super(0);
                    }
                });
            }
        }
    }

    @Override
    @Nullable
    public Session.PeerMeta peerMeta() {
        return this.peerMeta;
    }

    @Override
    @Nullable
    public List<String> approvedAccounts() {
        return this.approvedAccounts;
    }

    @Override
    public void init() {
        if (this.transport.connect()) {
            this.transport.send(new Session.Transport.Message(this.config.getHandshakeTopic(), "sub", ""));
        }
    }

    @Override
    public void offer() {
        if (this.transport.connect()) {
            long requestId = this.createCallId();
            this.send(new Session.MethodCall.SessionRequest(requestId, this.clientData), this.config.getHandshakeTopic(), (Function1<? super Session.MethodCall.Response, Unit>)((Function1)new Function1<Session.MethodCall.Response, Unit>(this){
                final /* synthetic */ WCSession this$0;

                public final void invoke(@NotNull Session.MethodCall.Response resp) {
                    block1: {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)resp, (String)"resp");
                        Object object2 = resp.getResult();
                        if (!(object2 instanceof Map)) {
                            object2 = null;
                        }
                        if ((object = (Map)object2) == null || (object = TypeMapConversionKt.extractSessionParams(object)) == null) break block1;
                        Object object3 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object params = object3;
                        boolean bl3 = false;
                        Session.PeerData peerData = ((Session.SessionParams)params).getPeerData();
                        WCSession.access$setPeerId$p(this.this$0, peerData != null ? peerData.getId() : null);
                        Session.PeerData peerData2 = ((Session.SessionParams)params).getPeerData();
                        WCSession.access$setPeerMeta$p(this.this$0, peerData2 != null ? peerData2.getMeta() : null);
                        WCSession.access$setApprovedAccounts$p(this.this$0, ((Session.SessionParams)params).getAccounts());
                        WCSession.access$setChainId$p(this.this$0, ((Session.SessionParams)params).getChainId());
                        WCSession.access$storeSession(this.this$0);
                        WCSession.access$propagateToCallbacks(this.this$0, (Function1)new Function1<Session.Callback, Unit>((Session.SessionParams)params){
                            final /* synthetic */ Session.SessionParams $params;

                            public final void invoke(@NotNull Session.Callback $this$propagateToCallbacks) {
                                Intrinsics.checkNotNullParameter((Object)$this$propagateToCallbacks, (String)"$receiver");
                                $this$propagateToCallbacks.onStatus(this.$params.getApproved() ? (Session.Status)Session.Status.Approved.INSTANCE : (Session.Status)Session.Status.Closed.INSTANCE);
                            }
                            {
                                this.$params = sessionParams;
                                super(1);
                            }
                        });
                    }
                }
                {
                    this.this$0 = wCSession;
                    super(1);
                }
            }));
            this.handshakeId = requestId;
        }
    }

    @Override
    public void approve(@NotNull List<String> accounts2, long chainId) {
        Intrinsics.checkNotNullParameter(accounts2, (String)"accounts");
        Long l = this.handshakeId;
        if (l == null) {
            return;
        }
        long handshakeId = l;
        this.approvedAccounts = accounts2;
        this.chainId = chainId;
        Map params = TypeMapConversionKt.intoMap$default(new Session.SessionParams(true, chainId, accounts2, this.clientData), null, 1, null);
        WCSession.send$default(this, new Session.MethodCall.Response(handshakeId, params, null, 4, null), null, null, 6, null);
        this.storeSession();
        this.propagateToCallbacks((Function1<? super Session.Callback, Unit>)((Function1)approve.1.INSTANCE));
    }

    @Override
    public void update(@NotNull List<String> accounts2, long chainId) {
        Intrinsics.checkNotNullParameter(accounts2, (String)"accounts");
        Session.SessionParams params = new Session.SessionParams(true, chainId, accounts2, this.clientData);
        WCSession.send$default(this, new Session.MethodCall.SessionUpdate(this.createCallId(), params), null, null, 6, null);
    }

    @Override
    public void reject() {
        Long l = this.handshakeId;
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            Map params = TypeMapConversionKt.intoMap$default(new Session.SessionParams(false, null, null, null), null, 1, null);
            WCSession.send$default(this, new Session.MethodCall.Response(it, params, null, 4, null), null, null, 6, null);
        }
        this.endSession();
    }

    @Override
    public void approveRequest(long id, @NotNull Object response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        WCSession.send$default(this, new Session.MethodCall.Response(id, response, null, 4, null), null, null, 6, null);
    }

    @Override
    public void rejectRequest(long id, long errorCode, @NotNull String errorMsg) {
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        WCSession.send$default(this, new Session.MethodCall.Response(id, null, new Session.Error(errorCode, errorMsg)), null, null, 6, null);
    }

    @Override
    public void performMethodCall(@NotNull Session.MethodCall call, @Nullable Function1<? super Session.MethodCall.Response, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        WCSession.send$default(this, call, null, callback, 2, null);
    }

    private final void handleStatus(Session.Transport.Status status) {
        Session.Transport.Status status2 = status;
        if (Intrinsics.areEqual((Object)status2, (Object)Session.Transport.Status.Connected.INSTANCE)) {
            this.transport.send(new Session.Transport.Message(this.clientData.getId(), "sub", ""));
        }
        this.propagateToCallbacks((Function1<? super Session.Callback, Unit>)((Function1)new Function1<Session.Callback, Unit>(status){
            final /* synthetic */ Session.Transport.Status $status;

            public final void invoke(@NotNull Session.Callback $this$propagateToCallbacks) {
                Session.Status status;
                Intrinsics.checkNotNullParameter((Object)$this$propagateToCallbacks, (String)"$receiver");
                Session.Transport.Status status2 = this.$status;
                if (Intrinsics.areEqual((Object)status2, (Object)Session.Transport.Status.Connected.INSTANCE)) {
                    status = Session.Status.Connected.INSTANCE;
                } else if (Intrinsics.areEqual((Object)status2, (Object)Session.Transport.Status.Disconnected.INSTANCE)) {
                    status = Session.Status.Disconnected.INSTANCE;
                } else if (status2 instanceof Session.Transport.Status.Error) {
                    status = new Session.Status.Error(new Session.TransportError(((Session.Transport.Status.Error)this.$status).getThrowable()));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                $this$propagateToCallbacks.onStatus(status);
            }
            {
                this.$status = status;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleMessage(Session.Transport.Message message) {
        block22: {
            Session.MethodCall data;
            block21: {
                if (Intrinsics.areEqual((Object)message.getType(), (Object)"pub") ^ true) {
                    return;
                }
                data = null;
                Object object = this.keyLock;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    try {
                        data = this.payloadAdapter.parse(message.getPayload(), this.getDecryptionKey());
                    }
                    catch (Exception e) {
                        this.handlePayloadError(e);
                        return;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                String accountToCheck = null;
                Object object2 = data;
                if (object2 instanceof Session.MethodCall.SessionRequest) {
                    this.handshakeId = ((Session.MethodCall.SessionRequest)data).getId();
                    this.peerId = ((Session.MethodCall.SessionRequest)data).getPeer().getId();
                    this.peerMeta = ((Session.MethodCall.SessionRequest)data).getPeer().getMeta();
                    this.storeSession();
                } else if (object2 instanceof Session.MethodCall.SessionUpdate) {
                    if (!((Session.MethodCall.SessionUpdate)data).getParams().getApproved()) {
                        this.endSession();
                    }
                } else if (object2 instanceof Session.MethodCall.SendTransaction) {
                    accountToCheck = ((Session.MethodCall.SendTransaction)data).getFrom();
                } else if (object2 instanceof Session.MethodCall.SignMessage) {
                    accountToCheck = ((Session.MethodCall.SignMessage)data).getAddress();
                } else if (object2 instanceof Session.MethodCall.Response) {
                    Function1<Session.MethodCall.Response, Unit> function1 = this.requests.get(((Session.MethodCall.Response)data).getId());
                    if (function1 == null) {
                        return;
                    }
                    Function1<Session.MethodCall.Response, Unit> callback = function1;
                    callback.invoke((Object)data);
                }
                String string = accountToCheck;
                if (string == null) break block21;
                object2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                Object it = object2;
                boolean bl6 = false;
                if (!this.accountCheck(data.id(), (String)it)) break block22;
            }
            this.propagateToCallbacks((Function1<? super Session.Callback, Unit>)((Function1)new Function1<Session.Callback, Unit>(data){
                final /* synthetic */ Session.MethodCall $data;

                public final void invoke(@NotNull Session.Callback $this$propagateToCallbacks) {
                    Intrinsics.checkNotNullParameter((Object)$this$propagateToCallbacks, (String)"$receiver");
                    $this$propagateToCallbacks.onMethodCall(this.$data);
                }
                {
                    this.$data = methodCall;
                    super(1);
                }
            }));
        }
    }

    private final boolean accountCheck(long id, String address) {
        block5: {
            boolean bl;
            Object object;
            block4: {
                Object v1;
                List<String> list;
                block3: {
                    list = this.approvedAccounts;
                    if (list == null) break block4;
                    object = list;
                    bl = false;
                    Object object2 = object;
                    boolean bl2 = false;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        String it = (String)t;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)it, (String)address, (boolean)true)) continue;
                        v1 = t;
                        break block3;
                    }
                    v1 = null;
                }
                if ((list = (String)v1) != null) break block5;
            }
            object = this;
            bl = false;
            boolean bl4 = false;
            WCSession $this$run = (WCSession)object;
            boolean bl5 = false;
            $this$run.handlePayloadError(new Session.MethodCallException.InvalidAccount(id, address));
            return false;
        }
        return true;
    }

    private final void handlePayloadError(Exception e) {
        block2: {
            this.propagateToCallbacks((Function1<? super Session.Callback, Unit>)((Function1)new Function1<Session.Callback, Unit>(e){
                final /* synthetic */ Exception $e;

                public final void invoke(@NotNull Session.Callback $this$propagateToCallbacks) {
                    Intrinsics.checkNotNullParameter((Object)$this$propagateToCallbacks, (String)"$receiver");
                    new Session.Status.Error(this.$e);
                }
                {
                    this.$e = exception;
                    super(1);
                }
            }));
            Exception exception = e;
            if (!(exception instanceof Session.MethodCallException)) {
                exception = null;
            }
            Session.MethodCallException methodCallException = (Session.MethodCallException)exception;
            if (methodCallException == null) break block2;
            Session.MethodCallException methodCallException2 = methodCallException;
            boolean bl = false;
            boolean bl2 = false;
            Session.MethodCallException it = methodCallException2;
            boolean bl3 = false;
            long l = it.getId();
            long l2 = it.getCode();
            String string = it.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            this.rejectRequest(l, l2, string);
        }
    }

    private final void endSession() {
        this.sessionStore.remove(this.config.getHandshakeTopic());
        this.approvedAccounts = null;
        this.chainId = null;
        this.internalClose();
        this.propagateToCallbacks((Function1<? super Session.Callback, Unit>)((Function1)endSession.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final void storeSession() {
        Session.PeerData peerData;
        WCSessionStore wCSessionStore = this.sessionStore;
        String string = this.config.getHandshakeTopic();
        Session.FullyQualifiedConfig fullyQualifiedConfig = this.config;
        Session.PeerData peerData2 = this.clientData;
        String string2 = this.peerId;
        if (string2 != null) {
            void it;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = string3;
            Session.PeerData peerData3 = peerData2;
            Session.FullyQualifiedConfig fullyQualifiedConfig2 = fullyQualifiedConfig;
            String string5 = string;
            WCSessionStore wCSessionStore2 = wCSessionStore;
            boolean bl3 = false;
            Session.PeerData peerData4 = new Session.PeerData((String)it, this.peerMeta);
            wCSessionStore = wCSessionStore2;
            string = string5;
            fullyQualifiedConfig = fullyQualifiedConfig2;
            peerData2 = peerData3;
            peerData = peerData4;
        } else {
            peerData = null;
        }
        Long l = this.chainId;
        List<String> list = this.approvedAccounts;
        String string6 = this.currentKey;
        Long l2 = this.handshakeId;
        Session.PeerData peerData5 = peerData;
        Session.PeerData peerData6 = peerData2;
        Session.FullyQualifiedConfig fullyQualifiedConfig3 = fullyQualifiedConfig;
        wCSessionStore.store(string, new WCSessionStore.State(fullyQualifiedConfig3, peerData6, peerData5, l2, string6, list, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean send(Session.MethodCall msg, String topic, Function1<? super Session.MethodCall.Response, Unit> callback) {
        if (topic == null) {
            return false;
        }
        String payload = null;
        Function1<? super Session.MethodCall.Response, Unit> function1 = this.keyLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (function1) {
            boolean bl3 = false;
            payload = this.payloadAdapter.prepare(msg, this.getEncryptionKey());
            Unit unit = Unit.INSTANCE;
        }
        Function1<? super Session.MethodCall.Response, Unit> function12 = callback;
        if (function12 != null) {
            function1 = function12;
            bl = false;
            boolean bl4 = false;
            Function1<? super Session.MethodCall.Response, Unit> it = function1;
            boolean bl5 = false;
            this.requests.put(msg.id(), callback);
        }
        this.transport.send(new Session.Transport.Message(topic, "pub", payload));
        return true;
    }

    static /* synthetic */ boolean send$default(WCSession wCSession, Session.MethodCall methodCall, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string = wCSession.peerId;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return wCSession.send(methodCall, string, (Function1<? super Session.MethodCall.Response, Unit>)function1);
    }

    private final long createCallId() {
        return System.currentTimeMillis() * (long)1000 + (long)new Random().nextInt(999);
    }

    private final void internalClose() {
        this.transport.close();
    }

    @Override
    public void kill() {
        Session.SessionParams params = new Session.SessionParams(false, null, null, null);
        WCSession.send$default(this, new Session.MethodCall.SessionUpdate(this.createCallId(), params), null, null, 6, null);
        this.endSession();
    }

    public WCSession(@NotNull Session.FullyQualifiedConfig config, @NotNull Session.PayloadAdapter payloadAdapter, @NotNull WCSessionStore sessionStore, @NotNull Session.Transport.Builder transportBuilder, @NotNull Session.PeerMeta clientMeta, @Nullable String clientId) {
        Object object;
        block6: {
            Session.PeerData peerData;
            WCSession it;
            WCSession wCSession;
            boolean bl;
            boolean bl2;
            Object object2;
            WCSession wCSession2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                Intrinsics.checkNotNullParameter((Object)payloadAdapter, (String)"payloadAdapter");
                Intrinsics.checkNotNullParameter((Object)sessionStore, (String)"sessionStore");
                Intrinsics.checkNotNullParameter((Object)transportBuilder, (String)"transportBuilder");
                Intrinsics.checkNotNullParameter((Object)clientMeta, (String)"clientMeta");
                this.config = config;
                this.payloadAdapter = payloadAdapter;
                this.sessionStore = sessionStore;
                this.keyLock = new Object();
                this.transport = transportBuilder.build(this.config.getBridge(), (Function1<? super Session.Transport.Status, Unit>)((Function1)new Function1<Session.Transport.Status, Unit>(this){

                    public final void invoke(@NotNull Session.Transport.Status p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        WCSession.access$handleStatus((WCSession)this.receiver, p1);
                    }
                }), (Function1<? super Session.Transport.Message, Unit>)((Function1)new Function1<Session.Transport.Message, Unit>(this){

                    public final void invoke(@NotNull Session.Transport.Message p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        WCSession.access$handleMessage((WCSession)this.receiver, p1);
                    }
                }));
                this.requests = new ConcurrentHashMap();
                Set set = Collections.newSetFromMap(new ConcurrentHashMap());
                Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.newSetFromMa\u2026ion.Callback, Boolean>())");
                this.sessionCallbacks = set;
                this.currentKey = this.config.getKey();
                wCSession2 = this;
                object = this.sessionStore.load(this.config.getHandshakeTopic());
                if (object == null) break block5;
                object2 = object;
                bl2 = false;
                bl = false;
                Object object3 = object2;
                wCSession = wCSession2;
                boolean bl3 = false;
                this.currentKey = ((WCSessionStore.State)((Object)it)).getCurrentKey();
                this.approvedAccounts = ((WCSessionStore.State)((Object)it)).getApprovedAccounts();
                this.chainId = ((WCSessionStore.State)((Object)it)).getChainId();
                this.handshakeId = ((WCSessionStore.State)((Object)it)).getHandshakeId();
                Session.PeerData peerData2 = ((WCSessionStore.State)((Object)it)).getPeerData();
                this.peerId = peerData2 != null ? peerData2.getId() : null;
                Session.PeerData peerData3 = ((WCSessionStore.State)((Object)it)).getPeerData();
                Session.PeerMeta peerMeta = this.peerMeta = peerData3 != null ? peerData3.getMeta() : null;
                if (clientId != null && Intrinsics.areEqual((Object)clientId, (Object)((WCSessionStore.State)((Object)it)).getClientData().getId()) ^ true) {
                    throw (Throwable)new IllegalArgumentException("Provided clientId is different from stored clientId");
                }
                peerData = ((WCSessionStore.State)((Object)it)).getClientData();
                wCSession2 = wCSession;
                object = peerData;
                if (object != null) break block6;
            }
            object2 = this;
            bl2 = false;
            bl = false;
            it = (WCSession)object2;
            wCSession = wCSession2;
            boolean bl4 = false;
            String string = clientId;
            if (string == null) {
                String string2 = UUID.randomUUID().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UUID.randomUUID().toString()");
            }
            peerData = new Session.PeerData(string, clientMeta);
            wCSession2 = wCSession;
            object = peerData;
        }
        wCSession2.clientData = object;
        this.storeSession();
    }

    public /* synthetic */ WCSession(Session.FullyQualifiedConfig fullyQualifiedConfig, Session.PayloadAdapter payloadAdapter, WCSessionStore wCSessionStore, Session.Transport.Builder builder, Session.PeerMeta peerMeta, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            string = null;
        }
        this(fullyQualifiedConfig, payloadAdapter, wCSessionStore, builder, peerMeta, string);
    }

    public static final /* synthetic */ String access$getPeerId$p(WCSession $this) {
        return $this.peerId;
    }

    public static final /* synthetic */ void access$setPeerId$p(WCSession $this, String string) {
        $this.peerId = string;
    }

    public static final /* synthetic */ Session.PeerMeta access$getPeerMeta$p(WCSession $this) {
        return $this.peerMeta;
    }

    public static final /* synthetic */ void access$setPeerMeta$p(WCSession $this, Session.PeerMeta peerMeta) {
        $this.peerMeta = peerMeta;
    }

    public static final /* synthetic */ List access$getApprovedAccounts$p(WCSession $this) {
        return $this.approvedAccounts;
    }

    public static final /* synthetic */ void access$setApprovedAccounts$p(WCSession $this, List list) {
        $this.approvedAccounts = list;
    }

    public static final /* synthetic */ Long access$getChainId$p(WCSession $this) {
        return $this.chainId;
    }

    public static final /* synthetic */ void access$setChainId$p(WCSession $this, Long l) {
        $this.chainId = l;
    }

    public static final /* synthetic */ void access$storeSession(WCSession $this) {
        $this.storeSession();
    }

    public static final /* synthetic */ void access$propagateToCallbacks(WCSession $this, Function1 action) {
        $this.propagateToCallbacks((Function1<? super Session.Callback, Unit>)action);
    }

    public static final /* synthetic */ void access$handleStatus(WCSession $this, Session.Transport.Status status) {
        $this.handleStatus(status);
    }

    public static final /* synthetic */ void access$handleMessage(WCSession $this, Session.Transport.Message message) {
        $this.handleMessage(message);
    }
}

