/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MessageOutput {
    private final OutputStream outputStream;
    private final DataOutputStream dataOutputStream;
    private final ByteArrayOutputStream messageByteOutput;
    private final DataOutputStream messageDataOutput;

    public MessageOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.dataOutputStream = new DataOutputStream(outputStream);
        this.messageByteOutput = new ByteArrayOutputStream();
        this.messageDataOutput = new DataOutputStream(this.messageByteOutput);
    }

    public DataOutput startMessage() {
        this.messageByteOutput.reset();
        return this.messageDataOutput;
    }

    public void commitMessage() throws IOException {
        this.dataOutputStream.writeInt(this.messageByteOutput.size());
        this.messageByteOutput.writeTo(this.outputStream);
    }

    public void commitMessage(int flags) throws IOException {
        this.dataOutputStream.writeInt(this.messageByteOutput.size() | flags << 30);
        this.messageByteOutput.writeTo(this.outputStream);
    }

    public void finish() throws IOException {
        this.dataOutputStream.writeInt(0);
    }
}

