/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSearchMusicResultLoader;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeSearchMusicProvider
implements YoutubeSearchMusicResultLoader {
    private static final Logger log = LoggerFactory.getLogger(YoutubeSearchMusicProvider.class);
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createCookielessThreadLocalManager();

    @Override
    public ExtendedHttpConfigurable getHttpConfiguration() {
        return this.httpInterfaceManager;
    }

    /*
     * Exception decompiling
     */
    @Override
    public AudioItem loadSearchMusicResult(String query, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AudioItem extractSearchResults(JsonBrowser jsonBrowser, String query, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        List<AudioTrack> tracks;
        log.debug("Attempting to parse results from music search page");
        try {
            tracks = this.extractMusicSearchPage(jsonBrowser, trackFactory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Search music results for: " + query, tracks, null, true);
    }

    private List<AudioTrack> extractMusicSearchPage(JsonBrowser jsonBrowser, Function<AudioTrackInfo, AudioTrack> trackFactory) throws IOException {
        ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
        JsonBrowser tracks = jsonBrowser.get("contents").get("tabbedSearchResultsRenderer").get("tabs").index(0).get("tabRenderer").get("content").get("sectionListRenderer").get("contents").index(0).get("musicShelfRenderer").get("contents");
        if (tracks == JsonBrowser.NULL_BROWSER) {
            tracks = jsonBrowser.get("contents").get("tabbedSearchResultsRenderer").get("tabs").index(0).get("tabRenderer").get("content").get("sectionListRenderer").get("contents").index(1).get("musicShelfRenderer").get("contents");
        }
        tracks.values().forEach(jsonTrack -> {
            AudioTrack track = this.extractMusicTrack((JsonBrowser)jsonTrack, trackFactory);
            if (track != null) {
                list.add(track);
            }
        });
        return list;
    }

    private AudioTrack extractMusicTrack(JsonBrowser jsonBrowser, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        JsonBrowser columns = jsonBrowser.get("musicResponsiveListItemRenderer").get("flexColumns");
        if (columns.isNull()) {
            return null;
        }
        JsonBrowser firstColumn = columns.index(0).get("musicResponsiveListItemFlexColumnRenderer").get("text").get("runs").index(0);
        String title = firstColumn.get("text").text();
        String videoId = firstColumn.get("navigationEndpoint").get("watchEndpoint").get("videoId").text();
        if (videoId == null) {
            return null;
        }
        List<JsonBrowser> secondColumn = columns.index(1).get("musicResponsiveListItemFlexColumnRenderer").get("text").get("runs").values();
        String author = secondColumn.get(0).get("text").text();
        JsonBrowser lastElement = secondColumn.get(secondColumn.size() - 1);
        if (!lastElement.get("navigationEndpoint").isNull()) {
            return null;
        }
        long duration = DataFormatTools.durationTextToMillis(lastElement.get("text").text());
        AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, false, "https://www.youtube.com/watch?v=" + videoId);
        return trackFactory.apply(info);
    }
}

