/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.DefaultYoutubeLinkRouter;
import com.sedmelluq.discord.lavaplayer.source.youtube.DefaultYoutubePlaylistLoader;
import com.sedmelluq.discord.lavaplayer.source.youtube.DefaultYoutubeTrackDetailsLoader;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeHttpContextFilter;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeLinkRouter;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeMixLoader;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeMixProvider;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePlaylistLoader;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSearchMusicProvider;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSearchMusicResultLoader;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSearchProvider;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSearchResultLoader;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSignatureCipherManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSignatureResolver;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetails;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetailsLoader;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.http.MultiHttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioSourceManager.class);
    private final YoutubeSignatureResolver signatureResolver;
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private final ExtendedHttpConfigurable combinedHttpConfiguration;
    private final YoutubeMixLoader mixLoader;
    private final boolean allowSearch;
    private final YoutubeTrackDetailsLoader trackDetailsLoader;
    private final YoutubeSearchResultLoader searchResultLoader;
    private final YoutubeSearchMusicResultLoader searchMusicResultLoader;
    private final YoutubePlaylistLoader playlistLoader;
    private final YoutubeLinkRouter linkRouter;
    private final LoadingRoutes loadingRoutes;

    public YoutubeAudioSourceManager() {
        this(true);
    }

    public YoutubeAudioSourceManager(boolean allowSearch) {
        this(allowSearch, new DefaultYoutubeTrackDetailsLoader(), new YoutubeSearchProvider(), new YoutubeSearchMusicProvider(), new YoutubeSignatureCipherManager(), new DefaultYoutubePlaylistLoader(), new DefaultYoutubeLinkRouter(), new YoutubeMixProvider());
    }

    public YoutubeAudioSourceManager(boolean allowSearch, YoutubeTrackDetailsLoader trackDetailsLoader, YoutubeSearchResultLoader searchResultLoader, YoutubeSearchMusicResultLoader searchMusicResultLoader, YoutubeSignatureResolver signatureResolver, YoutubePlaylistLoader playlistLoader, YoutubeLinkRouter linkRouter, YoutubeMixLoader mixLoader) {
        this.httpInterfaceManager.setHttpContextFilter(new YoutubeHttpContextFilter());
        this.allowSearch = allowSearch;
        this.trackDetailsLoader = trackDetailsLoader;
        this.signatureResolver = signatureResolver;
        this.searchResultLoader = searchResultLoader;
        this.searchMusicResultLoader = searchMusicResultLoader;
        this.playlistLoader = playlistLoader;
        this.linkRouter = linkRouter;
        this.mixLoader = mixLoader;
        this.loadingRoutes = new LoadingRoutes();
        this.combinedHttpConfiguration = new MultiHttpConfigurable(Arrays.asList(this.httpInterfaceManager, searchResultLoader.getHttpConfiguration(), searchMusicResultLoader.getHttpConfiguration()));
    }

    public YoutubeTrackDetailsLoader getTrackDetailsLoader() {
        return this.trackDetailsLoader;
    }

    public YoutubeSignatureResolver getSignatureResolver() {
        return this.signatureResolver;
    }

    public void setPlaylistPageCount(int playlistPageCount) {
        this.playlistLoader.setPlaylistPageCount(playlistPageCount);
    }

    @Override
    public String getSourceName() {
        return "youtube";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        try {
            return this.loadItemOnce(reference);
        }
        catch (FriendlyException exception) {
            if (HttpClientTools.isRetriableNetworkException(exception.getCause())) {
                return this.loadItemOnce(reference);
            }
            throw exception;
        }
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new YoutubeAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
        ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.combinedHttpConfiguration.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.combinedHttpConfiguration.configureBuilder(configurator);
    }

    public ExtendedHttpConfigurable getHttpConfiguration() {
        return this.combinedHttpConfiguration;
    }

    public ExtendedHttpConfigurable getMainHttpConfiguration() {
        return this.httpInterfaceManager;
    }

    public ExtendedHttpConfigurable getSearchHttpConfiguration() {
        return this.searchResultLoader.getHttpConfiguration();
    }

    public ExtendedHttpConfigurable getSearchMusicHttpConfiguration() {
        return this.searchMusicResultLoader.getHttpConfiguration();
    }

    private AudioItem loadItemOnce(AudioReference reference) {
        return this.linkRouter.route(reference.identifier, this.loadingRoutes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioItem loadTrackWithVideoId(String videoId, boolean mustExist) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            YoutubeTrackDetails details = this.trackDetailsLoader.loadDetails(httpInterface, videoId, false, this);
            if (details == null) {
                if (mustExist) {
                    throw new FriendlyException("Video unavailable", FriendlyException.Severity.COMMON, null);
                }
                AudioReference audioReference = AudioReference.NO_TRACK;
                return audioReference;
            }
            YoutubeAudioTrack youtubeAudioTrack = new YoutubeAudioTrack(details.getTrackInfo(), this);
            return youtubeAudioTrack;
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("Loading information for a YouTube track failed.", FriendlyException.Severity.FAULT, e);
        }
    }

    private YoutubeAudioTrack buildTrackFromInfo(AudioTrackInfo info) {
        return new YoutubeAudioTrack(info, this);
    }

    private class LoadingRoutes
    implements YoutubeLinkRouter.Routes<AudioItem> {
        private LoadingRoutes() {
        }

        @Override
        public AudioItem track(String videoId) {
            return YoutubeAudioSourceManager.this.loadTrackWithVideoId(videoId, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AudioItem playlist(String playlistId, String selectedVideoId) {
            log.debug("Starting to load playlist with ID {}", (Object)playlistId);
            try (HttpInterface httpInterface = YoutubeAudioSourceManager.this.getHttpInterface();){
                AudioPlaylist audioPlaylist = YoutubeAudioSourceManager.this.playlistLoader.load(httpInterface, playlistId, selectedVideoId, x$0 -> YoutubeAudioSourceManager.this.buildTrackFromInfo(x$0));
                return audioPlaylist;
            }
            catch (Exception e) {
                throw ExceptionTools.wrapUnfriendlyExceptions(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AudioItem mix(String mixId, String selectedVideoId) {
            log.debug("Starting to load mix with ID {} selected track {}", (Object)mixId, (Object)selectedVideoId);
            try (HttpInterface httpInterface = YoutubeAudioSourceManager.this.getHttpInterface();){
                AudioPlaylist audioPlaylist = YoutubeAudioSourceManager.this.mixLoader.load(httpInterface, mixId, selectedVideoId, x$0 -> YoutubeAudioSourceManager.this.buildTrackFromInfo(x$0));
                return audioPlaylist;
            }
            catch (Exception e) {
                throw ExceptionTools.wrapUnfriendlyExceptions(e);
            }
        }

        @Override
        public AudioItem search(String query) {
            if (YoutubeAudioSourceManager.this.allowSearch) {
                return YoutubeAudioSourceManager.this.searchResultLoader.loadSearchResult(query, x$0 -> YoutubeAudioSourceManager.this.buildTrackFromInfo(x$0));
            }
            return null;
        }

        @Override
        public AudioItem searchMusic(String query) {
            if (YoutubeAudioSourceManager.this.allowSearch) {
                return YoutubeAudioSourceManager.this.searchMusicResultLoader.loadSearchMusicResult(query, x$0 -> YoutubeAudioSourceManager.this.buildTrackFromInfo(x$0));
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AudioItem anonymous(String videoIds) {
            try (HttpInterface httpInterface = YoutubeAudioSourceManager.this.getHttpInterface();){
                Throwable throwable;
                CloseableHttpResponse response;
                block25: {
                    AudioReference audioReference;
                    block26: {
                        response = httpInterface.execute((HttpUriRequest)new HttpGet("https://www.youtube.com/watch_videos?video_ids=" + videoIds));
                        throwable = null;
                        HttpClientTools.assertSuccessWithContent((HttpResponse)response, "playlist response");
                        HttpClientContext context = httpInterface.getContext();
                        List redirects = context.getRedirectLocations();
                        if (redirects == null || redirects.isEmpty()) break block25;
                        audioReference = new AudioReference(((URI)redirects.get(0)).toString(), null);
                        if (response == null) return audioReference;
                        if (throwable == null) break block26;
                        try {
                            response.close();
                            return audioReference;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return audioReference;
                        }
                    }
                    response.close();
                    return audioReference;
                }
                try {
                    try {
                        throw new FriendlyException("Unable to process youtube watch_videos link", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Expected youtube to redirect watch_videos link to a watch?v={id}&list={list_id} link, but it did not redirect at all"));
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (response == null) throw throwable4;
                    if (throwable == null) {
                        response.close();
                        throw throwable4;
                    }
                    try {
                        response.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            catch (Exception e) {
                throw ExceptionTools.wrapUnfriendlyExceptions(e);
            }
        }

        @Override
        public AudioItem none() {
            return AudioReference.NO_TRACK;
        }
    }
}

