/*
 * Decompiled with CFR 0.152.
 */
package waffle.mock;

import com.sun.jna.platform.win32.Secur32Util;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import waffle.mock.MockWindowsIdentity;
import waffle.mock.MockWindowsSecurityContext;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsComputer;
import waffle.windows.auth.IWindowsDomain;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class MockWindowsAuthProvider
implements IWindowsAuthProvider {
    private static final String GUEST = "Guest";
    private final List<String> groups = new ArrayList<String>();

    public MockWindowsAuthProvider() {
        this.groups.add("Users");
        this.groups.add("Everyone");
    }

    public void addGroup(String name) {
        this.groups.add(name);
    }

    public IWindowsSecurityContext acceptSecurityToken(String connectionId, byte[] token, String securityPackage) {
        return new MockWindowsSecurityContext(new String(token, StandardCharsets.UTF_8));
    }

    public IWindowsComputer getCurrentComputer() {
        return null;
    }

    public IWindowsDomain[] getDomains() {
        return new IWindowsDomain[0];
    }

    public IWindowsIdentity logonDomainUser(String username, String domain, String password) {
        return null;
    }

    public IWindowsIdentity logonDomainUserEx(String username, String domain, String password, int logonType, int logonProvider) {
        return null;
    }

    public IWindowsIdentity logonUser(String username, String password) {
        String currentUsername = Secur32Util.getUserNameEx((int)2);
        if (currentUsername.equals(username)) {
            return new MockWindowsIdentity(currentUsername, this.groups);
        }
        if (GUEST.equals(username)) {
            return new MockWindowsIdentity(GUEST, this.groups);
        }
        throw new RuntimeException("Mock error: " + username);
    }

    public IWindowsAccount lookupAccount(String username) {
        return null;
    }

    public void resetSecurityToken(String connectionId) {
    }
}

