/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.keyboard.view.R;
import java.io.IOException;
import java.util.ArrayList;
import sj.keyboard.data.PageSetEntity;
import sj.keyboard.utils.imageloader.ImageLoader;

public class EmoticonsToolBarView
extends RelativeLayout {
    protected LayoutInflater mInflater;
    protected Context mContext;
    protected final ArrayList<View> mToolBtnList = new ArrayList();
    protected int mBtnWidth;
    protected HorizontalScrollView hsv_toolbar;
    protected LinearLayout ly_tool;
    protected OnToolBarItemClickListener mItemClickListeners;

    public EmoticonsToolBarView(Context context) {
        this(context, null);
    }

    public EmoticonsToolBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mInflater.inflate(R.layout.view_emoticonstoolbar, (ViewGroup)this);
        this.mContext = context;
        this.mBtnWidth = (int)context.getResources().getDimension(R.dimen.bar_tool_btn_width);
        this.hsv_toolbar = (HorizontalScrollView)this.findViewById(R.id.hsv_toolbar);
        this.ly_tool = (LinearLayout)this.findViewById(R.id.ly_tool);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (this.getChildCount() > 3) {
            throw new IllegalArgumentException("can host only two direct child");
        }
    }

    public void addFixedToolItemView(View view, boolean isRight) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
        RelativeLayout.LayoutParams hsvParams = (RelativeLayout.LayoutParams)this.hsv_toolbar.getLayoutParams();
        if (view.getId() <= 0) {
            view.setId(isRight ? R.id.id_toolbar_right : R.id.id_toolbar_left);
        }
        if (isRight) {
            params.addRule(11);
            hsvParams.addRule(0, view.getId());
        } else {
            params.addRule(9);
            hsvParams.addRule(1, view.getId());
        }
        this.addView(view, (ViewGroup.LayoutParams)params);
        this.hsv_toolbar.setLayoutParams((ViewGroup.LayoutParams)hsvParams);
    }

    public View addFixedToolItemView(boolean isRight, int rec, PageSetEntity pageSetEntity, View.OnClickListener onClickListener) {
        View toolBtnView = this.getCommonItemToolBtn();
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
        RelativeLayout.LayoutParams hsvParams = (RelativeLayout.LayoutParams)this.hsv_toolbar.getLayoutParams();
        if (toolBtnView.getId() <= 0) {
            toolBtnView.setId(isRight ? R.id.id_toolbar_right : R.id.id_toolbar_left);
        }
        if (isRight) {
            params.addRule(11);
            hsvParams.addRule(0, toolBtnView.getId());
        } else {
            params.addRule(9);
            hsvParams.addRule(1, toolBtnView.getId());
        }
        this.addView(toolBtnView, (ViewGroup.LayoutParams)params);
        this.hsv_toolbar.setLayoutParams((ViewGroup.LayoutParams)hsvParams);
        this.initItemToolBtn(toolBtnView, rec, pageSetEntity, onClickListener);
        return toolBtnView;
    }

    public View addToolItemView(PageSetEntity pageSetEntity) {
        return this.addToolItemView(0, pageSetEntity, null);
    }

    public View addToolItemView(int rec, View.OnClickListener onClickListener) {
        return this.addToolItemView(rec, null, onClickListener);
    }

    public View addToolItemView(int rec, PageSetEntity pageSetEntity, View.OnClickListener onClickListener) {
        View toolBtnView = this.getCommonItemToolBtn();
        if (pageSetEntity != null) {
            toolBtnView.setTag(R.id.id_toolbar_uuid, (Object)pageSetEntity.getUuid());
        }
        this.initItemToolBtn(toolBtnView, rec, pageSetEntity, onClickListener);
        this.ly_tool.addView(toolBtnView);
        this.mToolBtnList.add(this.getToolBgBtn(toolBtnView));
        return toolBtnView;
    }

    public void clear() {
        this.mToolBtnList.clear();
        this.hsv_toolbar.removeAllViews();
    }

    public void remove(PageSetEntity pageSetEntity) {
        if (pageSetEntity == null) {
            return;
        }
        String uuid = pageSetEntity.getUuid();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            return;
        }
        for (int i = 0; i < this.ly_tool.getChildCount(); ++i) {
            if (!uuid.equals(this.ly_tool.getChildAt(i).getTag(R.id.id_toolbar_uuid))) continue;
            this.mToolBtnList.remove(this.ly_tool.getChildAt(i));
            this.ly_tool.removeView(this.ly_tool.getChildAt(i));
        }
    }

    public void removeFixed(boolean isLeft) {
        int id2 = isLeft ? R.id.id_toolbar_left : R.id.id_toolbar_right;
        View view = this.hsv_toolbar.findViewById(id2);
        if (view != null) {
            this.hsv_toolbar.removeView(view);
        }
    }

    protected View getCommonItemToolBtn() {
        return this.mInflater == null ? null : this.mInflater.inflate(R.layout.item_toolbtn, null);
    }

    protected void initItemToolBtn(View toolBtnView, int rec, final PageSetEntity pageSetEntity, View.OnClickListener onClickListener) {
        ImageView iv_icon = (ImageView)toolBtnView.findViewById(R.id.iv_icon);
        if (rec > 0) {
            iv_icon.setImageResource(rec);
        }
        LinearLayout.LayoutParams imgParams = new LinearLayout.LayoutParams(this.mBtnWidth, -1);
        iv_icon.setLayoutParams((ViewGroup.LayoutParams)imgParams);
        if (pageSetEntity != null) {
            iv_icon.setTag(R.id.id_tag_pageset, (Object)pageSetEntity);
            try {
                ImageLoader.getInstance(this.mContext).displayImage(pageSetEntity.getIconUri(), iv_icon);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        toolBtnView.setOnClickListener(onClickListener != null ? onClickListener : new View.OnClickListener(){

            public void onClick(View view) {
                if (EmoticonsToolBarView.this.mItemClickListeners != null && pageSetEntity != null) {
                    EmoticonsToolBarView.this.mItemClickListeners.onToolBarItemClick(pageSetEntity);
                }
            }
        });
    }

    protected View getToolBgBtn(View parentView) {
        return parentView.findViewById(R.id.iv_icon);
    }

    public void setToolBtnSelect(String uuid) {
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            return;
        }
        int select = 0;
        for (int i = 0; i < this.mToolBtnList.size(); ++i) {
            Object object = this.mToolBtnList.get(i).getTag(R.id.id_tag_pageset);
            if (object != null && object instanceof PageSetEntity && uuid.equals(((PageSetEntity)object).getUuid())) {
                this.mToolBtnList.get(i).setBackgroundColor(this.getResources().getColor(R.color.toolbar_btn_select));
                select = i;
                continue;
            }
            this.mToolBtnList.get(i).setBackgroundResource(R.drawable.btn_toolbtn_bg);
        }
        this.scrollToBtnPosition(select);
    }

    protected void scrollToBtnPosition(final int position) {
        int childCount = this.ly_tool.getChildCount();
        if (position < childCount) {
            this.hsv_toolbar.post(new Runnable(){

                @Override
                public void run() {
                    int hsvWidth;
                    int scrollRight;
                    int mScrollX = EmoticonsToolBarView.this.hsv_toolbar.getScrollX();
                    int childX = EmoticonsToolBarView.this.ly_tool.getChildAt(position).getLeft();
                    if (childX < mScrollX) {
                        EmoticonsToolBarView.this.hsv_toolbar.scrollTo(childX, 0);
                        return;
                    }
                    int childWidth = EmoticonsToolBarView.this.ly_tool.getChildAt(position).getWidth();
                    int childRight = childX + childWidth;
                    if (childRight > (scrollRight = mScrollX + (hsvWidth = EmoticonsToolBarView.this.hsv_toolbar.getWidth()))) {
                        EmoticonsToolBarView.this.hsv_toolbar.scrollTo(childRight - scrollRight, 0);
                        return;
                    }
                }
            });
        }
    }

    public void setBtnWidth(int width) {
        this.mBtnWidth = width;
    }

    public void setOnToolBarItemClickListener(OnToolBarItemClickListener listener) {
        this.mItemClickListeners = listener;
    }

    public static interface OnToolBarItemClickListener {
        public void onToolBarItemClick(PageSetEntity var1);
    }
}

