/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.adpater;

import android.support.v4.view.PagerAdapter;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import sj.keyboard.data.PageEntity;
import sj.keyboard.data.PageSetEntity;

public class PageSetAdapter
extends PagerAdapter {
    private final ArrayList<PageSetEntity> mPageSetEntityList = new ArrayList();

    public ArrayList<PageSetEntity> getPageSetEntityList() {
        return this.mPageSetEntityList;
    }

    public int getPageSetStartPosition(PageSetEntity pageSetEntity) {
        if (pageSetEntity == null || TextUtils.isEmpty((CharSequence)pageSetEntity.getUuid())) {
            return 0;
        }
        int startPosition = 0;
        for (int i = 0; i < this.mPageSetEntityList.size(); ++i) {
            if (i == this.mPageSetEntityList.size() - 1 && !pageSetEntity.getUuid().equals(this.mPageSetEntityList.get(i).getUuid())) {
                return 0;
            }
            if (pageSetEntity.getUuid().equals(this.mPageSetEntityList.get(i).getUuid())) {
                return startPosition;
            }
            startPosition += this.mPageSetEntityList.get(i).getPageCount();
        }
        return startPosition;
    }

    public void add(View view) {
        this.add(this.mPageSetEntityList.size(), view);
    }

    public void add(int index, View view) {
        PageSetEntity pageSetEntity = new PageSetEntity.Builder().addPageEntity(new PageEntity(view)).setShowIndicator(false).build();
        this.mPageSetEntityList.add(index, pageSetEntity);
    }

    public void add(PageSetEntity pageSetEntity) {
        this.add(this.mPageSetEntityList.size(), pageSetEntity);
    }

    public void add(int index, PageSetEntity pageSetEntity) {
        if (pageSetEntity == null) {
            return;
        }
        this.mPageSetEntityList.add(index, pageSetEntity);
    }

    public PageSetEntity get(int position) {
        return this.mPageSetEntityList.get(position);
    }

    public void remove(int position) {
        this.mPageSetEntityList.remove(position);
        this.notifyData();
    }

    public void notifyData() {
    }

    public PageEntity getPageEntity(int position) {
        for (PageSetEntity pageSetEntity : this.mPageSetEntityList) {
            if (pageSetEntity.getPageCount() > position) {
                return (PageEntity)pageSetEntity.getPageEntityList().get(position);
            }
            position -= pageSetEntity.getPageCount();
        }
        return null;
    }

    public int getCount() {
        int count = 0;
        for (PageSetEntity pageSetEntity : this.mPageSetEntityList) {
            count += pageSetEntity.getPageCount();
        }
        return count;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View view = this.getPageEntity(position).instantiateItem(container, position, null);
        if (view == null) {
            return null;
        }
        container.addView(view);
        return view;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public boolean isViewFromObject(View arg0, Object arg1) {
        return arg0 == arg1;
    }
}

