/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.adpater;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.keyboard.view.R;
import java.util.ArrayList;
import sj.keyboard.data.EmoticonPageEntity;
import sj.keyboard.interfaces.EmoticonClickListener;
import sj.keyboard.interfaces.EmoticonDisplayListener;

public class EmoticonsAdapter<T>
extends BaseAdapter {
    protected final int DEF_HEIGHTMAXTATIO = 2;
    protected final int mDefalutItemHeight;
    protected Context mContext;
    protected LayoutInflater mInflater;
    protected ArrayList<T> mData = new ArrayList();
    protected EmoticonPageEntity mEmoticonPageEntity;
    protected double mItemHeightMaxRatio;
    protected int mItemHeightMax;
    protected int mItemHeightMin;
    protected int mItemHeight;
    protected int mDelbtnPosition;
    protected EmoticonDisplayListener mOnDisPlayListener;
    protected EmoticonClickListener mOnEmoticonClickListener;

    public EmoticonsAdapter(Context context, EmoticonPageEntity emoticonPageEntity, EmoticonClickListener onEmoticonClickListener) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mEmoticonPageEntity = emoticonPageEntity;
        this.mOnEmoticonClickListener = onEmoticonClickListener;
        this.mItemHeightMaxRatio = 2.0;
        this.mDelbtnPosition = -1;
        this.mDefalutItemHeight = this.mItemHeight = (int)context.getResources().getDimension(R.dimen.item_emoticon_size_default);
        this.mData.addAll(emoticonPageEntity.getEmoticonList());
        this.checkDelBtn(emoticonPageEntity);
    }

    private void checkDelBtn(EmoticonPageEntity entity) {
        EmoticonPageEntity.DelBtnStatus delBtnStatus = entity.getDelBtnStatus();
        if (EmoticonPageEntity.DelBtnStatus.GONE.equals((Object)delBtnStatus)) {
            return;
        }
        if (EmoticonPageEntity.DelBtnStatus.FOLLOW.equals((Object)delBtnStatus)) {
            this.mDelbtnPosition = this.getCount();
            this.mData.add(null);
        } else if (EmoticonPageEntity.DelBtnStatus.LAST.equals((Object)delBtnStatus)) {
            int max = entity.getLine() * entity.getRow();
            while (this.getCount() < max) {
                this.mData.add(null);
            }
            this.mDelbtnPosition = this.getCount() - 1;
        }
    }

    public int getCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    public Object getItem(int position) {
        return this.mData == null ? null : this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            viewHolder.rootView = convertView = this.mInflater.inflate(R.layout.item_emoticon, null);
            viewHolder.ly_root = (LinearLayout)convertView.findViewById(R.id.ly_root);
            viewHolder.iv_emoticon = (ImageView)convertView.findViewById(R.id.iv_emoticon);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        this.bindView(position, parent, viewHolder);
        this.updateUI(viewHolder, parent);
        return convertView;
    }

    protected void bindView(int position, ViewGroup parent, ViewHolder viewHolder) {
        if (this.mOnDisPlayListener != null) {
            this.mOnDisPlayListener.onBindView(position, parent, viewHolder, this.mData.get(position), position == this.mDelbtnPosition);
        }
    }

    protected boolean isDelBtn(int position) {
        return position == this.mDelbtnPosition;
    }

    protected void updateUI(ViewHolder viewHolder, ViewGroup parent) {
        if (this.mDefalutItemHeight != this.mItemHeight) {
            viewHolder.iv_emoticon.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.mItemHeight));
        }
        this.mItemHeightMax = this.mItemHeightMax != 0 ? this.mItemHeightMax : (int)((double)this.mItemHeight * this.mItemHeightMaxRatio);
        this.mItemHeightMin = this.mItemHeightMin != 0 ? this.mItemHeightMin : this.mItemHeight;
        int realItemHeight = ((View)parent.getParent()).getMeasuredHeight() / this.mEmoticonPageEntity.getLine();
        realItemHeight = Math.min(realItemHeight, this.mItemHeightMax);
        realItemHeight = Math.max(realItemHeight, this.mItemHeightMin);
        viewHolder.ly_root.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, realItemHeight));
    }

    public void setOnDisPlayListener(EmoticonDisplayListener mOnDisPlayListener) {
        this.mOnDisPlayListener = mOnDisPlayListener;
    }

    public void setItemHeightMaxRatio(double mItemHeightMaxRatio) {
        this.mItemHeightMaxRatio = mItemHeightMaxRatio;
    }

    public void setItemHeightMax(int mItemHeightMax) {
        this.mItemHeightMax = mItemHeightMax;
    }

    public void setItemHeightMin(int mItemHeightMin) {
        this.mItemHeightMin = mItemHeightMin;
    }

    public void setItemHeight(int mItemHeight) {
        this.mItemHeight = mItemHeight;
    }

    public void setDelbtnPosition(int mDelbtnPosition) {
        this.mDelbtnPosition = mDelbtnPosition;
    }

    public static class ViewHolder {
        public View rootView;
        public LinearLayout ly_root;
        public ImageView iv_emoticon;
    }
}

