/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.keyboard.view.R;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import java.util.ArrayList;
import sj.keyboard.data.PageSetEntity;
import sj.keyboard.utils.EmoticonsKeyboardUtils;

public class EmoticonsIndicatorView
extends LinearLayout {
    private static final int MARGIN_LEFT = 4;
    protected Context mContext;
    protected ArrayList<ImageView> mImageViews;
    protected Bitmap mBmpSelect;
    protected Bitmap mBmpNomal;
    protected AnimatorSet mPlayToAnimatorSet;
    protected AnimatorSet mPlayByInAnimatorSet;
    protected AnimatorSet mPlayByOutAnimatorSet;
    protected LinearLayout.LayoutParams mLeftLayoutParams;

    public EmoticonsIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.setOrientation(0);
        this.mBmpSelect = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.indicator_point_select);
        this.mBmpNomal = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.indicator_point_nomal);
        this.mLeftLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.mLeftLayoutParams.leftMargin = EmoticonsKeyboardUtils.dip2px(context, 4.0f);
    }

    public void playTo(int position, PageSetEntity pageSetEntity) {
        if (!this.checkPageSetEntity(pageSetEntity)) {
            return;
        }
        this.updateIndicatorCount(pageSetEntity.getPageCount());
        for (ImageView iv : this.mImageViews) {
            iv.setImageBitmap(this.mBmpNomal);
        }
        this.mImageViews.get(position).setImageBitmap(this.mBmpSelect);
        ImageView imageViewStrat = this.mImageViews.get(position);
        ObjectAnimator animIn1 = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleX", (float[])new float[]{0.25f, 1.0f});
        ObjectAnimator animIn2 = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleY", (float[])new float[]{0.25f, 1.0f});
        if (this.mPlayToAnimatorSet != null && this.mPlayToAnimatorSet.isRunning()) {
            this.mPlayToAnimatorSet.cancel();
            this.mPlayToAnimatorSet = null;
        }
        this.mPlayToAnimatorSet = new AnimatorSet();
        this.mPlayToAnimatorSet.play((Animator)animIn1).with((Animator)animIn2);
        this.mPlayToAnimatorSet.setDuration(100L);
        this.mPlayToAnimatorSet.start();
    }

    public void playBy(int startPosition, int nextPosition, PageSetEntity pageSetEntity) {
        if (!this.checkPageSetEntity(pageSetEntity)) {
            return;
        }
        this.updateIndicatorCount(pageSetEntity.getPageCount());
        boolean isShowInAnimOnly = false;
        if (startPosition < 0 || nextPosition < 0 || nextPosition == startPosition) {
            nextPosition = 0;
            startPosition = 0;
        }
        if (startPosition < 0) {
            isShowInAnimOnly = true;
            nextPosition = 0;
            startPosition = 0;
        }
        final ImageView imageViewStrat = this.mImageViews.get(startPosition);
        final ImageView imageViewNext = this.mImageViews.get(nextPosition);
        ObjectAnimator anim1 = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleX", (float[])new float[]{1.0f, 0.25f});
        ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleY", (float[])new float[]{1.0f, 0.25f});
        if (this.mPlayByOutAnimatorSet != null && this.mPlayByOutAnimatorSet.isRunning()) {
            this.mPlayByOutAnimatorSet.cancel();
            this.mPlayByOutAnimatorSet = null;
        }
        this.mPlayByOutAnimatorSet = new AnimatorSet();
        this.mPlayByOutAnimatorSet.play((Animator)anim1).with((Animator)anim2);
        this.mPlayByOutAnimatorSet.setDuration(100L);
        ObjectAnimator animIn1 = ObjectAnimator.ofFloat((Object)imageViewNext, (String)"scaleX", (float[])new float[]{0.25f, 1.0f});
        ObjectAnimator animIn2 = ObjectAnimator.ofFloat((Object)imageViewNext, (String)"scaleY", (float[])new float[]{0.25f, 1.0f});
        if (this.mPlayByInAnimatorSet != null && this.mPlayByInAnimatorSet.isRunning()) {
            this.mPlayByInAnimatorSet.cancel();
            this.mPlayByInAnimatorSet = null;
        }
        this.mPlayByInAnimatorSet = new AnimatorSet();
        this.mPlayByInAnimatorSet.play((Animator)animIn1).with((Animator)animIn2);
        this.mPlayByInAnimatorSet.setDuration(100L);
        if (isShowInAnimOnly) {
            this.mPlayByInAnimatorSet.start();
            return;
        }
        anim1.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                imageViewStrat.setImageBitmap(EmoticonsIndicatorView.this.mBmpNomal);
                ObjectAnimator animFil1l = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleX", (float[])new float[]{1.0f});
                ObjectAnimator animFill2 = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleY", (float[])new float[]{1.0f});
                AnimatorSet mFillAnimatorSet = new AnimatorSet();
                mFillAnimatorSet.play((Animator)animFil1l).with((Animator)animFill2);
                mFillAnimatorSet.start();
                imageViewNext.setImageBitmap(EmoticonsIndicatorView.this.mBmpSelect);
                EmoticonsIndicatorView.this.mPlayByInAnimatorSet.start();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.mPlayByOutAnimatorSet.start();
    }

    protected boolean checkPageSetEntity(PageSetEntity pageSetEntity) {
        if (pageSetEntity != null && pageSetEntity.isShowIndicator()) {
            this.setVisibility(0);
            return true;
        }
        this.setVisibility(8);
        return false;
    }

    protected void updateIndicatorCount(int count) {
        int i;
        if (this.mImageViews == null) {
            this.mImageViews = new ArrayList();
        }
        if (count > this.mImageViews.size()) {
            for (i = this.mImageViews.size(); i < count; ++i) {
                ImageView imageView = new ImageView(this.mContext);
                imageView.setImageBitmap(i == 0 ? this.mBmpSelect : this.mBmpNomal);
                this.addView((View)imageView, (ViewGroup.LayoutParams)this.mLeftLayoutParams);
                this.mImageViews.add(imageView);
            }
        }
        for (i = 0; i < this.mImageViews.size(); ++i) {
            if (i >= count) {
                this.mImageViews.get(i).setVisibility(8);
                continue;
            }
            this.mImageViews.get(i).setVisibility(0);
        }
    }
}

