/*
 * Decompiled with CFR 0.152.
 */
package com.sj.emoji;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Looper;

public class EmojiDrawable
extends Drawable {
    private static final Paint paint = new Paint(3);
    private Bitmap bmp;

    public void draw(Canvas canvas) {
        if (this.bmp == null) {
            return;
        }
        canvas.drawBitmap(this.bmp, null, this.getBounds(), paint);
    }

    public void setBitmap(Bitmap bitmap) {
        EmojiDrawable.assertMainThread();
        if (bitmap == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 12 && bitmap.sameAs(this.bmp)) {
            return;
        }
        this.bmp = bitmap;
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public static void assertMainThread() {
        if (!EmojiDrawable.isMainThread()) {
            throw new AssertionError((Object)"Main-thread assertion failed.");
        }
    }

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }
}

