/*
 * Decompiled with CFR 0.152.
 */
package com.sj.emoji;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import com.sj.emoji.EmojiDrawable;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EmojiAsyncLoadTextView
extends TextView {
    protected final int POOL_COUNT = 10;
    protected Handler mainHandler = new Handler();
    protected ExecutorService executorService;

    public EmojiAsyncLoadTextView(Context context) {
        this(context, null);
    }

    public EmojiAsyncLoadTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EmojiAsyncLoadTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void invalidateDrawable(@NonNull Drawable drawable) {
        if (drawable instanceof EmojiDrawable) {
            this.invalidate();
        } else {
            super.invalidateDrawable(drawable);
        }
    }

    protected boolean checkExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(10);
        }
        return !this.executorService.isShutdown();
    }

    public void canelAllLoadTask() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    public void addAsyncLoadTask(final EmojiDrawable emojiDrawable, final String pathName) {
        if (!this.checkExecutorService()) {
            return;
        }
        if (emojiDrawable == null || TextUtils.isEmpty((CharSequence)pathName)) {
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)pathName)) {
                    return;
                }
                final Bitmap bm = BitmapFactory.decodeFile((String)pathName);
                if (EmojiAsyncLoadTextView.this.mainHandler == null) {
                    return;
                }
                EmojiAsyncLoadTextView.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (bm != null) {
                            emojiDrawable.setBitmap(bm);
                        }
                    }
                });
            }
        });
    }

    public void addAsyncLoadTask(final EmojiDrawable emojiDrawable, final Resources res, final int id, final BitmapFactory.Options opts) {
        if (!this.checkExecutorService()) {
            return;
        }
        if (emojiDrawable == null || res == null || id < 0) {
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                final Bitmap bm = BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)opts);
                if (EmojiAsyncLoadTextView.this.mainHandler == null) {
                    return;
                }
                EmojiAsyncLoadTextView.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (bm != null) {
                            emojiDrawable.setBitmap(bm);
                        }
                    }
                });
            }
        });
    }

    public void addAsyncLoadTask(final EmojiDrawable emojiDrawable, final InputStream inputStream) {
        if (!this.checkExecutorService()) {
            return;
        }
        if (emojiDrawable == null || inputStream == null) {
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                final Bitmap bm = BitmapFactory.decodeStream((InputStream)inputStream);
                if (EmojiAsyncLoadTextView.this.mainHandler == null) {
                    return;
                }
                EmojiAsyncLoadTextView.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (bm != null) {
                            emojiDrawable.setBitmap(bm);
                        }
                    }
                });
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.canelAllLoadTask();
    }
}

