/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class mxGraphSelectionModel
extends mxEventSource {
    protected mxGraph graph;
    protected boolean singleSelection = false;
    protected Set<Object> cells = new LinkedHashSet<Object>();

    public mxGraphSelectionModel(mxGraph graph) {
        this.graph = graph;
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    public void setSingleSelection(boolean singleSelection) {
        this.singleSelection = singleSelection;
    }

    public boolean isSelected(Object cell) {
        return cell == null ? false : this.cells.contains(cell);
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public int size() {
        return this.cells.size();
    }

    public void clear() {
        this.changeSelection(null, this.cells);
    }

    public Object getCell() {
        return this.cells.isEmpty() ? null : this.cells.iterator().next();
    }

    public Object[] getCells() {
        return this.cells.toArray();
    }

    public void setCell(Object cell) {
        if (cell != null) {
            this.setCells(new Object[]{cell});
        } else {
            this.clear();
        }
    }

    public void setCells(Object[] cells) {
        if (cells != null) {
            if (this.singleSelection) {
                cells = new Object[]{this.getFirstSelectableCell(cells)};
            }
            ArrayList<Object> tmp = new ArrayList<Object>(cells.length);
            for (int i = 0; i < cells.length; ++i) {
                if (!this.graph.isCellSelectable(cells[i])) continue;
                tmp.add(cells[i]);
            }
            this.changeSelection(tmp, this.cells);
        } else {
            this.clear();
        }
    }

    protected Object getFirstSelectableCell(Object[] cells) {
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                if (!this.graph.isCellSelectable(cells[i])) continue;
                return cells[i];
            }
        }
        return null;
    }

    public void addCell(Object cell) {
        if (cell != null) {
            this.addCells(new Object[]{cell});
        }
    }

    public void addCells(Object[] cells) {
        if (cells != null) {
            Set<Object> remove = null;
            if (this.singleSelection) {
                remove = this.cells;
                cells = new Object[]{this.getFirstSelectableCell(cells)};
            }
            ArrayList<Object> tmp = new ArrayList<Object>(cells.length);
            for (int i = 0; i < cells.length; ++i) {
                if (this.isSelected(cells[i]) || !this.graph.isCellSelectable(cells[i])) continue;
                tmp.add(cells[i]);
            }
            this.changeSelection(tmp, remove);
        }
    }

    public void removeCell(Object cell) {
        if (cell != null) {
            this.removeCells(new Object[]{cell});
        }
    }

    public void removeCells(Object[] cells) {
        if (cells != null) {
            ArrayList<Object> tmp = new ArrayList<Object>(cells.length);
            for (int i = 0; i < cells.length; ++i) {
                if (!this.isSelected(cells[i])) continue;
                tmp.add(cells[i]);
            }
            this.changeSelection(null, tmp);
        }
    }

    protected void changeSelection(Collection<Object> added, Collection<Object> removed) {
        if (added != null && !added.isEmpty() || removed != null && !removed.isEmpty()) {
            mxSelectionChange change = new mxSelectionChange(this, added, removed);
            change.execute();
            mxUndoableEdit edit = new mxUndoableEdit(this, false);
            edit.add(change);
            this.fireEvent(new mxEventObject("undo", "edit", edit));
        }
    }

    protected void cellAdded(Object cell) {
        if (cell != null) {
            this.cells.add(cell);
        }
    }

    protected void cellRemoved(Object cell) {
        if (cell != null) {
            this.cells.remove(cell);
        }
    }

    public static class mxSelectionChange
    implements mxUndoableEdit.mxUndoableChange {
        protected mxGraphSelectionModel model;
        protected Collection<Object> added;
        protected Collection<Object> removed;

        public mxSelectionChange(mxGraphSelectionModel model, Collection<Object> added, Collection<Object> removed) {
            this.model = model;
            this.added = added != null ? new ArrayList<Object>(added) : null;
            this.removed = removed != null ? new ArrayList<Object>(removed) : null;
        }

        @Override
        public void execute() {
            Iterator<Object> it;
            if (this.removed != null) {
                it = this.removed.iterator();
                while (it.hasNext()) {
                    this.model.cellRemoved(it.next());
                }
            }
            if (this.added != null) {
                it = this.added.iterator();
                while (it.hasNext()) {
                    this.model.cellAdded(it.next());
                }
            }
            Collection<Object> tmp = this.added;
            this.added = this.removed;
            this.removed = tmp;
            this.model.fireEvent(new mxEventObject("change", "added", this.added, "removed", this.removed));
        }
    }
}

