/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io;

import com.mxgraph.io.mxCodec;
import com.mxgraph.io.mxCodecRegistry;
import com.mxgraph.util.mxUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxObjectCodec {
    private static final Logger log = Logger.getLogger(mxObjectCodec.class.getName());
    private static Set<String> EMPTY_SET = new HashSet<String>();
    protected Object template;
    protected Set<String> exclude;
    protected Set<String> idrefs;
    protected Map<String, String> mapping;
    protected Map<String, String> reverse;
    protected Map<String, Method> accessors;
    protected Map<Class, Map<String, Field>> fields;

    public mxObjectCodec(Object template) {
        this(template, null, null, null);
    }

    public mxObjectCodec(Object template, String[] exclude, String[] idrefs, Map<String, String> mapping) {
        int i;
        this.template = template;
        if (exclude != null) {
            this.exclude = new HashSet<String>();
            for (i = 0; i < exclude.length; ++i) {
                this.exclude.add(exclude[i]);
            }
        } else {
            this.exclude = EMPTY_SET;
        }
        if (idrefs != null) {
            this.idrefs = new HashSet<String>();
            for (i = 0; i < idrefs.length; ++i) {
                this.idrefs.add(idrefs[i]);
            }
        } else {
            this.idrefs = EMPTY_SET;
        }
        if (mapping == null) {
            mapping = new Hashtable<String, String>();
        }
        this.mapping = mapping;
        this.reverse = new Hashtable<String, String>();
        for (Map.Entry<String, String> e : mapping.entrySet()) {
            this.reverse.put(e.getValue(), e.getKey());
        }
    }

    public String getName() {
        return mxCodecRegistry.getName(this.getTemplate());
    }

    public Object getTemplate() {
        return this.template;
    }

    protected Object cloneTemplate(Node node) {
        Hashtable obj = null;
        try {
            obj = this.template.getClass().isEnum() ? (Hashtable)this.template.getClass().getEnumConstants()[0] : (Hashtable)this.template.getClass().newInstance();
            if (obj instanceof Collection) {
                for (node = node.getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
                }
                if (node != null && node instanceof Element && ((Element)node).hasAttribute("as")) {
                    obj = new Hashtable();
                }
            }
        }
        catch (InstantiationException e) {
            log.log(Level.FINEST, "Failed to clone the template", e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.FINEST, "Failed to clone the template", e);
        }
        return obj;
    }

    public boolean isExcluded(Object obj, String attr, Object value, boolean write) {
        return this.exclude.contains(attr);
    }

    public boolean isReference(Object obj, String attr, Object value, boolean isWrite) {
        return this.idrefs.contains(attr);
    }

    public Node encode(mxCodec enc, Object obj) {
        Element node = enc.document.createElement(this.getName());
        obj = this.beforeEncode(enc, obj, node);
        this.encodeObject(enc, obj, node);
        return this.afterEncode(enc, obj, node);
    }

    protected void encodeObject(mxCodec enc, Object obj, Node node) {
        mxCodec.setAttribute(node, "id", enc.getId(obj));
        this.encodeFields(enc, obj, node);
        this.encodeElements(enc, obj, node);
    }

    protected void encodeFields(mxCodec enc, Object obj, Node node) {
        for (Class<?> type = obj.getClass(); type != null; type = type.getSuperclass()) {
            Field[] fields = type.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if ((f.getModifiers() & 0x80) == 128) continue;
                String fieldname = f.getName();
                Object value = this.getFieldValue(obj, fieldname);
                this.encodeValue(enc, obj, fieldname, value, node);
            }
        }
    }

    protected void encodeElements(mxCodec enc, Object obj, Node node) {
        block4: {
            block5: {
                block3: {
                    if (!obj.getClass().isArray()) break block3;
                    Object[] tmp = (Object[])obj;
                    for (int i = 0; i < tmp.length; ++i) {
                        this.encodeValue(enc, obj, null, tmp[i], node);
                    }
                    break block4;
                }
                if (!(obj instanceof Map)) break block5;
                for (Map.Entry e : ((Map)obj).entrySet()) {
                    this.encodeValue(enc, obj, String.valueOf(e.getKey()), e.getValue(), node);
                }
                break block4;
            }
            if (!(obj instanceof Collection)) break block4;
            for (Object value : (Collection)obj) {
                this.encodeValue(enc, obj, null, value, node);
            }
        }
    }

    protected void encodeValue(mxCodec enc, Object obj, String fieldname, Object value, Node node) {
        if (value != null && !this.isExcluded(obj, fieldname, value, true)) {
            if (this.isReference(obj, fieldname, value, true)) {
                String tmp = enc.getId(value);
                if (tmp == null) {
                    log.log(Level.FINEST, "mxObjectCodec.encode: No ID for " + this.getName() + "." + fieldname + "=" + value);
                    return;
                }
                value = tmp;
            }
            Object defaultValue = this.getFieldValue(this.template, fieldname);
            if (fieldname == null || enc.isEncodeDefaults() || defaultValue == null || !defaultValue.equals(value)) {
                this.writeAttribute(enc, obj, this.getAttributeName(fieldname), value, node);
            }
        }
    }

    protected boolean isPrimitiveValue(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Character || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value.getClass().isPrimitive();
    }

    protected void writeAttribute(mxCodec enc, Object obj, String attr, Object value, Node node) {
        if (this.isPrimitiveValue(value = this.convertValueToXml(value))) {
            this.writePrimitiveAttribute(enc, obj, attr, value, node);
        } else {
            this.writeComplexAttribute(enc, obj, attr, value, node);
        }
    }

    protected void writePrimitiveAttribute(mxCodec enc, Object obj, String attr, Object value, Node node) {
        if (attr == null || obj instanceof Map) {
            Element child = enc.document.createElement("add");
            if (attr != null) {
                mxCodec.setAttribute(child, "as", attr);
            }
            mxCodec.setAttribute(child, "value", value);
            node.appendChild(child);
        } else {
            mxCodec.setAttribute(node, attr, value);
        }
    }

    protected void writeComplexAttribute(mxCodec enc, Object obj, String attr, Object value, Node node) {
        Node child = enc.encode(value);
        if (child != null) {
            if (attr != null) {
                mxCodec.setAttribute(child, "as", attr);
            }
            node.appendChild(child);
        } else {
            log.log(Level.FINEST, "mxObjectCodec.encode: No node for " + this.getName() + "." + attr + ": " + value);
        }
    }

    protected Object convertValueToXml(Object value) {
        if (value instanceof Boolean) {
            value = (Boolean)value != false ? "1" : "0";
        }
        return value;
    }

    protected Object convertValueFromXml(Class<?> type, Object value) {
        if (value instanceof String) {
            String tmp = (String)value;
            if (type.equals(Boolean.TYPE) || type == Boolean.class) {
                if (tmp.equals("1") || tmp.equals("0")) {
                    tmp = tmp.equals("1") ? "true" : "false";
                }
                value = Boolean.valueOf(tmp);
            } else if (type.equals(Character.TYPE) || type == Character.class) {
                value = Character.valueOf(tmp.charAt(0));
            } else if (type.equals(Byte.TYPE) || type == Byte.class) {
                value = Byte.valueOf(tmp);
            } else if (type.equals(Short.TYPE) || type == Short.class) {
                value = Short.valueOf(tmp);
            } else if (type.equals(Integer.TYPE) || type == Integer.class) {
                value = Integer.valueOf(tmp);
            } else if (type.equals(Long.TYPE) || type == Long.class) {
                value = Long.valueOf(tmp);
            } else if (type.equals(Float.TYPE) || type == Float.class) {
                value = Float.valueOf(tmp);
            } else if (type.equals(Double.TYPE) || type == Double.class) {
                value = Double.valueOf(tmp);
            }
        }
        return value;
    }

    protected String getAttributeName(String fieldname) {
        String mapped;
        if (fieldname != null && (mapped = this.mapping.get(fieldname)) != null) {
            fieldname = mapped.toString();
        }
        return fieldname;
    }

    protected String getFieldName(String attributename) {
        String mapped;
        if (attributename != null && (mapped = this.reverse.get(attributename)) != null) {
            attributename = mapped.toString();
        }
        return attributename;
    }

    protected Field getField(Object obj, String fieldname) {
        Field field;
        Map<String, Field> map;
        Class<?> type = obj.getClass();
        if (this.fields == null) {
            this.fields = new HashMap<Class, Map<String, Field>>();
        }
        if ((map = this.fields.get(type)) == null) {
            map = new HashMap<String, Field>();
            this.fields.put(type, map);
        }
        if ((field = map.get(fieldname)) != null) {
            return field;
        }
        while (type != null) {
            try {
                field = type.getDeclaredField(fieldname);
                if (field != null) {
                    map.put(fieldname, field);
                    return field;
                }
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Failed to get field " + fieldname + " in class " + type, e);
            }
            type = type.getSuperclass();
        }
        log.log(Level.FINEST, "Field " + fieldname + " not found in " + obj);
        return null;
    }

    protected Method getAccessor(Object obj, Field field, boolean isGetter) {
        Method method;
        String name = field.getName();
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        name = !isGetter ? "set" + name : (Boolean.TYPE.isAssignableFrom(field.getType()) ? "is" + name : "get" + name);
        Method method2 = method = this.accessors != null ? this.accessors.get(name) : null;
        if (method == null) {
            try {
                method = isGetter ? this.getMethod(obj, name, null) : this.getMethod(obj, name, new Class[]{field.getType()});
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Failed to get method " + name + " from " + obj, e);
            }
            if (method != null) {
                if (this.accessors == null) {
                    this.accessors = new Hashtable<String, Method>();
                }
                this.accessors.put(name, method);
            }
        }
        if (method == null && log.isLoggable(Level.FINER)) {
            log.finer("Failed to find accessor for " + field + " in " + obj);
        }
        return method;
    }

    protected Method getMethod(Object obj, String methodname, Class[] params) {
        for (Class<?> type = obj.getClass(); type != null; type = type.getSuperclass()) {
            try {
                Method method = type.getDeclaredMethod(methodname, params);
                if (method == null) continue;
                return method;
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Failed to get method " + methodname + " in class " + type, e);
            }
        }
        return null;
    }

    protected Object getFieldValue(Object obj, String fieldname) {
        Object value = null;
        if (obj != null && fieldname != null) {
            Field field = this.getField(obj, fieldname);
            try {
                if (field != null) {
                    value = Modifier.isPublic(field.getModifiers()) ? field.get(obj) : this.getFieldValueWithAccessor(obj, field);
                }
            }
            catch (IllegalAccessException e1) {
                value = this.getFieldValueWithAccessor(obj, field);
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Failed to get value from field " + fieldname + " in " + obj, e);
            }
        }
        return value;
    }

    protected Object getFieldValueWithAccessor(Object obj, Field field) {
        Object value = null;
        if (field != null) {
            try {
                Method method = this.getAccessor(obj, field, true);
                if (method != null) {
                    value = method.invoke(obj, (Object[])null);
                }
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Failed to get value from field " + field + " in " + obj, e);
            }
        }
        return value;
    }

    protected void setFieldValue(Object obj, String fieldname, Object value) {
        Field field = null;
        try {
            field = this.getField(obj, fieldname);
            if (field != null) {
                if (field.getType() == Boolean.class) {
                    Object object = value = value.equals("1") || String.valueOf(value).equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Modifier.isPublic(field.getModifiers())) {
                    field.set(obj, value);
                } else {
                    this.setFieldValueWithAccessor(obj, field, value);
                }
            }
        }
        catch (IllegalAccessException e1) {
            this.setFieldValueWithAccessor(obj, field, value);
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Failed to set value \"" + value + "\" to field " + fieldname + " in " + obj, e);
        }
    }

    protected void setFieldValueWithAccessor(Object obj, Field field, Object value) {
        if (field != null) {
            try {
                Method method = this.getAccessor(obj, field, false);
                if (method != null) {
                    Class<?> type = method.getParameterTypes()[0];
                    value = this.convertValueFromXml(type, value);
                    if (type.isArray() && value instanceof Collection) {
                        Collection coll = (Collection)value;
                        value = coll.toArray((Object[])Array.newInstance(type.getComponentType(), coll.size()));
                    }
                    method.invoke(obj, new Object[]{value});
                }
            }
            catch (Exception e) {
                log.log(Level.FINEST, "setFieldValue: " + e + " on " + obj.getClass().getSimpleName() + "." + field.getName() + " (" + field.getType().getSimpleName() + ") = " + value + " (" + value.getClass().getSimpleName() + ")", e);
            }
        }
    }

    public Object beforeEncode(mxCodec enc, Object obj, Node node) {
        return obj;
    }

    public Node afterEncode(mxCodec enc, Object obj, Node node) {
        return node;
    }

    public Object decode(mxCodec dec, Node node) {
        return this.decode(dec, node, null);
    }

    public Object decode(mxCodec dec, Node node, Object into) {
        Object obj = null;
        if (node instanceof Element) {
            String id = ((Element)node).getAttribute("id");
            obj = dec.objects.get(id);
            if (obj == null) {
                obj = into;
                if (obj == null) {
                    obj = this.cloneTemplate(node);
                }
                if (id != null && id.length() > 0) {
                    dec.putObject(id, obj);
                }
            }
            node = this.beforeDecode(dec, node, obj);
            this.decodeNode(dec, node, obj);
            obj = this.afterDecode(dec, node, obj);
        }
        return obj;
    }

    protected void decodeNode(mxCodec dec, Node node, Object obj) {
        if (node != null) {
            this.decodeAttributes(dec, node, obj);
            this.decodeChildren(dec, node, obj);
        }
    }

    protected void decodeAttributes(mxCodec dec, Node node, Object obj) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                this.decodeAttribute(dec, attr, obj);
            }
        }
    }

    protected void decodeAttribute(mxCodec dec, Node attr, Object obj) {
        String name = attr.getNodeName();
        if (!name.equalsIgnoreCase("as") && !name.equalsIgnoreCase("id")) {
            Object value = attr.getNodeValue();
            String fieldname = this.getFieldName(name);
            if (this.isReference(obj, fieldname, value, false)) {
                Object tmp = dec.getObject(String.valueOf(value));
                if (tmp == null) {
                    log.log(Level.FINEST, "mxObjectCodec.decode: No object for " + this.getName() + "." + fieldname + "=" + value);
                    return;
                }
                value = tmp;
            }
            if (!this.isExcluded(obj, fieldname, value, false)) {
                this.setFieldValue(obj, fieldname, value);
            }
        }
    }

    protected void decodeChildren(mxCodec dec, Node node, Object obj) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || this.processInclude(dec, child, obj)) continue;
            this.decodeChild(dec, child, obj);
        }
    }

    protected void decodeChild(mxCodec dec, Node child, Object obj) {
        String fieldname = this.getFieldName(((Element)child).getAttribute("as"));
        if (fieldname == null || !this.isExcluded(obj, fieldname, child, false)) {
            Object template = this.getFieldTemplate(obj, fieldname, child);
            Object value = null;
            if (child.getNodeName().equals("add")) {
                value = ((Element)child).getAttribute("value");
                if (value == null) {
                    value = child.getTextContent();
                }
            } else {
                value = dec.decode(child, template);
            }
            this.addObjectValue(obj, fieldname, value, template);
        }
    }

    protected Object getFieldTemplate(Object obj, String fieldname, Node child) {
        Object template = this.getFieldValue(obj, fieldname);
        if (template != null && template.getClass().isArray()) {
            template = null;
        } else if (template instanceof Collection) {
            ((Collection)template).clear();
        }
        return template;
    }

    protected void addObjectValue(Object obj, String fieldname, Object value, Object template) {
        if (value != null && !value.equals(template)) {
            if (fieldname != null && obj instanceof Map) {
                ((Map)obj).put(fieldname, value);
            } else if (fieldname != null && fieldname.length() > 0) {
                this.setFieldValue(obj, fieldname, value);
            } else if (obj instanceof Collection) {
                ((Collection)obj).add(value);
            }
        }
    }

    public boolean processInclude(mxCodec dec, Node node, Object into) {
        if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("include")) {
            String name = ((Element)node).getAttribute("name");
            if (name != null) {
                try {
                    Element xml = mxUtils.loadDocument(mxObjectCodec.class.getResource(name).toString()).getDocumentElement();
                    if (xml != null) {
                        dec.decode(xml, into);
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINEST, "Cannot process include: " + name, e);
                }
            }
            return true;
        }
        return false;
    }

    public Node beforeDecode(mxCodec dec, Node node, Object obj) {
        return node;
    }

    public Object afterDecode(mxCodec dec, Node node, Object obj) {
        return obj;
    }
}

