/*
 * Decompiled with CFR 0.152.
 */
package com.github.vivchar.rendererrecyclerviewadapter;

import android.os.Bundle;
import android.os.Parcelable;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.AsyncDifferConfig;
import androidx.recyclerview.widget.AsyncListDiffer;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import androidx.recyclerview.widget.RecyclerView;
import com.github.vivchar.rendererrecyclerviewadapter.BaseViewRenderer;
import com.github.vivchar.rendererrecyclerviewadapter.CompositeViewHolder;
import com.github.vivchar.rendererrecyclerviewadapter.CompositeViewRenderer;
import com.github.vivchar.rendererrecyclerviewadapter.DefaultDiffCallback;
import com.github.vivchar.rendererrecyclerviewadapter.DiffCallback;
import com.github.vivchar.rendererrecyclerviewadapter.LoadMoreViewModel;
import com.github.vivchar.rendererrecyclerviewadapter.MainThreadExecutor;
import com.github.vivchar.rendererrecyclerviewadapter.OnLatchListener;
import com.github.vivchar.rendererrecyclerviewadapter.ViewFinderFactory;
import com.github.vivchar.rendererrecyclerviewadapter.ViewHolder;
import com.github.vivchar.rendererrecyclerviewadapter.ViewModel;
import com.github.vivchar.rendererrecyclerviewadapter.ViewState;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;

public class RendererRecyclerViewAdapter
extends RecyclerView.Adapter<ViewHolder> {
    protected static final String ITEM_VIEW_STATES_KEY = "renderer_adapter_item_view_states_key";
    protected static final String RECYCLER_VIEW_STATE_KEY = "renderer_adapter_recycler_view_state_key";
    @NonNull
    protected DiffCallback<? extends ViewModel> mDiffCallback = new DefaultDiffCallback<ViewModel>();
    @NonNull
    private AsyncListDiffer<ViewModel> mDiffer = this.createDiffer(this.mDiffCallback, false);
    @NonNull
    private final Collection<OnLatchListener> mOnLatchListeners = new LinkedList<OnLatchListener>();
    @NonNull
    private final MainThreadExecutor mMainThreadExecutor = new MainThreadExecutor();
    @NonNull
    protected final ArrayList<ViewModel> mItems = new ArrayList();
    @NonNull
    protected final ArrayList<BaseViewRenderer> mRenderers = new ArrayList();
    @NonNull
    protected final ArrayList<Type> mTypes = new ArrayList();
    @NonNull
    protected final HashMap<Integer, ViewState> mViewStates = new HashMap();
    @NonNull
    protected final ArrayList<ViewHolder> mBoundViewHolders = new ArrayList();
    @Nullable
    protected WeakReference<RecyclerView> mRecyclerView = null;
    @Nullable
    protected ListUpdateCallback mUpdateCallback = null;
    @NonNull
    protected LoadMoreViewModel mLoadMoreModel = new LoadMoreViewModel();
    @Nullable
    protected RecyclerView.RecycledViewPool mNestedRecycledViewPool = null;
    protected boolean mDiffUtilEnabled = false;
    protected boolean mLoadMoreVisible = false;
    protected int mLoadMorePosition;
    @Nullable
    private Bundle mSavedInstanceState;
    private boolean mSubmitting = false;

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int typeIndex) {
        BaseViewRenderer renderer = this.mRenderers.get(typeIndex);
        if (this.isCompositeRenderer(renderer) && this.mNestedRecycledViewPool != null) {
            ((CompositeViewRenderer)renderer).setRecycledViewPool(this.mNestedRecycledViewPool);
        }
        return renderer.performCreateViewHolder(parent);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position, @NonNull List payloads) {
        super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        Object item = this.getItem(position);
        BaseViewRenderer renderer = this.getRenderer((ViewModel)item);
        if (payloads == null || payloads.isEmpty()) {
            this.clearViewStateifNeed(holder);
            renderer.performBindView(item, holder);
            this.restoreViewState(holder);
        } else {
            renderer.performRebindView(item, holder, payloads);
        }
        this.mBoundViewHolders.remove((Object)holder);
        this.mBoundViewHolders.add(holder);
    }

    public void registerRenderer(@NonNull BaseViewRenderer renderer) {
        Type type = renderer.getType();
        if (this.mTypes.contains(type)) {
            throw new RuntimeException("ViewRenderer already registered for this type: " + type);
        }
        this.mTypes.add(type);
        this.mRenderers.add(renderer);
    }

    @NonNull
    protected BaseViewRenderer getRenderer(int position) {
        int typeIndex = this.getTypeIndex(position);
        return this.mRenderers.get(typeIndex);
    }

    @NonNull
    protected BaseViewRenderer getRenderer(@NonNull ViewModel model) {
        int typeIndex = this.getTypeIndex(model);
        return this.mRenderers.get(typeIndex);
    }

    @NonNull
    protected BaseViewRenderer getRenderer(@NonNull Type type) {
        int typeIndex = this.getTypeIndex(type);
        return this.mRenderers.get(typeIndex);
    }

    public int getItemViewType(int position) {
        return this.getTypeIndex(position);
    }

    protected int getTypeIndex(int position) {
        Object model = this.getItem(position);
        return this.getTypeIndex((ViewModel)model);
    }

    protected int getTypeIndex(@NonNull ViewModel model) {
        return this.getTypeIndex(model.getClass());
    }

    protected int getTypeIndex(@NonNull Type type) {
        int typeIndex = this.mTypes.indexOf(type);
        if (typeIndex == -1) {
            throw new RuntimeException("ViewRenderer not registered for this type: " + type);
        }
        return typeIndex;
    }

    @NonNull
    public Type getType(int position) {
        int typeIndex = this.getTypeIndex(position);
        return this.mTypes.get(typeIndex);
    }

    public void onViewRecycled(@NonNull ViewHolder holder) {
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        BaseViewRenderer renderer = this.getRenderer(holder.getType());
        renderer.viewRecycled(holder);
        int position = holder.getAdapterPosition();
        if (position != -1) {
            if (this.hasChildren(holder)) {
                this.onChildrenViewsRecycled(this.getChildAdapter((CompositeViewHolder)holder));
            }
            this.saveViewState(holder);
        }
        this.mBoundViewHolders.remove((Object)holder);
    }

    @NonNull
    public <T extends ViewModel> T getItem(int position) {
        return (T)this.getReadOnlyItems().get(position);
    }

    public int getItemCount() {
        return this.getReadOnlyItems().size();
    }

    public void enableDiffUtil() {
        this.enableDiffUtil(false);
    }

    public void enableDiffUtil(boolean async) {
        this.mDiffUtilEnabled = true;
        this.mDiffer = this.createDiffer(this.mDiffCallback, async);
    }

    public void disableDiffUtil() {
        this.mDiffUtilEnabled = false;
    }

    public void setDiffCallback(@NonNull DiffCallback<? extends ViewModel> diffCallback, boolean async) {
        this.mDiffCallback = diffCallback;
        this.enableDiffUtil(async);
    }

    public void setDiffCallback(@NonNull DiffCallback<? extends ViewModel> diffCallback) {
        this.setDiffCallback(diffCallback, false);
    }

    public void setUpdateCallback(@NonNull ListUpdateCallback updateCallback) {
        this.mUpdateCallback = updateCallback;
    }

    public void setItems(@NonNull List<? extends ViewModel> items, @NonNull OnLatchListener onLatchListener) {
        this.mOnLatchListeners.add(onLatchListener);
        this.setItems(items);
    }

    public void setItems(@NonNull List<? extends ViewModel> items) {
        if (this.mDiffUtilEnabled) {
            this.mSubmitting = true;
            this.mDiffer.submitList(new ArrayList<ViewModel>(items));
        } else {
            this.mItems.clear();
            this.mItems.addAll(items);
            this.dispatchLatched();
        }
        this.mLoadMoreVisible = false;
    }

    @NonNull
    protected ListUpdateCallback getListUpdateCallback() {
        return new ListUpdateCallback(){

            public void onInserted(int position, int count) {
                RendererRecyclerViewAdapter.this.dispatchLatched();
                if (RendererRecyclerViewAdapter.this.mUpdateCallback != null) {
                    RendererRecyclerViewAdapter.this.mUpdateCallback.onInserted(position, count);
                }
                RendererRecyclerViewAdapter.this.notifyItemRangeInserted(position, count);
            }

            public void onRemoved(int position, int count) {
                RendererRecyclerViewAdapter.this.dispatchLatched();
                if (RendererRecyclerViewAdapter.this.mUpdateCallback != null) {
                    RendererRecyclerViewAdapter.this.mUpdateCallback.onRemoved(position, count);
                }
                RendererRecyclerViewAdapter.this.notifyItemRangeRemoved(position, count);
            }

            public void onMoved(int fromPosition, int toPosition) {
                RendererRecyclerViewAdapter.this.dispatchLatched();
                if (RendererRecyclerViewAdapter.this.mUpdateCallback != null) {
                    RendererRecyclerViewAdapter.this.mUpdateCallback.onMoved(fromPosition, toPosition);
                }
                RendererRecyclerViewAdapter.this.notifyItemMoved(fromPosition, toPosition);
            }

            public void onChanged(int position, int count, Object payload) {
                RendererRecyclerViewAdapter.this.dispatchLatched();
                if (RendererRecyclerViewAdapter.this.mUpdateCallback != null) {
                    RendererRecyclerViewAdapter.this.mUpdateCallback.onChanged(position, count, payload);
                }
                RendererRecyclerViewAdapter.this.notifyItemRangeChanged(position, count, payload);
            }
        };
    }

    public void showLoadMore() {
        if (this.mDiffUtilEnabled) {
            OnLatchListener listener = new OnLatchListener(){

                @Override
                public void onLatch() {
                    if (!RendererRecyclerViewAdapter.this.mLoadMoreVisible) {
                        ArrayList<ViewModel> items = new ArrayList<ViewModel>(RendererRecyclerViewAdapter.this.getItemCount() + 1){
                            {
                                this.addAll(RendererRecyclerViewAdapter.this.getReadOnlyItems());
                                this.add(RendererRecyclerViewAdapter.this.mLoadMoreModel);
                            }
                        };
                        RendererRecyclerViewAdapter.this.mLoadMorePosition = RendererRecyclerViewAdapter.this.getItemCount() - 1;
                        RendererRecyclerViewAdapter.this.setItems((List<? extends ViewModel>)items);
                        RendererRecyclerViewAdapter.this.mLoadMoreVisible = true;
                    }
                }
            };
            if (this.mSubmitting) {
                this.mOnLatchListeners.add(listener);
            } else {
                listener.onLatch();
            }
        } else {
            this.mMainThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!RendererRecyclerViewAdapter.this.mLoadMoreVisible) {
                        RendererRecyclerViewAdapter.this.mLoadMoreVisible = true;
                        RendererRecyclerViewAdapter.this.mItems.add(RendererRecyclerViewAdapter.this.mLoadMoreModel);
                        RendererRecyclerViewAdapter.this.mLoadMorePosition = RendererRecyclerViewAdapter.this.getItemCount() - 1;
                        RendererRecyclerViewAdapter.this.notifyItemInserted(RendererRecyclerViewAdapter.this.mLoadMorePosition);
                    }
                }
            });
        }
    }

    public void hideLoadMore() {
        if (this.mLoadMoreVisible && this.mLoadMorePosition < this.getItemCount()) {
            if (this.mDiffUtilEnabled) {
                ArrayList<ViewModel> items = new ArrayList<ViewModel>(this.getItemCount()){
                    {
                        this.addAll(RendererRecyclerViewAdapter.this.getReadOnlyItems());
                        this.remove(RendererRecyclerViewAdapter.this.mLoadMorePosition);
                    }
                };
                this.setItems((List<? extends ViewModel>)items, new OnLatchListener(){

                    @Override
                    public void onLatch() {
                        RendererRecyclerViewAdapter.this.notifyItemRemoved(RendererRecyclerViewAdapter.this.mLoadMorePosition);
                        RendererRecyclerViewAdapter.this.mLoadMoreVisible = false;
                    }
                });
            } else {
                this.mMainThreadExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        RendererRecyclerViewAdapter.this.mItems.remove(RendererRecyclerViewAdapter.this.mLoadMorePosition);
                        RendererRecyclerViewAdapter.this.notifyItemRemoved(RendererRecyclerViewAdapter.this.mLoadMorePosition);
                        RendererRecyclerViewAdapter.this.mLoadMoreVisible = false;
                    }
                });
            }
        }
    }

    public void setNestedRecycledViewPool(@Nullable RecyclerView.RecycledViewPool pool) {
        this.mNestedRecycledViewPool = pool;
    }

    public void setLoadMoreModel(@NonNull LoadMoreViewModel model) {
        this.mLoadMoreModel = model;
    }

    @NonNull
    public ArrayList<ViewHolder> getBoundViewHolders() {
        return new ArrayList<ViewHolder>(this.mBoundViewHolders);
    }

    @NonNull
    public HashMap<Integer, ViewState> getStates() {
        this.saveBoundViewState();
        return new HashMap<Integer, ViewState>(this.mViewStates);
    }

    public void setStates(@NonNull HashMap<Integer, ViewState> states) {
        this.mViewStates.clear();
        this.mViewStates.putAll(states);
    }

    public void clearViewStates() {
        this.mViewStates.clear();
    }

    protected void saveBoundViewState() {
        for (ViewHolder holder : this.mBoundViewHolders) {
            this.saveViewState(holder);
        }
    }

    protected void saveViewState(@NonNull ViewHolder holder) {
        BaseViewRenderer viewRenderer = this.getRenderer(holder.getType());
        ViewState viewState = viewRenderer.createViewState();
        if (viewState != null) {
            if (holder.isSupportViewState()) {
                viewState.save(holder);
                this.mViewStates.put(holder.getViewStateID(), viewState);
            } else {
                throw new RuntimeException("You defined the " + viewState.getClass().getSimpleName() + " but didn't specify the ID. Please override onCreateViewStateID(model) method in your ViewRenderer.");
            }
        }
    }

    protected void clearViewState(@NonNull ViewHolder holder) {
        ViewState viewState;
        if (holder.isSupportViewState() && (viewState = this.getRenderer(holder.getType()).createViewState()) != null) {
            viewState.clear(holder);
        }
    }

    protected void clearViewStateifNeed(@NonNull ViewHolder holder) {
        if (holder.isSupportViewState()) {
            boolean hasSavedViewState;
            ViewState viewState = this.mViewStates.get(holder.getViewStateID());
            boolean bl = hasSavedViewState = viewState != null;
            if (!hasSavedViewState) {
                this.clearViewState(holder);
                if (this.hasChildren(holder)) {
                    this.getChildAdapter((CompositeViewHolder)holder).clearViewStates();
                }
            }
        }
    }

    protected void restoreViewState(@NonNull ViewHolder holder) {
        if (holder.isSupportViewState()) {
            boolean hasSavedViewState;
            ViewState viewState = this.mViewStates.get(holder.getViewStateID());
            boolean bl = hasSavedViewState = viewState != null;
            if (hasSavedViewState) {
                viewState.restore(holder);
            }
        }
    }

    protected void saveRecyclerViewState(@NonNull Bundle outState) {
        if (this.mRecyclerView != null && this.mRecyclerView.get() != null) {
            Parcelable recyclerViewState = ((RecyclerView)this.mRecyclerView.get()).getLayoutManager().onSaveInstanceState();
            outState.putParcelable(RECYCLER_VIEW_STATE_KEY, recyclerViewState);
        }
    }

    protected void restoreRecyclerViewState(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            Parcelable parcelable = savedInstanceState.getParcelable(RECYCLER_VIEW_STATE_KEY);
            if (parcelable != null && this.mRecyclerView != null && this.mRecyclerView.get() != null) {
                ((RecyclerView)this.mRecyclerView.get()).getLayoutManager().onRestoreInstanceState(parcelable);
                this.mSavedInstanceState = null;
            } else {
                this.mSavedInstanceState = savedInstanceState;
            }
        }
    }

    protected void onChildrenViewsRecycled(@NonNull RendererRecyclerViewAdapter adapter) {
        ArrayList<ViewHolder> boundViewHolders = adapter.getBoundViewHolders();
        for (ViewHolder viewHolder : boundViewHolders) {
            adapter.onViewRecycled(viewHolder);
        }
    }

    protected boolean hasChildren(@NonNull ViewHolder holder) {
        return holder instanceof CompositeViewHolder;
    }

    protected boolean isCompositeRenderer(@NonNull BaseViewRenderer renderer) {
        return renderer instanceof CompositeViewRenderer;
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = new WeakReference<RecyclerView>(recyclerView);
        this.restoreRecyclerViewState(this.mSavedInstanceState);
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        if (this.mRecyclerView != null) {
            this.mRecyclerView.clear();
            this.mRecyclerView = null;
        }
    }

    @NonNull
    protected RendererRecyclerViewAdapter getChildAdapter(@NonNull CompositeViewHolder holder) {
        return holder.getAdapter();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        this.saveBoundViewState();
        outState.putSerializable(ITEM_VIEW_STATES_KEY, this.getStates());
        this.saveRecyclerViewState(outState);
    }

    public void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        Serializable serializable;
        if (savedInstanceState != null && (serializable = savedInstanceState.getSerializable(ITEM_VIEW_STATES_KEY)) != null && serializable instanceof HashMap) {
            this.setStates((HashMap)serializable);
        }
        this.restoreRecyclerViewState(savedInstanceState);
    }

    @NonNull
    protected List<ViewModel> getReadOnlyItems() {
        return this.mDiffUtilEnabled ? this.mDiffer.getCurrentList() : Collections.unmodifiableList(this.mItems);
    }

    private void dispatchLatched() {
        this.mSubmitting = false;
        if (this.mOnLatchListeners.isEmpty()) {
            return;
        }
        Iterator<OnLatchListener> iterator = this.mOnLatchListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onLatch();
            iterator.remove();
        }
    }

    @NonNull
    private AsyncListDiffer<ViewModel> createDiffer(@NonNull DiffCallback<? extends ViewModel> diffCallback, boolean async) {
        return new AsyncListDiffer(this.getListUpdateCallback(), this.getConfig(diffCallback, async));
    }

    @NonNull
    private <V extends ViewModel> AsyncDifferConfig<V> getConfig(final @NonNull DiffCallback<V> diffUtil, boolean async) {
        AsyncDifferConfig.Builder builder = new AsyncDifferConfig.Builder(new DiffUtil.ItemCallback<V>(){

            public boolean areItemsTheSame(@NonNull V oldItem, @NonNull V newItem) {
                return diffUtil.areItemsTheSame(oldItem, newItem);
            }

            public boolean areContentsTheSame(@NonNull V oldItem, @NonNull V newItem) {
                return diffUtil.areContentsTheSame(oldItem, newItem);
            }

            @Nullable
            public Object getChangePayload(@NonNull V oldItem, @NonNull V newItem) {
                return diffUtil.getChangePayload(oldItem, newItem);
            }
        });
        if (!async) {
            builder.setBackgroundThreadExecutor((Executor)this.mMainThreadExecutor);
        }
        return builder.build();
    }

    public void registerViewFinder(@NonNull ViewFinderFactory.Creator creator) {
        ViewFinderFactory.setViewFinderCreator(creator);
    }
}

