/*
 * Decompiled with CFR 0.152.
 */
package com.github.vivchar.rendererrecyclerviewadapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.vivchar.rendererrecyclerviewadapter.ViewFinder;
import com.github.vivchar.rendererrecyclerviewadapter.ViewHolder;
import com.github.vivchar.rendererrecyclerviewadapter.ViewModel;
import com.github.vivchar.rendererrecyclerviewadapter.ViewState;
import com.github.vivchar.rendererrecyclerviewadapter.ViewStateProvider;
import com.github.vivchar.rendererrecyclerviewadapter.WrongViewFinderException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseViewRenderer<M extends ViewModel, VF extends ViewFinder, VH extends ViewHolder<VF>>
implements ViewStateProvider<M, VH> {
    protected Context mContext;
    @NonNull
    protected final Type mType;
    @LayoutRes
    protected final int mLayoutID;
    @NonNull
    protected final Binder<M, VF> mBinder;
    @Nullable
    protected ViewStateProvider<M, VH> mViewStateProvider = null;

    public BaseViewRenderer(@LayoutRes int layoutID, @NonNull Class<M> type, @NonNull Binder<M, VF> binder) {
        this.mType = type;
        this.mLayoutID = layoutID;
        this.mBinder = binder;
    }

    public BaseViewRenderer(@LayoutRes int layoutID, @NonNull Class<M> type, @NonNull Binder<M, VF> binder, @Nullable ViewStateProvider<M, VH> viewStateProvider) {
        this.mType = type;
        this.mLayoutID = layoutID;
        this.mBinder = binder;
        this.mViewStateProvider = viewStateProvider;
    }

    public void setContext(@NonNull Context context) {
        this.mContext = context;
    }

    protected Context getContext() {
        return this.mContext;
    }

    @NonNull
    protected VH performCreateViewHolder(@NonNull ViewGroup parent) {
        this.setContext(parent.getContext());
        return this.createViewHolder(parent);
    }

    void performRebindView(@NonNull M model, @NonNull VH holder, @NonNull List<Object> payloads) {
        this.rebindView(model, holder, payloads);
    }

    void performBindView(@NonNull M model, @NonNull VH holder) {
        ((ViewHolder)((Object)holder)).setType(model.getClass());
        ((ViewHolder)((Object)holder)).setViewStateID(this.createViewStateID(model));
        this.bindView(model, holder);
    }

    @CallSuper
    protected void bindView(@NonNull M model, @NonNull VH holder) {
        this.bindInner(model, holder, new ArrayList<Object>());
    }

    @CallSuper
    protected void rebindView(@NonNull M model, @NonNull VH holder, @NonNull List<Object> payloads) {
        this.bindInner(model, holder, payloads);
    }

    protected void bindInner(@NonNull M model, @NonNull VH holder, @NonNull List<Object> payloads) {
        try {
            this.mBinder.bindView(model, ((ViewHolder)((Object)holder)).getViewFinder(), payloads);
        }
        catch (ClassCastException e) {
            if (e.getMessage().contains(ViewFinder.class.getSimpleName())) {
                throw new WrongViewFinderException(e);
            }
            throw e;
        }
    }

    @NonNull
    public abstract VH createViewHolder(@NonNull ViewGroup var1);

    public void viewRecycled(@NonNull ViewHolder<VF> holder) {
    }

    @NonNull
    public Type getType() {
        return this.mType;
    }

    @Override
    @Nullable
    public ViewState createViewState() {
        return this.mViewStateProvider != null ? this.mViewStateProvider.createViewState() : null;
    }

    @Override
    public int createViewStateID(@NonNull M model) {
        return this.mViewStateProvider != null ? this.mViewStateProvider.createViewStateID(model) : -1;
    }

    @NonNull
    protected View inflate(@LayoutRes int layoutID, @NonNull ViewGroup parent) {
        return LayoutInflater.from((Context)this.getContext()).inflate(layoutID, parent, false);
    }

    public static interface Binder<M, VF extends ViewFinder> {
        public void bindView(@NonNull M var1, @NonNull VF var2, @NonNull List<Object> var3);
    }
}

