/*
 * Decompiled with CFR 0.152.
 */
package com.pvitaliy.validationtext;

import android.content.res.Resources;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;
import com.pvitaliy.validationedittext.ErrorMode;
import com.pvitaliy.validationedittext.R;
import com.pvitaliy.validationtext.OnValidation;
import com.pvitaliy.validationtext.ValidateResult;
import com.pvitaliy.validationtext.ValidationException;
import com.pvitaliy.validationtext.rules.ValidationRule;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J*\u0010!\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0016J*\u0010'\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0016J\u0010\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010\u0016J\u0016\u0010+\u001a\u00020\u001e2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010-J\u0006\u0010.\u001a\u00020\u001eJ\u0018\u0010.\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010/\u001a\u000200R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00061"}, d2={"Lcom/pvitaliy/validationtext/TextValidator;", "Landroid/text/TextWatcher;", "editText", "Landroid/widget/EditText;", "mode", "Lcom/pvitaliy/validationedittext/ErrorMode;", "(Landroid/widget/EditText;Lcom/pvitaliy/validationedittext/ErrorMode;)V", "callback", "Lcom/pvitaliy/validationtext/OnValidation;", "getCallback", "()Lcom/pvitaliy/validationtext/OnValidation;", "setCallback", "(Lcom/pvitaliy/validationtext/OnValidation;)V", "editTextWeek", "Ljava/lang/ref/WeakReference;", "errorMode", "getErrorMode", "()Lcom/pvitaliy/validationedittext/ErrorMode;", "setErrorMode", "(Lcom/pvitaliy/validationedittext/ErrorMode;)V", "rules", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Lcom/pvitaliy/validationtext/rules/ValidationRule;", "validationResult", "Lcom/pvitaliy/validationtext/ValidateResult;", "getValidationResult", "()Lcom/pvitaliy/validationtext/ValidateResult;", "setValidationResult", "(Lcom/pvitaliy/validationtext/ValidateResult;)V", "afterTextChanged", "", "s", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "", "count", "after", "onTextChanged", "before", "putRule", "rule", "setRules", "validationRules", "", "validateInput", "showError", "", "validationedittext_release"})
public final class TextValidator
implements TextWatcher {
    private final WeakReference<EditText> editTextWeek;
    private final CopyOnWriteArraySet<ValidationRule> rules;
    @NotNull
    public ValidateResult validationResult;
    @Nullable
    private OnValidation callback;
    @NotNull
    private ErrorMode errorMode;

    @NotNull
    public final ValidateResult getValidationResult() {
        ValidateResult validateResult = this.validationResult;
        if (validateResult == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"validationResult");
        }
        return validateResult;
    }

    public final void setValidationResult(@NotNull ValidateResult validateResult) {
        Intrinsics.checkParameterIsNotNull((Object)validateResult, (String)"<set-?>");
        this.validationResult = validateResult;
    }

    @Nullable
    public final OnValidation getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable OnValidation onValidation) {
        this.callback = onValidation;
    }

    @NotNull
    public final ErrorMode getErrorMode() {
        return this.errorMode;
    }

    public final void setErrorMode(@NotNull ErrorMode errorMode) {
        Intrinsics.checkParameterIsNotNull((Object)errorMode, (String)"<set-?>");
        this.errorMode = errorMode;
    }

    public final void setRules(@Nullable List<? extends ValidationRule> validationRules) {
        if (validationRules != null) {
            this.rules.clear();
            this.rules.addAll((Collection<ValidationRule>)validationRules);
        }
    }

    public final void validateInput() {
        block8: {
            boolean bl;
            EditText editText = (EditText)this.editTextWeek.get();
            if (editText == null) break block8;
            EditText editText2 = editText;
            boolean bl2 = false;
            boolean bl3 = false;
            EditText edit = editText2;
            boolean bl4 = false;
            EditText editText3 = edit;
            Intrinsics.checkExpressionValueIsNotNull((Object)editText3, (String)"edit");
            ErrorMode errorMode = this.errorMode;
            if (Intrinsics.areEqual((Object)errorMode, (Object)ErrorMode.None.INSTANCE)) {
                bl = false;
            } else if (Intrinsics.areEqual((Object)errorMode, (Object)ErrorMode.OnUserInput.INSTANCE)) {
                bl = edit.hasFocus();
            } else if (Intrinsics.areEqual((Object)errorMode, (Object)ErrorMode.Always.INSTANCE)) {
                bl = true;
            } else if (errorMode instanceof ErrorMode.Once) {
                bl = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.validateInput(editText3, bl);
        }
    }

    public final void validateInput(@NotNull EditText editText, boolean showError) {
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
            editText.setError((CharSequence)null);
            Object object = editText.getText();
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            Object text = object;
            boolean isValidText = true;
            Iterable $this$forEach$iv = this.rules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ValidationRule rule = (ValidationRule)element$iv;
                boolean bl = false;
                try {
                    Resources resources = editText.getResources();
                    Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"editText.resources");
                    rule.validate((String)text, resources);
                }
                catch (ValidationException e) {
                    CharSequence charSequence;
                    isValidText = false;
                    if (!showError) continue;
                    if (e.getReason() != null) {
                        charSequence = e.getReason();
                    } else {
                        Integer n = e.getReasonId();
                        charSequence = editText.getContext().getString(n != null ? n : R.string.VET_invalid_input);
                    }
                    editText.setError(charSequence);
                }
            }
            if (this.errorMode instanceof ErrorMode.Once) {
                ErrorMode errorMode = this.errorMode;
                if (errorMode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.pvitaliy.validationedittext.ErrorMode.Once");
                }
                this.errorMode = ((ErrorMode.Once)errorMode).getNextMode();
            }
            this.validationResult = new ValidateResult((String)text, (String)(isValidText ? text : ""), isValidText);
            OnValidation onValidation = this.callback;
            if (onValidation == null) break block9;
            ValidateResult validateResult = this.validationResult;
            if (validateResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"validationResult");
            }
            onValidation.onValidation(validateResult);
        }
    }

    public static /* synthetic */ void validateInput$default(TextValidator textValidator, EditText editText, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        textValidator.validateInput(editText, bl);
    }

    public void afterTextChanged(@Nullable Editable s) {
        this.validateInput();
    }

    public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
    }

    public final void putRule(@Nullable ValidationRule rule) {
        if (rule != null) {
            this.rules.add(rule);
        }
    }

    public TextValidator(@NotNull EditText editText, @NotNull ErrorMode mode) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        this.rules = new CopyOnWriteArraySet();
        this.errorMode = ErrorMode.None.INSTANCE;
        this.editTextWeek = new WeakReference<EditText>(editText);
        editText.addTextChangedListener((TextWatcher)this);
        this.errorMode = mode;
        this.validateInput(editText, Intrinsics.areEqual((Object)mode, (Object)ErrorMode.Always.INSTANCE));
    }

    public /* synthetic */ TextValidator(EditText editText, ErrorMode errorMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            errorMode = ErrorMode.None.INSTANCE;
        }
        this(editText, errorMode);
    }
}

