/*
 * Decompiled with CFR 0.152.
 */
package bov.vitali.smsinterceptor;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.telephony.SmsMessage;
import bov.vitali.smsinterceptor.OnMessageListener;
import bov.vitali.smsinterceptor.StringUtils;
import java.util.Arrays;

class SmsReceiver
extends BroadcastReceiver {
    private static OnMessageListener onMessageListener;
    private String[] phoneNumbers;
    private String regex;

    SmsReceiver() {
    }

    public void onReceive(Context context, Intent intent) {
        Object[] smsExtras;
        Bundle bundle = intent.getExtras();
        if (bundle != null && (smsExtras = (Object[])bundle.get("pdus")) != null) {
            for (Object pdu : smsExtras) {
                SmsMessage sms = this.getMessage(pdu, bundle);
                String number = sms.getDisplayOriginatingAddress();
                if (this.phoneNumbers != null && !Arrays.asList(this.phoneNumbers).contains(number)) {
                    return;
                }
                String message = sms.getDisplayMessageBody();
                if (this.regex != null) {
                    message = StringUtils.getSmsCode(message, this.regex);
                }
                if (onMessageListener == null) continue;
                onMessageListener.messageReceived(message);
            }
        }
    }

    static void bindListener(OnMessageListener listener) {
        onMessageListener = listener;
    }

    void setPhoneNumbers(String[] numbers) {
        this.phoneNumbers = numbers;
    }

    void setRegex(String regex) {
        this.regex = regex;
    }

    private SmsMessage getMessage(Object pdu, Bundle bundle) {
        SmsMessage sms;
        if (Build.VERSION.SDK_INT >= 23) {
            String format = bundle.getString("format");
            sms = SmsMessage.createFromPdu((byte[])((byte[])pdu), (String)format);
        } else {
            sms = SmsMessage.createFromPdu((byte[])((byte[])pdu));
        }
        return sms;
    }
}

