/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.SQLCommandType;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;

public class SQLCommandInfoHolder {
    private final SQLCommandType sqlCommandType;
    private final boolean isDistinct;
    private final boolean isCountAll;
    private final String table;
    private final long limit;
    private final Expression whereClause;
    private final List<SelectItem> selectItems;
    private final List<Join> joins;
    private final List<String> groupBys;
    private final List<OrderByElement> orderByElements;

    public SQLCommandInfoHolder(SQLCommandType sqlCommandType, Expression whereClause, boolean isDistinct, boolean isCountAll, String table, long limit, List<SelectItem> selectItems, List<Join> joins, List<String> groupBys, List<OrderByElement> orderByElements) {
        this.sqlCommandType = sqlCommandType;
        this.whereClause = whereClause;
        this.isDistinct = isDistinct;
        this.isCountAll = isCountAll;
        this.table = table;
        this.limit = limit;
        this.selectItems = selectItems;
        this.joins = joins;
        this.groupBys = groupBys;
        this.orderByElements = orderByElements;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public boolean isCountAll() {
        return this.isCountAll;
    }

    public String getTable() {
        return this.table;
    }

    public long getLimit() {
        return this.limit;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public List<String> getGoupBys() {
        return this.groupBys;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public SQLCommandType getSqlCommandType() {
        return this.sqlCommandType;
    }

    public static class Builder {
        private final FieldType defaultFieldType;
        private final Map<String, FieldType> fieldNameToFieldTypeMapping;
        private SQLCommandType sqlCommandType;
        private Expression whereClause;
        private boolean isDistinct = false;
        private boolean isCountAll = false;
        private String table;
        private long limit = -1L;
        private List<SelectItem> selectItems = new ArrayList<SelectItem>();
        private List<Join> joins = new ArrayList<Join>();
        private List<String> groupBys = new ArrayList<String>();
        private List<OrderByElement> orderByElements1 = new ArrayList<OrderByElement>();

        private Builder(FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) {
            this.defaultFieldType = defaultFieldType;
            this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping;
        }

        public Builder setJSqlParser(CCJSqlParser jSqlParser) throws ParseException, net.sf.jsqlparser.parser.ParseException {
            Statement statement = jSqlParser.Statement();
            if (Select.class.isAssignableFrom(statement.getClass())) {
                this.sqlCommandType = SQLCommandType.SELECT;
                PlainSelect plainSelect = (PlainSelect)((Select)statement).getSelectBody();
                SqlUtils.isTrue(plainSelect != null, "could not parseNaturalLanguageDate SELECT statement from query");
                SqlUtils.isTrue(plainSelect.getFromItem() != null, "could not find table to query.  Only one simple table name is supported.");
                this.whereClause = plainSelect.getWhere();
                this.isDistinct = plainSelect.getDistinct() != null;
                this.isCountAll = SqlUtils.isCountAll(plainSelect.getSelectItems());
                SqlUtils.isTrue(plainSelect.getFromItem() != null, "could not find table to query.  Only one simple table name is supported.");
                this.table = plainSelect.getFromItem().toString();
                this.limit = SqlUtils.getLimit(plainSelect.getLimit());
                this.orderByElements1 = plainSelect.getOrderByElements();
                this.selectItems = plainSelect.getSelectItems();
                this.joins = plainSelect.getJoins();
                this.groupBys = SqlUtils.getGroupByColumnReferences(plainSelect);
                SqlUtils.isTrue(plainSelect.getFromItem() != null, "could not find table to query.  Only one simple table name is supported.");
            } else if (Delete.class.isAssignableFrom(statement.getClass())) {
                this.sqlCommandType = SQLCommandType.DELETE;
                Delete delete = (Delete)statement;
                SqlUtils.isTrue(delete.getTables().size() == 0, "there should only be on table specified for deletes");
                this.table = delete.getTable().toString();
                this.whereClause = delete.getWhere();
            }
            return this;
        }

        public SQLCommandInfoHolder build() {
            return new SQLCommandInfoHolder(this.sqlCommandType, this.whereClause, this.isDistinct, this.isCountAll, this.table, this.limit, this.selectItems, this.joins, this.groupBys, this.orderByElements1);
        }

        public static Builder create(FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) {
            return new Builder(defaultFieldType, fieldNameToFieldTypeMapping);
        }
    }
}

