/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.MongoDBQueryHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.QueryResultIterator;
import com.github.vincentrussell.query.mongodb.sql.converter.SQLCommandInfoHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.SQLCommandType;
import com.github.vincentrussell.query.mongodb.sql.converter.WhereCauseProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.Token;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class QueryConverter {
    public static final String D_AGGREGATION_ALLOW_DISK_USE = "aggregationAllowDiskUse";
    public static final String D_AGGREGATION_BATCH_SIZE = "aggregationBatchSize";
    private final MongoDBQueryHolder mongoDBQueryHolder;
    private final Map<String, FieldType> fieldNameToFieldTypeMapping;
    private final FieldType defaultFieldType;
    private final SQLCommandInfoHolder sqlCommandInfoHolder;

    public QueryConverter(String sql) throws ParseException {
        this(new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8)), Collections.emptyMap(), FieldType.UNKNOWN);
    }

    public QueryConverter(String sql, Map<String, FieldType> fieldNameToFieldTypeMapping) throws ParseException {
        this(new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8)), fieldNameToFieldTypeMapping, FieldType.UNKNOWN);
    }

    public QueryConverter(String sql, FieldType fieldType) throws ParseException {
        this(new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8)), Collections.emptyMap(), fieldType);
    }

    public QueryConverter(String sql, Map<String, FieldType> fieldNameToFieldTypeMapping, FieldType defaultFieldType) throws ParseException {
        this(new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8)), fieldNameToFieldTypeMapping, defaultFieldType);
    }

    public QueryConverter(InputStream inputStream) throws ParseException {
        this(inputStream, Collections.emptyMap(), FieldType.UNKNOWN);
    }

    public QueryConverter(InputStream inputStream, Map<String, FieldType> fieldNameToFieldTypeMapping, FieldType defaultFieldType) throws ParseException {
        CCJSqlParser jSqlParser = new CCJSqlParser(inputStream, Charsets.UTF_8.name());
        try {
            this.defaultFieldType = defaultFieldType != null ? defaultFieldType : FieldType.UNKNOWN;
            this.sqlCommandInfoHolder = SQLCommandInfoHolder.Builder.create(defaultFieldType, fieldNameToFieldTypeMapping).setJSqlParser(jSqlParser).build();
            this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping != null ? fieldNameToFieldTypeMapping : Collections.emptyMap();
            Token nextToken = jSqlParser.getNextToken();
            SqlUtils.isTrue(StringUtils.isEmpty((String)nextToken.image) || ";".equals(nextToken.image), "unable to parse complete sql string. one reason for this is the use of double equals (==)");
            this.mongoDBQueryHolder = this.getMongoQueryInternal();
            this.validate();
        }
        catch (net.sf.jsqlparser.parser.ParseException e) {
            throw SqlUtils.convertParseException(e);
        }
    }

    private void validate() throws ParseException {
        List<SelectItem> selectItems = this.sqlCommandInfoHolder.getSelectItems();
        ArrayList filteredItems = Lists.newArrayList((Iterable)Iterables.filter(selectItems, (Predicate)new Predicate<SelectItem>(){

            public boolean apply(SelectItem selectItem) {
                try {
                    if (SelectExpressionItem.class.isInstance(selectItem) && Column.class.isInstance(((SelectExpressionItem)selectItem).getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }
        }));
        SqlUtils.isFalse((selectItems.size() > 1 || SqlUtils.isSelectAll(selectItems)) && this.sqlCommandInfoHolder.isDistinct(), "cannot run distinct one more than one column");
        SqlUtils.isFalse(this.sqlCommandInfoHolder.getGoupBys().size() == 0 && selectItems.size() != filteredItems.size() && !SqlUtils.isSelectAll(selectItems) && !SqlUtils.isCountAll(selectItems), "illegal expression(s) found in select clause.  Only column names supported");
        SqlUtils.isTrue(this.sqlCommandInfoHolder.getJoins() == null || this.sqlCommandInfoHolder.getJoins().isEmpty(), "Joins are not supported.  Only one simple table name is supported.");
    }

    public MongoDBQueryHolder getMongoQuery() {
        return this.mongoDBQueryHolder;
    }

    private MongoDBQueryHolder getMongoQueryInternal() throws ParseException {
        MongoDBQueryHolder mongoDBQueryHolder = new MongoDBQueryHolder(this.sqlCommandInfoHolder.getTable(), this.sqlCommandInfoHolder.getSqlCommandType());
        Document document = new Document();
        if (this.sqlCommandInfoHolder.isDistinct()) {
            document.put(this.sqlCommandInfoHolder.getSelectItems().get(0).toString(), (Object)1);
            mongoDBQueryHolder.setProjection(document);
            mongoDBQueryHolder.setDistinct(this.sqlCommandInfoHolder.isDistinct());
        } else if (this.sqlCommandInfoHolder.getGoupBys().size() > 0) {
            mongoDBQueryHolder.setGroupBys(this.sqlCommandInfoHolder.getGoupBys());
            mongoDBQueryHolder.setProjection(this.createProjectionsFromSelectItems(this.sqlCommandInfoHolder.getSelectItems(), this.sqlCommandInfoHolder.getGoupBys()));
        } else if (this.sqlCommandInfoHolder.isCountAll()) {
            mongoDBQueryHolder.setCountAll(this.sqlCommandInfoHolder.isCountAll());
        } else if (!SqlUtils.isSelectAll(this.sqlCommandInfoHolder.getSelectItems())) {
            document.put("_id", (Object)0);
            for (SelectItem selectItem : this.sqlCommandInfoHolder.getSelectItems()) {
                document.put(selectItem.toString(), (Object)1);
            }
            mongoDBQueryHolder.setProjection(document);
        }
        if (this.sqlCommandInfoHolder.getOrderByElements() != null && this.sqlCommandInfoHolder.getOrderByElements().size() > 0) {
            mongoDBQueryHolder.setSort(this.createSortInfoFromOrderByElements(this.sqlCommandInfoHolder.getOrderByElements()));
        }
        if (this.sqlCommandInfoHolder.getWhereClause() != null) {
            WhereCauseProcessor whereCauseProcessor = new WhereCauseProcessor(this.defaultFieldType, this.fieldNameToFieldTypeMapping);
            mongoDBQueryHolder.setQuery((Document)whereCauseProcessor.parseExpression(new Document(), this.sqlCommandInfoHolder.getWhereClause(), null));
        }
        mongoDBQueryHolder.setLimit(this.sqlCommandInfoHolder.getLimit());
        return mongoDBQueryHolder;
    }

    private Document createSortInfoFromOrderByElements(List<OrderByElement> orderByElements) throws ParseException {
        Document document = new Document();
        if (orderByElements == null && orderByElements.size() == 0) {
            return document;
        }
        final ArrayList functionItems = Lists.newArrayList((Iterable)Iterables.filter(orderByElements, (Predicate)new Predicate<OrderByElement>(){

            public boolean apply(OrderByElement orderByElement) {
                try {
                    if (net.sf.jsqlparser.expression.Function.class.isInstance(orderByElement.getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }
        }));
        ArrayList nonFunctionItems = Lists.newArrayList((Iterable)Collections2.filter(orderByElements, (Predicate)new Predicate<OrderByElement>(){

            public boolean apply(OrderByElement orderByElement) {
                return !functionItems.contains(orderByElement);
            }
        }));
        Document sortItems = new Document();
        for (OrderByElement orderByElement : orderByElements) {
            if (nonFunctionItems.contains(orderByElement)) {
                sortItems.put(SqlUtils.getStringValue(orderByElement.getExpression()), (Object)(orderByElement.isAsc() ? 1 : -1));
                continue;
            }
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)orderByElement.getExpression();
            Document parseFunctionDocument = new Document();
            this.parseFunctionForAggregation(function, parseFunctionDocument, Collections.emptyList());
            sortItems.put((String)Iterables.get((Iterable)parseFunctionDocument.keySet(), (int)0), (Object)(orderByElement.isAsc() ? 1 : -1));
        }
        return sortItems;
    }

    private Document createProjectionsFromSelectItems(List<SelectItem> selectItems, List<String> groupBys) throws ParseException {
        Document document = new Document();
        if (selectItems == null && selectItems.size() == 0) {
            return document;
        }
        final ArrayList functionItems = Lists.newArrayList((Iterable)Iterables.filter(selectItems, (Predicate)new Predicate<SelectItem>(){

            public boolean apply(SelectItem selectItem) {
                try {
                    if (SelectExpressionItem.class.isInstance(selectItem) && net.sf.jsqlparser.expression.Function.class.isInstance(((SelectExpressionItem)selectItem).getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }
        }));
        ArrayList nonFunctionItems = Lists.newArrayList((Iterable)Collections2.filter(selectItems, (Predicate)new Predicate<SelectItem>(){

            public boolean apply(SelectItem selectItem) {
                return !functionItems.contains(selectItem);
            }
        }));
        SqlUtils.isTrue(functionItems.size() > 0, "there must be at least one group by function specified in the select clause");
        SqlUtils.isTrue(nonFunctionItems.size() > 0, "there must be at least one non-function column specified");
        Document idDocument = new Document();
        for (SelectItem selectItem : nonFunctionItems) {
            Column column = (Column)((SelectExpressionItem)selectItem).getExpression();
            String columnName = SqlUtils.getStringValue((Expression)column);
            idDocument.put(columnName, (Object)("$" + columnName));
        }
        document.append("_id", idDocument.size() == 1 ? Iterables.get((Iterable)idDocument.values(), (int)0) : idDocument);
        for (SelectItem selectItem : functionItems) {
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)((SelectExpressionItem)selectItem).getExpression();
            this.parseFunctionForAggregation(function, document, groupBys);
        }
        return document;
    }

    private void parseFunctionForAggregation(net.sf.jsqlparser.expression.Function function, Document document, List<String> groupBys) throws ParseException {
        String field;
        List parameters;
        List list = parameters = function.getParameters() == null ? Collections.emptyList() : Lists.transform((List)function.getParameters().getExpressions(), (Function)new Function<Expression, String>(){

            public String apply(Expression expression) {
                return SqlUtils.getStringValue(expression);
            }
        });
        if (parameters.size() > 1) {
            throw new ParseException(function.getName() + " function can only have one parameter");
        }
        String string = field = parameters.size() > 0 ? ((String)Iterables.get((Iterable)parameters, (int)0)).replaceAll("\\.", "_") : null;
        if ("sum".equals(function.getName().toLowerCase())) {
            this.createFunction("sum", field, document, "$" + field);
        } else if ("avg".equals(function.getName().toLowerCase())) {
            this.createFunction("avg", field, document, "$" + field);
        } else if ("count".equals(function.getName().toLowerCase())) {
            document.put("count", (Object)new Document("$sum", (Object)1));
        } else if ("min".equals(function.getName().toLowerCase())) {
            this.createFunction("min", field, document, "$" + field);
        } else if ("max".equals(function.getName().toLowerCase())) {
            this.createFunction("max", field, document, "$" + field);
        } else {
            throw new ParseException("could not understand function:" + function.getName());
        }
    }

    private void createFunction(String functionName, String field, Document document, Object value) throws ParseException {
        SqlUtils.isTrue(field != null, "function " + functionName + " must contain a single field to run on");
        document.put(functionName + "_" + field, (Object)new Document("$" + functionName, value));
    }

    public void write(OutputStream outputStream) throws IOException {
        MongoDBQueryHolder mongoDBQueryHolder = this.getMongoQuery();
        if (mongoDBQueryHolder.isDistinct()) {
            IOUtils.write((String)("db." + mongoDBQueryHolder.getCollection() + ".distinct("), (OutputStream)outputStream);
            IOUtils.write((String)("\"" + this.getDistinctFieldName(mongoDBQueryHolder) + "\""), (OutputStream)outputStream);
            IOUtils.write((String)" , ", (OutputStream)outputStream);
            IOUtils.write((String)this.prettyPrintJson(mongoDBQueryHolder.getQuery().toJson()), (OutputStream)outputStream);
        } else if (this.sqlCommandInfoHolder.getGoupBys().size() > 0) {
            IOUtils.write((String)("db." + mongoDBQueryHolder.getCollection() + ".aggregate("), (OutputStream)outputStream);
            IOUtils.write((String)"[", (OutputStream)outputStream);
            ArrayList<Document> documents = new ArrayList<Document>();
            documents.add(new Document("$match", (Object)mongoDBQueryHolder.getQuery()));
            documents.add(new Document("$group", (Object)mongoDBQueryHolder.getProjection()));
            if (mongoDBQueryHolder.getSort() != null && mongoDBQueryHolder.getSort().size() > 0) {
                documents.add(new Document("$sort", (Object)mongoDBQueryHolder.getSort()));
            }
            if (mongoDBQueryHolder.getLimit() != -1L) {
                documents.add(new Document("$limit", (Object)mongoDBQueryHolder.getLimit()));
            }
            IOUtils.write((String)Joiner.on((String)",").join((Iterable)Lists.transform(documents, (Function)new Function<Document, String>(){

                public String apply(Document document) {
                    return QueryConverter.this.prettyPrintJson(document.toJson());
                }
            })), (OutputStream)outputStream);
            IOUtils.write((String)"]", (OutputStream)outputStream);
            Document options = new Document();
            if (System.getProperty(D_AGGREGATION_ALLOW_DISK_USE) != null) {
                options.put("allowDiskUse", (Object)Boolean.valueOf(System.getProperty(D_AGGREGATION_ALLOW_DISK_USE)));
            }
            if (System.getProperty(D_AGGREGATION_BATCH_SIZE) != null) {
                options.put("cursor", (Object)new Document("batchSize", (Object)Integer.valueOf(System.getProperty(D_AGGREGATION_BATCH_SIZE))));
            }
            if (options.size() > 0) {
                IOUtils.write((String)",", (OutputStream)outputStream);
                IOUtils.write((String)this.prettyPrintJson(options.toJson()), (OutputStream)outputStream);
            }
        } else if (this.sqlCommandInfoHolder.isCountAll()) {
            IOUtils.write((String)("db." + mongoDBQueryHolder.getCollection() + ".count("), (OutputStream)outputStream);
            IOUtils.write((String)this.prettyPrintJson(mongoDBQueryHolder.getQuery().toJson()), (OutputStream)outputStream);
        } else {
            IOUtils.write((String)("db." + mongoDBQueryHolder.getCollection() + ".find("), (OutputStream)outputStream);
            IOUtils.write((String)this.prettyPrintJson(mongoDBQueryHolder.getQuery().toJson()), (OutputStream)outputStream);
            if (mongoDBQueryHolder.getProjection() != null && mongoDBQueryHolder.getProjection().size() > 0) {
                IOUtils.write((String)" , ", (OutputStream)outputStream);
                IOUtils.write((String)this.prettyPrintJson(mongoDBQueryHolder.getProjection().toJson()), (OutputStream)outputStream);
            }
        }
        IOUtils.write((String)")", (OutputStream)outputStream);
        if (mongoDBQueryHolder.getSort() != null && mongoDBQueryHolder.getSort().size() > 0 && !this.sqlCommandInfoHolder.isCountAll() && !this.sqlCommandInfoHolder.isDistinct() && this.sqlCommandInfoHolder.getGoupBys().isEmpty()) {
            IOUtils.write((String)".sort(", (OutputStream)outputStream);
            IOUtils.write((String)this.prettyPrintJson(mongoDBQueryHolder.getSort().toJson()), (OutputStream)outputStream);
            IOUtils.write((String)")", (OutputStream)outputStream);
        }
        if (mongoDBQueryHolder.getLimit() != -1L && !this.sqlCommandInfoHolder.isCountAll() && !this.sqlCommandInfoHolder.isDistinct() && this.sqlCommandInfoHolder.getGoupBys().isEmpty()) {
            IOUtils.write((String)".limit(", (OutputStream)outputStream);
            IOUtils.write((String)(mongoDBQueryHolder.getLimit() + ""), (OutputStream)outputStream);
            IOUtils.write((String)")", (OutputStream)outputStream);
        }
    }

    private String getDistinctFieldName(MongoDBQueryHolder mongoDBQueryHolder) {
        return (String)Iterables.get((Iterable)mongoDBQueryHolder.getProjection().keySet(), (int)0);
    }

    public <T> T run(MongoDatabase mongoDatabase) {
        MongoDBQueryHolder mongoDBQueryHolder = this.getMongoQuery();
        MongoCollection mongoCollection = mongoDatabase.getCollection(mongoDBQueryHolder.getCollection());
        if (SQLCommandType.SELECT.equals((Object)mongoDBQueryHolder.getSqlCommandType())) {
            if (mongoDBQueryHolder.isDistinct()) {
                return (T)((Object)new QueryResultIterator(mongoCollection.distinct(this.getDistinctFieldName(mongoDBQueryHolder), (Bson)mongoDBQueryHolder.getQuery(), String.class)));
            }
            if (mongoDBQueryHolder.isCountAll()) {
                return (T)Long.valueOf(mongoCollection.count((Bson)mongoDBQueryHolder.getQuery()));
            }
            if (this.sqlCommandInfoHolder.getGoupBys().size() > 0) {
                ArrayList<Document> documents = new ArrayList<Document>();
                if (mongoDBQueryHolder.getQuery() != null && mongoDBQueryHolder.getQuery().size() > 0) {
                    documents.add(new Document("$match", (Object)mongoDBQueryHolder.getQuery()));
                }
                documents.add(new Document("$group", (Object)mongoDBQueryHolder.getProjection()));
                if (mongoDBQueryHolder.getSort() != null && mongoDBQueryHolder.getSort().size() > 0) {
                    documents.add(new Document("$sort", (Object)mongoDBQueryHolder.getSort()));
                }
                if (mongoDBQueryHolder.getLimit() != -1L) {
                    documents.add(new Document("$limit", (Object)mongoDBQueryHolder.getLimit()));
                }
                AggregateIterable aggregate = mongoCollection.aggregate(documents);
                if (System.getProperty(D_AGGREGATION_ALLOW_DISK_USE) != null) {
                    aggregate.allowDiskUse(Boolean.valueOf(System.getProperty(D_AGGREGATION_ALLOW_DISK_USE)));
                }
                if (System.getProperty(D_AGGREGATION_BATCH_SIZE) != null) {
                    aggregate.batchSize(Integer.valueOf(System.getProperty(D_AGGREGATION_BATCH_SIZE)).intValue());
                }
                return (T)((Object)new QueryResultIterator(aggregate));
            }
            FindIterable findIterable = mongoCollection.find((Bson)mongoDBQueryHolder.getQuery()).projection((Bson)mongoDBQueryHolder.getProjection());
            if (mongoDBQueryHolder.getSort() != null && mongoDBQueryHolder.getSort().size() > 0) {
                findIterable.sort((Bson)mongoDBQueryHolder.getSort());
            }
            if (mongoDBQueryHolder.getLimit() != -1L) {
                findIterable.limit((int)mongoDBQueryHolder.getLimit());
            }
            return (T)((Object)new QueryResultIterator(findIterable));
        }
        if (SQLCommandType.DELETE.equals((Object)mongoDBQueryHolder.getSqlCommandType())) {
            DeleteResult deleteResult = mongoCollection.deleteMany((Bson)mongoDBQueryHolder.getQuery());
            return (T)Long.valueOf(deleteResult.getDeletedCount());
        }
        throw new UnsupportedOperationException("SQL command type not supported");
    }

    private String prettyPrintJson(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(json);
        return gson.toJson(je);
    }
}

