package com.vimeo.networking2

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass
import com.vimeo.networking2.common.Pageable
import java.io.Serializable

/**
 * List of comments that are pageable.
 */
@JsonClass(generateAdapter = true)
data class CommentList(

    @Json(name = "total")
    override val total: Int? = null,

    @Json(name = "page")
    override val page: Int? = null,

    @Json(name = "per_page")
    override val perPage: Int? = null,

    @Json(name = "paging")
    override val paging: Paging? = null,

    @Json(name = "data")
    override val data: List<Comment>? = null

) : Pageable<Comment>, Serializable {

    companion object {
        private const val serialVersionUID = -11L
    }
}
