/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Socket;
import java.nio.charset.Charset;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.RemoteFile;
import se.vidstige.jadb.SyncTransport;
import se.vidstige.jadb.server.AdbDeviceResponder;
import se.vidstige.jadb.server.AdbResponder;

class AdbProtocolHandler
implements Runnable {
    private final Socket socket;
    private final AdbResponder responder;
    private AdbDeviceResponder selected;

    public AdbProtocolHandler(Socket socket, AdbResponder responder) {
        this.socket = socket;
        this.responder = responder;
    }

    private AdbDeviceResponder findDevice(String serial) throws ProtocolException {
        for (AdbDeviceResponder d : this.responder.getDevices()) {
            if (!d.getSerial().equals(serial)) continue;
            return d;
        }
        throw new ProtocolException("'" + serial + "' not connected");
    }

    @Override
    public void run() {
        block2: {
            try {
                this.runServer();
            }
            catch (IOException e) {
                if (e.getMessage() == null) break block2;
                System.out.println("IO Error: " + e.getMessage());
            }
        }
    }

    private void runServer() throws IOException {
        DataInputStream input = new DataInputStream(this.socket.getInputStream());
        DataOutputStream output = new DataOutputStream(this.socket.getOutputStream());
        while (true) {
            block17: {
                byte[] buffer = new byte[4];
                input.readFully(buffer);
                String encodedLength = new String(buffer, Charset.forName("utf-8"));
                int length = Integer.parseInt(encodedLength, 16);
                buffer = new byte[length];
                input.readFully(buffer);
                String command = new String(buffer, Charset.forName("utf-8"));
                this.responder.onCommand(command);
                try {
                    if ("host:version".equals(command)) {
                        output.writeBytes("OKAY");
                        this.send(output, String.format("%04x", this.responder.getVersion()));
                        break block17;
                    }
                    if ("host:transport-any".equals(command)) {
                        this.selected = this.responder.getDevices().get(0);
                        output.writeBytes("OKAY");
                        break block17;
                    }
                    if ("host:devices".equals(command)) {
                        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                        DataOutputStream writer = new DataOutputStream(tmp);
                        for (AdbDeviceResponder d : this.responder.getDevices()) {
                            writer.writeBytes(d.getSerial() + "\t" + d.getType() + "\n");
                        }
                        output.writeBytes("OKAY");
                        this.send(output, new String(tmp.toByteArray(), Charset.forName("utf-8")));
                        break block17;
                    }
                    if (command.startsWith("host:transport:")) {
                        String serial = command.substring("host:transport:".length());
                        this.selected = this.findDevice(serial);
                        output.writeBytes("OKAY");
                        break block17;
                    }
                    if ("sync:".equals(command)) {
                        output.writeBytes("OKAY");
                        try {
                            this.sync(output, input);
                        }
                        catch (JadbException e) {
                            SyncTransport sync = new SyncTransport(output, input);
                            sync.send("FAIL", e.getMessage());
                        }
                        break block17;
                    }
                    if (command.startsWith("shell:")) {
                        String shellCommand = command.substring("shell:".length());
                        output.writeBytes("OKAY");
                        this.shell(shellCommand, output, input);
                        output.close();
                        return;
                    }
                    if ("host:get-state".equals(command)) {
                        AdbDeviceResponder device = this.responder.getDevices().get(0);
                        output.writeBytes("OKAY");
                        this.send(output, device.getType());
                        break block17;
                    }
                    if (command.startsWith("host-serial:")) {
                        String[] strs = command.split(":", 0);
                        if (strs.length != 3) {
                            throw new ProtocolException("Invalid command: " + command);
                        }
                        String serial = strs[1];
                        boolean found = false;
                        output.writeBytes("OKAY");
                        for (AdbDeviceResponder d : this.responder.getDevices()) {
                            if (!d.getSerial().equals(serial)) continue;
                            this.send(output, d.getType());
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.send(output, "unknown");
                        }
                        break block17;
                    }
                    throw new ProtocolException("Unknown command: " + command);
                }
                catch (ProtocolException e) {
                    output.writeBytes("FAIL");
                    this.send(output, e.getMessage());
                }
            }
            output.flush();
        }
    }

    private void shell(String command, DataOutputStream stdout, DataInput stdin) throws IOException {
        this.selected.shell(command, stdout, stdin);
    }

    private int readInt(DataInput input) throws IOException {
        return Integer.reverseBytes(input.readInt());
    }

    private String readString(DataInput input, int length) throws IOException {
        byte[] responseBuffer = new byte[length];
        input.readFully(responseBuffer);
        return new String(responseBuffer, Charset.forName("utf-8"));
    }

    private void sync(DataOutput output, DataInput input) throws IOException, JadbException {
        String id = this.readString(input, 4);
        int length = this.readInt(input);
        if ("SEND".equals(id)) {
            String remotePath = this.readString(input, length);
            int idx = remotePath.lastIndexOf(44);
            String path = remotePath;
            int mode = 438;
            if (idx > 0) {
                path = remotePath.substring(0, idx);
                mode = Integer.parseInt(remotePath.substring(idx + 1));
            }
            SyncTransport transport = new SyncTransport(output, input);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            transport.readChunksTo(buffer);
            this.selected.filePushed(new RemoteFile(path), mode, buffer);
            transport.sendStatus("OKAY", 0);
        } else if ("RECV".equals(id)) {
            String remotePath = this.readString(input, length);
            SyncTransport transport = new SyncTransport(output, input);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.selected.filePulled(new RemoteFile(remotePath), buffer);
            transport.sendStream(new ByteArrayInputStream(buffer.toByteArray()));
            transport.sendStatus("DONE", 0);
        } else {
            throw new JadbException("Unknown sync id " + id);
        }
    }

    private String getCommandLength(String command) {
        return String.format("%04x", command.length());
    }

    public void send(DataOutput writer, String response) throws IOException {
        writer.writeBytes(this.getCommandLength(response));
        writer.writeBytes(response);
    }
}

