/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.IOException;
import se.vidstige.jadb.DeviceDetectionListener;
import se.vidstige.jadb.JadbConnection;
import se.vidstige.jadb.Transport;

public class DeviceWatcher
implements Runnable {
    private Transport transport;
    private final DeviceDetectionListener listener;
    private final JadbConnection connection;

    public DeviceWatcher(Transport transport, DeviceDetectionListener listener, JadbConnection connection) {
        this.transport = transport;
        this.listener = listener;
        this.connection = connection;
    }

    @Override
    public void run() {
        this.watch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch() {
        try {
            while (true) {
                this.listener.onDetect(this.connection.parseDevices(this.transport.readString()));
            }
        }
        catch (IOException ioe) {
            DeviceWatcher deviceWatcher = this;
            synchronized (deviceWatcher) {
                if (this.transport != null) {
                    this.listener.onException(ioe);
                }
            }
        }
        catch (Exception e) {
            this.listener.onException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        DeviceWatcher deviceWatcher = this;
        synchronized (deviceWatcher) {
            this.transport.close();
            this.transport = null;
        }
    }
}

