/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.IOException;
import java.util.Map;
import se.vidstige.jadb.Subprocess;

public class AdbServerLauncher {
    private final String executable;
    private Subprocess subprocess;

    public AdbServerLauncher(Subprocess subprocess, Map<String, String> environment) {
        this(subprocess, AdbServerLauncher.findAdbExecutable(environment));
    }

    public AdbServerLauncher(Subprocess subprocess, String executable) {
        this.subprocess = subprocess;
        this.executable = executable;
    }

    private static String findAdbExecutable(Map<String, String> environment) {
        String android_home = environment.get("ANDROID_HOME");
        if (android_home == null || android_home.equals("")) {
            return "adb";
        }
        return android_home + "/platform-tools/adb";
    }

    public void launch() throws IOException, InterruptedException {
        Process p = this.subprocess.execute(new String[]{this.executable, "start-server"});
        p.waitFor();
        int exitValue = p.exitValue();
        if (exitValue != 0) {
            throw new IOException("adb exited with exit code: " + exitValue);
        }
    }
}

