/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb.managers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.vidstige.jadb.JadbDevice;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.RemoteFile;
import se.vidstige.jadb.Stream;
import se.vidstige.jadb.managers.Bash;
import se.vidstige.jadb.managers.Package;

public class PackageManager {
    private final JadbDevice device;

    public PackageManager(JadbDevice device) {
        this.device = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Package> getPackages() throws IOException, JadbException {
        ArrayList<Package> result = new ArrayList<Package>();
        try (BufferedReader input = null;){
            String line;
            input = new BufferedReader(new InputStreamReader(this.device.executeShell("pm", "list", "packages"), Charset.forName("UTF-8")));
            while ((line = input.readLine()) != null) {
                String prefix = "package:";
                if (!line.startsWith("package:")) continue;
                result.add(new Package(line.substring("package:".length())));
            }
        }
        return result;
    }

    private String getErrorMessage(String operation, String target, String errorMessage) {
        return "Could not " + operation + " " + target + ": " + errorMessage;
    }

    private void verifyOperation(String operation, String target, String result) throws JadbException {
        if (!result.contains("Success")) {
            throw new JadbException(this.getErrorMessage(operation, target, result));
        }
    }

    public void remove(RemoteFile file) throws IOException, JadbException {
        InputStream s = this.device.executeShell("rm", "-f", Bash.quote(file.getPath()));
        Stream.readAll(s, Charset.forName("UTF-8"));
    }

    public void install(File apkFile, List<String> extraArguments) throws IOException, JadbException {
        RemoteFile remote = new RemoteFile("/sdcard/tmp/" + apkFile.getName());
        this.device.push(apkFile, remote);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("install");
        arguments.addAll(extraArguments);
        arguments.add(remote.getPath());
        InputStream s = this.device.executeShell("pm", arguments.toArray(new String[arguments.size()]));
        String result = Stream.readAll(s, Charset.forName("UTF-8"));
        this.remove(remote);
        this.verifyOperation("install", apkFile.getName(), result);
    }

    public void install(File apkFile) throws IOException, JadbException {
        this.install(apkFile, new ArrayList<String>(0));
    }

    public void forceInstall(File apkFile) throws IOException, JadbException {
        this.install(apkFile, Collections.singletonList("-r"));
    }

    public void uninstall(Package name) throws IOException, JadbException {
        InputStream s = this.device.executeShell("pm", "uninstall", name.toString());
        String result = Stream.readAll(s, Charset.forName("UTF-8"));
        this.verifyOperation("uninstall", name.toString(), result);
    }

    public void launch(Package name) throws IOException, JadbException {
        InputStream s = this.device.executeShell("monkey", "-p", name.toString(), "-c", "android.intent.category.LAUNCHER", "1");
    }
}

