/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.swagger2;

import com.fasterxml.classmate.ResolvedType;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SubtypeResolver;
import com.github.victools.jsonschema.generator.TypeContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Swagger2SubtypeResolver
implements SubtypeResolver {
    public List<ResolvedType> findSubtypes(ResolvedType declaredType, SchemaGenerationContext context) {
        Schema annotation = declaredType.getErasedType().getAnnotation(Schema.class);
        if (annotation == null || annotation.subTypes().length == 0 && annotation.anyOf().length == 0) {
            return null;
        }
        TypeContext typeContext = context.getTypeContext();
        if (annotation.subTypes().length > 0) {
            return Stream.of(annotation.subTypes()).map(erasedSubtype -> typeContext.resolveSubtype(declaredType, erasedSubtype)).collect(Collectors.toList());
        }
        return Stream.of(annotation.anyOf()).map(erasedType -> typeContext.resolve((Type)erasedType, new Type[0])).collect(Collectors.toList());
    }
}

