/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.github.victools.jsonschema.generator.AnnotationHelper;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.module.jackson.JacksonSchemaModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class JsonUnwrappedDefinitionProvider
implements CustomDefinitionProviderV2 {
    public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
        if (javaType == null) {
            return null;
        }
        ResolvedTypeWithMembers typeWithMembers = context.getTypeContext().resolveWithMembers(javaType);
        if (Arrays.stream(typeWithMembers.getMemberFields()).noneMatch(this::hasJsonUnwrappedAnnotation) && Arrays.stream(typeWithMembers.getMemberMethods()).noneMatch(this::hasJsonUnwrappedAnnotation)) {
            return null;
        }
        ObjectNode definition = context.createStandardDefinition(javaType, (CustomDefinitionProviderV2)this);
        ArrayNode allOf = definition.withArray(context.getKeyword(SchemaKeyword.TAG_ALLOF));
        Stream.concat(Stream.of(typeWithMembers.getMemberFields()), Stream.of(typeWithMembers.getMemberMethods())).map(member -> this.createUnwrappedMemberSchema((ResolvedMember<?>)member, context)).filter(Optional::isPresent).map(Optional::get).forEachOrdered(arg_0 -> ((ArrayNode)allOf).add(arg_0));
        return new CustomDefinition(definition);
    }

    private boolean hasJsonUnwrappedAnnotation(ResolvedMember<?> member) {
        return AnnotationHelper.resolveAnnotation(member, JsonUnwrapped.class, JacksonSchemaModule.NESTED_ANNOTATION_CHECK).filter(JsonUnwrapped::enabled).isPresent();
    }

    private Optional<ObjectNode> createUnwrappedMemberSchema(ResolvedMember<?> member, SchemaGenerationContext context) {
        return AnnotationHelper.resolveAnnotation(member, JsonUnwrapped.class, JacksonSchemaModule.NESTED_ANNOTATION_CHECK).filter(JsonUnwrapped::enabled).map(annotation -> {
            ObjectNode definition = context.createStandardDefinition(member.getType(), null);
            if (!annotation.prefix().isEmpty() || !annotation.suffix().isEmpty()) {
                this.applyPrefixAndSuffixToPropertyNames((JsonNode)definition, annotation.prefix(), annotation.suffix(), context);
            }
            return definition;
        });
    }

    private void applyPrefixAndSuffixToPropertyNames(JsonNode definition, String prefix, String suffix, SchemaGenerationContext context) {
        JsonNode allOf;
        ObjectNode propertiesNode;
        JsonNode properties = definition.get(context.getKeyword(SchemaKeyword.TAG_PROPERTIES));
        if (properties instanceof ObjectNode && !(propertiesNode = (ObjectNode)properties).isEmpty()) {
            ArrayList fieldNames = new ArrayList(propertiesNode.propertyNames());
            for (String fieldName : fieldNames) {
                JsonNode propertySchema = propertiesNode.remove(fieldName);
                propertiesNode.set(prefix + fieldName + suffix, propertySchema);
            }
        }
        if ((allOf = definition.get(context.getKeyword(SchemaKeyword.TAG_ALLOF))) instanceof ArrayNode) {
            allOf.forEach(allOfEntry -> this.applyPrefixAndSuffixToPropertyNames((JsonNode)allOfEntry, prefix, suffix, context));
        }
    }
}

