/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CustomEnumJsonValueDefinitionProvider
implements CustomDefinitionProviderV2 {
    public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
        T[] enumConstants = javaType.getErasedType().getEnumConstants();
        if (enumConstants == null || enumConstants.length == 0) {
            return null;
        }
        ResolvedMethod jsonValueAnnotatedEnumMethod = this.getJsonValueAnnotatedMethod(javaType, context);
        if (jsonValueAnnotatedEnumMethod == null) {
            return null;
        }
        ArrayList<Object> serialisedJsonValues = new ArrayList<Object>(enumConstants.length);
        try {
            for (Object enumConstant : enumConstants) {
                serialisedJsonValues.add(((Method)jsonValueAnnotatedEnumMethod.getRawMember()).invoke(enumConstant, new Object[0]));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            return null;
        }
        ObjectNode customNode = context.getGeneratorConfig().createObjectNode().put(context.getKeyword(SchemaKeyword.TAG_TYPE), context.getKeyword(SchemaKeyword.TAG_TYPE_STRING));
        AttributeCollector standardAttributeCollector = new AttributeCollector(context.getGeneratorConfig().getObjectMapper());
        standardAttributeCollector.setEnum(customNode, serialisedJsonValues, context);
        return new CustomDefinition(customNode);
    }

    protected ResolvedMethod getJsonValueAnnotatedMethod(ResolvedType javaType, SchemaGenerationContext context) {
        ResolvedMethod[] memberMethods = context.getTypeContext().resolveWithMembers(javaType).getMemberMethods();
        Set jsonValueAnnotatedMethods = Stream.of(memberMethods).filter(method -> method.getArgumentCount() == 0).filter(method -> Optional.ofNullable(method.getAnnotations().get(JsonValue.class)).map(JsonValue::value).orElse(false)).collect(Collectors.toSet());
        if (jsonValueAnnotatedMethods.size() == 1) {
            return (ResolvedMethod)jsonValueAnnotatedMethods.iterator().next();
        }
        return null;
    }
}

