/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.plugin.maven;

import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.impl.Util;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.jackson.JacksonSchemaModule;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationModule;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationOption;
import com.github.victools.jsonschema.module.javax.validation.JavaxValidationModule;
import com.github.victools.jsonschema.module.javax.validation.JavaxValidationOption;
import com.github.victools.jsonschema.module.swagger15.SwaggerModule;
import com.github.victools.jsonschema.module.swagger15.SwaggerOption;
import com.github.victools.jsonschema.module.swagger2.Swagger2Module;
import com.github.victools.jsonschema.plugin.maven.AnnotationParameter;
import com.github.victools.jsonschema.plugin.maven.ClasspathType;
import com.github.victools.jsonschema.plugin.maven.GeneratorModule;
import com.github.victools.jsonschema.plugin.maven.GeneratorOptions;
import com.github.victools.jsonschema.plugin.maven.GlobHandler;
import com.github.victools.jsonschema.plugin.maven.PotentialSchemaClass;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ObjectNode;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class SchemaGeneratorMojo
extends AbstractMojo {
    @Parameter(property="classNames")
    private String[] classNames;
    @Parameter(property="packageNames")
    private String[] packageNames;
    @Parameter(property="excludeClassNames")
    private String[] excludeClassNames;
    @Parameter(property="annotations")
    private List<AnnotationParameter> annotations = new ArrayList<AnnotationParameter>();
    @Parameter(property="skipAbstractTypes", defaultValue="false")
    private boolean skipAbstractTypes;
    @Parameter(property="skipInterfaces", defaultValue="false")
    private boolean skipInterfaces;
    @Parameter(property="classpath", defaultValue="WITH_RUNTIME_DEPENDENCIES")
    private ClasspathType classpath;
    @Parameter(property="schemaFilePath")
    private File schemaFilePath;
    @Parameter(property="schemaFileName", defaultValue="{0}-schema.json")
    private String schemaFileName;
    @Parameter(property="schemaVersion", defaultValue="DRAFT_7")
    private SchemaVersion schemaVersion;
    @Parameter
    private GeneratorOptions options;
    @Parameter
    private GeneratorModule[] modules;
    @Parameter(property="failIfNoClassesMatch", defaultValue="true")
    private boolean failIfNoClassesMatch;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    private SchemaGenerator generator;
    private URLClassLoader classLoader;
    private List<PotentialSchemaClass> allTypes;

    public synchronized void execute() throws MojoExecutionException {
        this.getGenerator();
        for (String className : Util.nullSafe((Object[])this.classNames)) {
            this.getLog().info((CharSequence)("Generating JSON Schema for <className>" + className + "</className>"));
            this.generateSchema(className, false);
        }
        for (String packageName : Util.nullSafe((Object[])this.packageNames)) {
            this.getLog().info((CharSequence)("Generating JSON Schema for <packageName>" + packageName + "</packageName>"));
            this.generateSchema(packageName, true);
        }
        if (Util.isNullOrEmpty((Object[])this.classNames) && Util.isNullOrEmpty((Object[])this.packageNames) && !Util.isNullOrEmpty(this.annotations)) {
            this.getLog().info((CharSequence)"Generating JSON Schema for all annotated classes");
            this.generateSchema("**/*", false);
        }
    }

    private void generateSchema(String classOrPackageName, boolean targetPackage) throws MojoExecutionException {
        Predicate<String> filter = GlobHandler.createClassOrPackageNameFilter(classOrPackageName, targetPackage);
        List matchingClasses = this.getAllClassNames().stream().filter(entry -> filter.test(entry.getAbsolutePathToMatch())).sorted().collect(Collectors.toList());
        for (PotentialSchemaClass potentialTarget : matchingClasses) {
            if (potentialTarget.isAlreadyGenerated()) {
                this.getLog().info((CharSequence)("- Skipping already generated " + potentialTarget.getFullClassName()));
                continue;
            }
            this.generateSchema(potentialTarget);
            potentialTarget.setAlreadyGenerated();
        }
        if (matchingClasses.isEmpty()) {
            this.logForNoClassesMatchingFilter(classOrPackageName);
        }
    }

    private void generateSchema(PotentialSchemaClass potentialTarget) throws MojoExecutionException {
        Class<?> schemaClass = this.loadClass(potentialTarget.getFullClassName());
        if (this.skipInterfaces && schemaClass.isInterface()) {
            this.getLog().info((CharSequence)("- Skipping interface " + potentialTarget.getFullClassName()));
        } else if (this.skipAbstractTypes && this.isAbstractClass(schemaClass)) {
            this.getLog().info((CharSequence)("- Skipping abstract type " + potentialTarget.getFullClassName()));
        } else {
            this.generateSchema(schemaClass);
        }
    }

    private void generateSchema(Class<?> schemaClass) throws MojoExecutionException {
        ObjectNode jsonSchema = this.getGenerator().generateSchema(schemaClass, new Type[0]);
        File file = this.getSchemaFile(schemaClass);
        this.getLog().info((CharSequence)("- Writing schema to file: " + file));
        this.writeToFile((JsonNode)jsonSchema, file);
    }

    private void logForNoClassesMatchingFilter(String classOrPackageName) throws MojoExecutionException {
        StringBuilder message = new StringBuilder("No matching class found for \"").append(classOrPackageName).append("\" on classpath");
        if (!Util.isNullOrEmpty((Object[])this.excludeClassNames)) {
            message.append(" that wasn't excluded");
        }
        if (this.failIfNoClassesMatch) {
            message.append(".\nYou can change this error to a warning by setting: <failIfNoClassesMatch>false</failIfNoClassesMatch>");
            throw new MojoExecutionException(message.toString());
        }
        this.getLog().warn((CharSequence)message.toString());
    }

    private List<PotentialSchemaClass> getAllClassNames() {
        boolean considerAnnotations;
        if (this.allTypes != null) {
            return this.allTypes;
        }
        ClassGraph classGraph = new ClassGraph().overrideClasspath(this.classpath.getClasspathElements(this.project)).enableClassInfo();
        boolean bl = considerAnnotations = this.annotations != null && !this.annotations.isEmpty();
        if (considerAnnotations) {
            classGraph.enableAnnotationInfo();
        }
        ClassInfoList.ClassInfoFilter filter = this.createClassInfoFilter(considerAnnotations);
        try (ScanResult scanResult = classGraph.scan();){
            Stream<PotentialSchemaClass> allTypesStream = considerAnnotations ? this.annotations.stream().flatMap(a -> scanResult.getClassesWithAnnotation(a.className).filter(filter).stream()).distinct() : scanResult.getAllClasses().filter(filter).stream();
            this.allTypes = allTypesStream.map(PotentialSchemaClass::new).collect(Collectors.toList());
        }
        return this.allTypes;
    }

    private ClassInfoList.ClassInfoFilter createClassInfoFilter(boolean considerAnnotations) {
        Set<Predicate<String>> inclusions;
        Set exclusions = Util.nullSafe((Object[])this.excludeClassNames).stream().map(excludeEntry -> GlobHandler.createClassOrPackageNameFilter(excludeEntry, false)).collect(Collectors.toSet());
        if (considerAnnotations) {
            inclusions = Collections.singleton(input -> true);
        } else {
            inclusions = new HashSet<Predicate<String>>();
            Util.nullSafe((Object[])this.classNames).stream().map(className -> GlobHandler.createClassOrPackageNameFilter(className, false)).forEach(inclusions::add);
            Util.nullSafe((Object[])this.packageNames).stream().map(packageName -> GlobHandler.createClassOrPackageNameFilter(packageName, true)).forEach(inclusions::add);
        }
        return element -> {
            String classPathEntry = element.getName().replaceAll("\\.", "/");
            if (exclusions.stream().anyMatch(exclude -> exclude.test(classPathEntry))) {
                this.getLog().debug((CharSequence)("  Excluding: " + element.getName()));
                return false;
            }
            if (inclusions.stream().anyMatch(include -> include.test(classPathEntry))) {
                this.getLog().debug((CharSequence)("  Including: " + element.getName()));
                return true;
            }
            return false;
        };
    }

    private File getSchemaFile(Class<?> mainType) {
        File directory;
        if (this.schemaFilePath == null) {
            directory = new File("src" + File.separator + "main" + File.separator + "resources");
            this.getLog().debug((CharSequence)("- No 'schemaFilePath' configured. Applying default: " + directory));
        } else {
            directory = this.schemaFilePath;
        }
        String fileName = MessageFormat.format(this.schemaFileName, mainType.getSimpleName(), mainType.getPackage().getName().replace('.', File.separatorChar));
        File schemaFile = new File(directory, fileName);
        try {
            Files.createDirectories(schemaFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to ensure existence of " + schemaFile.getParent()), (Throwable)e);
        }
        return schemaFile;
    }

    private SchemaGenerator getGenerator() throws MojoExecutionException {
        if (this.generator == null) {
            this.getLog().debug((CharSequence)"Initializing Schema Generator");
            SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(this.schemaVersion, this.getOptionPreset());
            this.setOptions(configBuilder);
            this.setModules(configBuilder);
            SchemaGeneratorConfig config = configBuilder.build();
            this.generator = new SchemaGenerator(config);
        }
        return this.generator;
    }

    private OptionPreset getOptionPreset() {
        if (this.options != null && this.options.preset != null) {
            return this.options.preset.getPreset();
        }
        this.getLog().debug((CharSequence)"- No 'options/preset' configured. Applying default: PLAIN_JSON");
        return OptionPreset.PLAIN_JSON;
    }

    private void setOptions(SchemaGeneratorConfigBuilder configBuilder) {
        if (this.options != null) {
            Util.nullSafe((Object[])this.options.enabled).forEach(x$0 -> configBuilder.with(x$0, new Option[0]));
            Util.nullSafe((Object[])this.options.disabled).forEach(x$0 -> configBuilder.without(x$0, new Option[0]));
        }
    }

    private void setModules(SchemaGeneratorConfigBuilder configBuilder) throws MojoExecutionException {
        for (GeneratorModule module : Util.nullSafe((Object[])this.modules)) {
            if (!Util.isNullOrEmpty((String)module.className)) {
                this.addCustomModule(module.className, configBuilder);
                continue;
            }
            if (Util.isNullOrEmpty((String)module.name)) continue;
            this.addStandardModule(module, configBuilder);
        }
    }

    private void addCustomModule(String moduleClassName, SchemaGeneratorConfigBuilder configBuilder) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("- Adding custom Module " + moduleClassName));
        try {
            Class<?> moduleClass = this.loadClass(moduleClassName);
            Module moduleInstance = (Module)moduleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            configBuilder.with(moduleInstance);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MojoExecutionException("Error: Can not instantiate custom module " + moduleClassName, e);
        }
    }

    private void addStandardModule(GeneratorModule module, SchemaGeneratorConfigBuilder configBuilder) throws MojoExecutionException {
        switch (module.name) {
            case "Jackson": {
                this.getLog().debug((CharSequence)"- Adding Jackson Module");
                this.addStandardModuleWithOptions(module, configBuilder, JacksonSchemaModule::new, JacksonOption.class);
                break;
            }
            case "JakartaValidation": {
                this.getLog().debug((CharSequence)"- Adding Jakarta Validation Module");
                this.addStandardModuleWithOptions(module, configBuilder, JakartaValidationModule::new, JakartaValidationOption.class);
                break;
            }
            case "JavaxValidation": {
                this.getLog().debug((CharSequence)"- Adding Javax Validation Module");
                this.addStandardModuleWithOptions(module, configBuilder, JavaxValidationModule::new, JavaxValidationOption.class);
                break;
            }
            case "Swagger15": {
                this.getLog().debug((CharSequence)"- Adding Swagger 1.5 Module");
                this.addStandardModuleWithOptions(module, configBuilder, SwaggerModule::new, SwaggerOption.class);
                break;
            }
            case "Swagger2": {
                this.getLog().debug((CharSequence)"- Adding Swagger 2.x Module");
                configBuilder.with((Module)new Swagger2Module());
                break;
            }
            default: {
                throw new MojoExecutionException("Error: Module does not have a name in ['Jackson', 'JakartaValidation', 'JavaxValidation', 'Swagger15', 'Swagger2'] or does not have a custom classname.");
            }
        }
    }

    private <T extends Enum<T>> void addStandardModuleWithOptions(GeneratorModule module, SchemaGeneratorConfigBuilder configBuilder, Function<T[], Module> moduleConstructor, Class<T> optionType) throws MojoExecutionException {
        Stream.Builder<T> optionStream = Stream.builder();
        for (String optionName : Util.nullSafe((Object[])module.options)) {
            try {
                optionStream.add(Enum.valueOf(optionType, optionName));
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException("Error: Unknown " + module.name + " option " + optionName, (Exception)e);
            }
        }
        Enum[] options = (Enum[])optionStream.build().toArray(count -> (Enum[])Array.newInstance(optionType, count));
        configBuilder.with(moduleConstructor.apply(options));
    }

    private URLClassLoader getClassLoader() {
        if (this.classLoader == null) {
            List<URL> urls = ClasspathType.WITH_ALL_DEPENDENCIES_AND_TESTS.getUrls(this.project);
            this.classLoader = new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        }
        return this.classLoader;
    }

    private Class<?> loadClass(String className) throws MojoExecutionException {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Error loading class " + className, (Exception)e);
        }
    }

    private void writeToFile(JsonNode jsonSchema, File file) throws MojoExecutionException {
        ObjectMapper mapper = this.getGenerator().getConfig().getObjectMapper();
        try (FileOutputStream outputStream = new FileOutputStream(file);
             PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));){
            writer.print(mapper.writeValueAsString((Object)jsonSchema));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error: Can not write to file " + file, (Exception)e);
        }
    }

    private boolean isAbstractClass(Class<?> targetClass) {
        return Modifier.isAbstract(targetClass.getModifiers()) && !targetClass.isInterface();
    }
}

