/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnumModule
implements Module {
    private final Function<Enum<?>, String> enumConstantToString;

    public static EnumModule asStringsFromName() {
        return new EnumModule(Enum::name);
    }

    public static EnumModule asStringsFromToString() {
        return new EnumModule(Enum::toString);
    }

    public static EnumModule asObjects() {
        return new EnumModule(null);
    }

    public EnumModule(Function<Enum<?>, String> enumConstantToString) {
        this.enumConstantToString = enumConstantToString;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        if (this.enumConstantToString == null) {
            builder.forMethods().withIgnoreCheck(method -> EnumModule.isEnum(method.getDeclaringType()) && !"name".equals(method.getName())).withNullableCheck(method -> EnumModule.isEnum(method.getDeclaringType()) ? Boolean.FALSE : null).withEnumResolver(EnumModule::extractEnumValues);
            builder.forFields().withIgnoreCheck(field -> ((Field)field.getRawMember()).isEnumConstant());
        } else {
            builder.with(new EnumAsStringDefinitionProvider(builder.getObjectMapper(), this.enumConstantToString));
        }
    }

    private static boolean isEnum(ResolvedType type) {
        return type.getErasedType() == Enum.class;
    }

    private static List<String> extractEnumValues(MethodScope method) {
        ResolvedType declaringType = method.getDeclaringType();
        if (EnumModule.isEnum(declaringType)) {
            return EnumModule.extractEnumValues((ResolvedType)declaringType.getTypeParameters().get(0), Enum::name);
        }
        return null;
    }

    private static List<String> extractEnumValues(ResolvedType enumType, Function<Enum<?>, String> enumConstantToString) {
        Class erasedType = enumType.getErasedType();
        if (erasedType.getEnumConstants() == null) {
            return null;
        }
        return Stream.of(erasedType.getEnumConstants()).map(enumConstant -> (String)enumConstantToString.apply((Enum)enumConstant)).collect(Collectors.toList());
    }

    private static class EnumAsStringDefinitionProvider
    implements CustomDefinitionProviderV2 {
        private final ObjectMapper objectMapper;
        private final Function<Enum<?>, String> enumConstantToString;

        EnumAsStringDefinitionProvider(ObjectMapper objectMapper, Function<Enum<?>, String> enumConstantToString) {
            this.objectMapper = objectMapper;
            this.enumConstantToString = enumConstantToString;
        }

        @Override
        public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
            if (javaType.isInstanceOf(Enum.class)) {
                ObjectNode customNode = this.objectMapper.createObjectNode().put(context.getKeyword(SchemaKeyword.TAG_TYPE), context.getKeyword(SchemaKeyword.TAG_TYPE_STRING));
                new AttributeCollector(this.objectMapper).setEnum(customNode, EnumModule.extractEnumValues(javaType, this.enumConstantToString), context);
                return new CustomDefinition(customNode);
            }
            return null;
        }
    }
}

