/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.TypeScope;
import java.lang.reflect.Type;
import java.util.function.Predicate;

public class AdditionalPropertiesModule
implements Module {
    private final Predicate<TypeScope> exclusionCheck;

    public static AdditionalPropertiesModule forbiddenForAllObjectsButContainers() {
        return new AdditionalPropertiesModule(scope -> !scope.isContainerType());
    }

    public AdditionalPropertiesModule(Predicate<TypeScope> exclusionCheck) {
        this.exclusionCheck = exclusionCheck;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forTypesInGeneral().withAdditionalPropertiesResolver(this::resolveAdditionalProperties);
    }

    private Type resolveAdditionalProperties(TypeScope scope) {
        if (this.exclusionCheck.test(scope)) {
            return Void.class;
        }
        return null;
    }
}

