/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.impl.module.AdditionalPropertiesModule;
import com.github.victools.jsonschema.generator.impl.module.ConstantValueModule;
import com.github.victools.jsonschema.generator.impl.module.EnumModule;
import com.github.victools.jsonschema.generator.impl.module.FieldExclusionModule;
import com.github.victools.jsonschema.generator.impl.module.FlattenedOptionalModule;
import com.github.victools.jsonschema.generator.impl.module.InlineSchemaModule;
import com.github.victools.jsonschema.generator.impl.module.MethodExclusionModule;
import com.github.victools.jsonschema.generator.impl.module.SimpleTypeModule;
import com.github.victools.jsonschema.generator.impl.module.SimplifiedOptionalModule;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Option {
    SCHEMA_VERSION_INDICATOR(null, null, new Option[0]),
    ADDITIONAL_FIXED_TYPES(SimpleTypeModule::forPrimitiveAndAdditionalTypes, SimpleTypeModule::forPrimitiveTypes, new Option[0]),
    SIMPLIFIED_ENUMS(EnumModule::asObjects, null, new Option[0]),
    FLATTENED_ENUMS(EnumModule::asStringsFromName, null, SIMPLIFIED_ENUMS),
    FLATTENED_ENUMS_FROM_TOSTRING(EnumModule::asStringsFromToString, null, FLATTENED_ENUMS, SIMPLIFIED_ENUMS),
    SIMPLIFIED_OPTIONALS(() -> new SimplifiedOptionalModule(new String[0]), null, new Option[0]),
    FLATTENED_OPTIONALS(FlattenedOptionalModule::new, null, SIMPLIFIED_OPTIONALS),
    VALUES_FROM_CONSTANT_FIELDS(ConstantValueModule::new, null, new Option[0]),
    PUBLIC_STATIC_FIELDS(null, null, new Option[0]),
    PUBLIC_NONSTATIC_FIELDS(null, FieldExclusionModule::forPublicNonStaticFields, new Option[0]),
    NONPUBLIC_STATIC_FIELDS(null, null, new Option[0]),
    NONPUBLIC_NONSTATIC_FIELDS_WITH_GETTERS(null, FieldExclusionModule::forNonPublicNonStaticFieldsWithGetter, new Option[0]),
    NONPUBLIC_NONSTATIC_FIELDS_WITHOUT_GETTERS(null, FieldExclusionModule::forNonPublicNonStaticFieldsWithoutGetter, new Option[0]),
    TRANSIENT_FIELDS(null, FieldExclusionModule::forTransientFields, new Option[0]),
    STATIC_METHODS(null, null, new Option[0]),
    VOID_METHODS(null, MethodExclusionModule::forVoidMethods, new Option[0]),
    GETTER_METHODS(null, MethodExclusionModule::forGetterMethods, new Option[0]),
    NONSTATIC_NONVOID_NONGETTER_METHODS(null, MethodExclusionModule::forNonStaticNonVoidNonGetterMethods, new Option[0]),
    NULLABLE_FIELDS_BY_DEFAULT(null, null, new Option[0]),
    NULLABLE_METHOD_RETURN_VALUES_BY_DEFAULT(null, null, new Option[0]),
    MAP_VALUES_AS_ADDITIONAL_PROPERTIES(AdditionalPropertiesModule::forMapValues, null, new Option[0]),
    FORBIDDEN_ADDITIONAL_PROPERTIES_BY_DEFAULT(AdditionalPropertiesModule::forbiddenForAllObjectsButContainers, null, new Option[0]),
    DEFINITIONS_FOR_ALL_OBJECTS(null, null, new Option[0]),
    DEFINITION_FOR_MAIN_SCHEMA(null, null, new Option[0]),
    INLINE_ALL_SCHEMAS(InlineSchemaModule::new, null, DEFINITIONS_FOR_ALL_OBJECTS, DEFINITION_FOR_MAIN_SCHEMA),
    PLAIN_DEFINITION_KEYS(null, null, new Option[0]),
    ALLOF_CLEANUP_AT_THE_END(null, null, new Option[0]);

    private final Supplier<Module> enabledModuleProvider;
    private final Supplier<Module> disabledModuleProvider;
    private final Set<Option> overriddenOptions;

    private Option(Supplier<Module> enabledModuleProvider, Supplier<Module> disabledModuleProvider, Option ... overriddenOptions) {
        this.enabledModuleProvider = enabledModuleProvider;
        this.disabledModuleProvider = disabledModuleProvider;
        this.overriddenOptions = overriddenOptions == null || overriddenOptions.length == 0 ? Collections.emptySet() : Stream.of(overriddenOptions).collect(Collectors.toSet());
    }

    public boolean isOverriding(Option otherOption) {
        return this.overriddenOptions.contains((Object)otherOption);
    }

    Module getModule(boolean isEnabled) {
        Supplier<Module> targetModuleProvider = isEnabled ? this.enabledModuleProvider : this.disabledModuleProvider;
        return targetModuleProvider == null ? null : targetModuleProvider.get();
    }
}

