/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.github.victools.jsonschema.generator.ConfigFunction;
import com.github.victools.jsonschema.generator.InstanceAttributeOverride;
import com.github.victools.jsonschema.generator.MemberScope;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SchemaGeneratorConfigPart<M extends MemberScope<?, ?>> {
    private final List<InstanceAttributeOverride<M>> instanceAttributeOverrides = new ArrayList<InstanceAttributeOverride<M>>();
    private final List<Predicate<M>> ignoreChecks = new ArrayList<Predicate<M>>();
    private final List<Predicate<M>> requiredChecks = new ArrayList<Predicate<M>>();
    private final List<ConfigFunction<M, Boolean>> nullableChecks = new ArrayList<ConfigFunction<M, Boolean>>();
    private final List<ConfigFunction<M, ResolvedType>> targetTypeOverrideResolvers = new ArrayList<ConfigFunction<M, ResolvedType>>();
    private final List<ConfigFunction<M, String>> propertyNameOverrideResolvers = new ArrayList<ConfigFunction<M, String>>();
    private final List<ConfigFunction<M, String>> titleResolvers = new ArrayList<ConfigFunction<M, String>>();
    private final List<ConfigFunction<M, String>> descriptionResolvers = new ArrayList<ConfigFunction<M, String>>();
    private final List<ConfigFunction<M, Object>> defaultResolvers = new ArrayList<ConfigFunction<M, Object>>();
    private final List<ConfigFunction<M, Collection<?>>> enumResolvers = new ArrayList();
    private final List<ConfigFunction<M, Map<String, String>>> metadatas = new ArrayList<ConfigFunction<M, Map<String, String>>>();
    private final List<ConfigFunction<M, Integer>> stringMinLengthResolvers = new ArrayList<ConfigFunction<M, Integer>>();
    private final List<ConfigFunction<M, Integer>> stringMaxLengthResolvers = new ArrayList<ConfigFunction<M, Integer>>();
    private final List<ConfigFunction<M, String>> stringFormatResolvers = new ArrayList<ConfigFunction<M, String>>();
    private final List<ConfigFunction<M, String>> stringPatternResolvers = new ArrayList<ConfigFunction<M, String>>();
    private final List<ConfigFunction<M, BigDecimal>> numberInclusiveMinimumResolvers = new ArrayList<ConfigFunction<M, BigDecimal>>();
    private final List<ConfigFunction<M, BigDecimal>> numberExclusiveMinimumResolvers = new ArrayList<ConfigFunction<M, BigDecimal>>();
    private final List<ConfigFunction<M, BigDecimal>> numberInclusiveMaximumResolvers = new ArrayList<ConfigFunction<M, BigDecimal>>();
    private final List<ConfigFunction<M, BigDecimal>> numberExclusiveMaximumResolvers = new ArrayList<ConfigFunction<M, BigDecimal>>();
    private final List<ConfigFunction<M, BigDecimal>> numberMultipleOfResolvers = new ArrayList<ConfigFunction<M, BigDecimal>>();
    private final List<ConfigFunction<M, Integer>> arrayMinItemsResolvers = new ArrayList<ConfigFunction<M, Integer>>();
    private final List<ConfigFunction<M, Integer>> arrayMaxItemsResolvers = new ArrayList<ConfigFunction<M, Integer>>();
    private final List<ConfigFunction<M, Boolean>> arrayUniqueItemsResolvers = new ArrayList<ConfigFunction<M, Boolean>>();

    private static <M extends MemberScope<?, ?>, R> R getFirstDefinedValue(List<ConfigFunction<M, R>> resolvers, M member) {
        return resolvers.stream().map(resolver -> resolver.apply(member)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public SchemaGeneratorConfigPart<M> withInstanceAttributeOverride(InstanceAttributeOverride<M> override) {
        this.instanceAttributeOverrides.add(override);
        return this;
    }

    public List<InstanceAttributeOverride<M>> getInstanceAttributeOverrides() {
        return Collections.unmodifiableList(this.instanceAttributeOverrides);
    }

    public SchemaGeneratorConfigPart<M> withIgnoreCheck(Predicate<M> check) {
        this.ignoreChecks.add(check);
        return this;
    }

    public boolean shouldIgnore(M member) {
        return this.ignoreChecks.stream().anyMatch(check -> check.test(member));
    }

    public SchemaGeneratorConfigPart<M> withRequiredCheck(Predicate<M> check) {
        this.requiredChecks.add(check);
        return this;
    }

    public boolean isRequired(M member) {
        return this.requiredChecks.stream().anyMatch(check -> check.test(member));
    }

    public SchemaGeneratorConfigPart<M> withNullableCheck(ConfigFunction<M, Boolean> check) {
        this.nullableChecks.add(check);
        return this;
    }

    public Boolean isNullable(M member) {
        Set result = this.nullableChecks.stream().map(check -> (Boolean)check.apply(member)).filter(Objects::nonNull).collect(Collectors.toSet());
        return result.isEmpty() ? null : Boolean.valueOf(result.stream().anyMatch(value -> value));
    }

    public SchemaGeneratorConfigPart<M> withTargetTypeOverrideResolver(ConfigFunction<M, ResolvedType> resolver) {
        this.targetTypeOverrideResolvers.add(resolver);
        return this;
    }

    public ResolvedType resolveTargetTypeOverride(M member) {
        return (ResolvedType)SchemaGeneratorConfigPart.getFirstDefinedValue(this.targetTypeOverrideResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withPropertyNameOverrideResolver(ConfigFunction<M, String> resolver) {
        this.propertyNameOverrideResolvers.add(resolver);
        return this;
    }

    public String resolvePropertyNameOverride(M member) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.propertyNameOverrideResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withTitleResolver(ConfigFunction<M, String> resolver) {
        this.titleResolvers.add(resolver);
        return this;
    }

    public String resolveTitle(M member) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.titleResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withDescriptionResolver(ConfigFunction<M, String> resolver) {
        this.descriptionResolvers.add(resolver);
        return this;
    }

    public String resolveDescription(M member) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.descriptionResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withDefaultResolver(ConfigFunction<M, Object> resolver) {
        this.defaultResolvers.add(resolver);
        return this;
    }

    public Object resolveDefault(M member) {
        return SchemaGeneratorConfigPart.getFirstDefinedValue(this.defaultResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withEnumResolver(ConfigFunction<M, Collection<?>> resolver) {
        this.enumResolvers.add(resolver);
        return this;
    }

    public Collection<?> resolveEnum(M member) {
        return (Collection)SchemaGeneratorConfigPart.getFirstDefinedValue(this.enumResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withStringMinLengthResolver(ConfigFunction<M, Integer> resolver) {
        this.stringMinLengthResolvers.add(resolver);
        return this;
    }

    public Integer resolveStringMinLength(M member) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.stringMinLengthResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withStringMaxLengthResolver(ConfigFunction<M, Integer> resolver) {
        this.stringMaxLengthResolvers.add(resolver);
        return this;
    }

    public Integer resolveStringMaxLength(M member) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.stringMaxLengthResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withStringFormatResolver(ConfigFunction<M, String> resolver) {
        this.stringFormatResolvers.add(resolver);
        return this;
    }

    public String resolveStringFormat(M member) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.stringFormatResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withStringPatternResolver(ConfigFunction<M, String> resolver) {
        this.stringPatternResolvers.add(resolver);
        return this;
    }

    public String resolveStringPattern(M member) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.stringPatternResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withNumberInclusiveMinimumResolver(ConfigFunction<M, BigDecimal> resolver) {
        this.numberInclusiveMinimumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberInclusiveMinimum(M member) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberInclusiveMinimumResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withNumberExclusiveMinimumResolver(ConfigFunction<M, BigDecimal> resolver) {
        this.numberExclusiveMinimumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberExclusiveMinimum(M member) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberExclusiveMinimumResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withNumberInclusiveMaximumResolver(ConfigFunction<M, BigDecimal> resolver) {
        this.numberInclusiveMaximumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberInclusiveMaximum(M member) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberInclusiveMaximumResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withNumberExclusiveMaximumResolver(ConfigFunction<M, BigDecimal> resolver) {
        this.numberExclusiveMaximumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberExclusiveMaximum(M member) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberExclusiveMaximumResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withNumberMultipleOfResolver(ConfigFunction<M, BigDecimal> resolver) {
        this.numberMultipleOfResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberMultipleOf(M member) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberMultipleOfResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withArrayMinItemsResolver(ConfigFunction<M, Integer> resolver) {
        this.arrayMinItemsResolvers.add(resolver);
        return this;
    }

    public Integer resolveArrayMinItems(M member) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.arrayMinItemsResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withArrayMaxItemsResolver(ConfigFunction<M, Integer> resolver) {
        this.arrayMaxItemsResolvers.add(resolver);
        return this;
    }

    public Integer resolveArrayMaxItems(M member) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.arrayMaxItemsResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withArrayUniqueItemsResolver(ConfigFunction<M, Boolean> resolver) {
        this.arrayUniqueItemsResolvers.add(resolver);
        return this;
    }

    public Boolean resolveArrayUniqueItems(M member) {
        return (Boolean)SchemaGeneratorConfigPart.getFirstDefinedValue(this.arrayUniqueItemsResolvers, member);
    }
}

