/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.impl.ReflectionGetterUtils;
import java.util.function.BiPredicate;

public class FieldExclusionModule
implements Module {
    private final BiPredicate<ResolvedField, ResolvedTypeWithMembers> shouldExcludeFieldsMatching;

    public static FieldExclusionModule forPublicNonStaticFields() {
        return new FieldExclusionModule((field, declaringType) -> field.isPublic() && !field.isStatic());
    }

    public static FieldExclusionModule forNonPublicNonStaticFieldsWithGetter() {
        return new FieldExclusionModule((field, declaringType) -> !field.isPublic() && !field.isStatic() && ReflectionGetterUtils.hasGetter(field, declaringType));
    }

    public static FieldExclusionModule forNonPublicNonStaticFieldsWithoutGetter() {
        return new FieldExclusionModule((field, declaringType) -> !field.isPublic() && !field.isStatic() && !ReflectionGetterUtils.hasGetter(field, declaringType));
    }

    public static FieldExclusionModule forTransientFields() {
        return new FieldExclusionModule((field, declaringType) -> field.isTransient());
    }

    public FieldExclusionModule(BiPredicate<ResolvedField, ResolvedTypeWithMembers> shouldExcludeFieldsMatching) {
        this.shouldExcludeFieldsMatching = shouldExcludeFieldsMatching;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withIgnoreCheck(this.shouldExcludeFieldsMatching);
    }
}

